/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.migration.TypeSelectExpressionTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSelectExpression
extends FeatureCall {
    private Identifier typeLiteral;

    public TypeSelectExpression(int end, int endOffset, Identifier opName, Identifier typeLiteral, Expression target) {
        super(opName.getStart(), end, opName.getLine(), opName.getStartOffset(), endOffset, opName, target);
        this.typeLiteral = typeLiteral;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.typeLiteral + ")";
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object targetObj = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetObj = v.getValue();
            }
        } else {
            targetObj = this.getTarget().evaluate(ctx);
        }
        if (targetObj == null) {
            return null;
        }
        boolean cfr_ignored_0 = targetObj instanceof Collection;
        return this.executeTypeSelect((Collection)targetObj, ctx);
    }

    private Object executeTypeSelect(Collection collection, ExecutionContext ctx) {
        ArrayList resultCol = new ArrayList();
        EClassifier t = ctx.getTypeForName(this.typeLiteral.getValue());
        if (t == null) {
            throw new EvaluationException("Unkown type '" + this.typeLiteral + "'", (SyntaxElement)this.typeLiteral);
        }
        for (Object ele : collection) {
            if (ele == null || !BuiltinMetaModel.isAssignableFrom(t, BuiltinMetaModel.getType(ele))) continue;
            resultCol.add(ele);
        }
        return resultCol;
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier targetType = null;
        if (this.getTarget() == null) {
            Variable v = ctx.getVariable("this");
            if (v != null) {
                targetType = (EClassifier)v.getValue();
            }
        } else {
            targetType = this.getTarget().analyze(ctx, issues);
        }
        if (targetType == null) {
            return this.createAnalyzeTrace(ctx, new TypeSelectExpressionTrace(null, null));
        }
        if (!BuiltinMetaModel.isParameterizedType(targetType)) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Collection type expected! was : " + targetType, this.getTarget()));
            return null;
        }
        EClassifier closureEClassifier = ctx.getTypeForName(this.typeLiteral.getValue());
        if (closureEClassifier == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Couldn't find type " + this.typeLiteral, this.typeLiteral));
            return null;
        }
        return this.createAnalyzeTrace(ctx, new TypeSelectExpressionTrace((EClassifier)BuiltinMetaModel.getListType(closureEClassifier), targetType));
    }

    public Identifier getTypeLiteral() {
        return this.typeLiteral;
    }
}

