/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.util.IDEEditorUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class EcoreDiagramEditorUtil
extends IDEEditorUtil {
    public static final IFile createAndOpenDiagram(DiagramFileCreator diagramFileCreator, IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow window, IProgressMonitor progressMonitor, boolean openEditor, boolean saveDiagram) {
        IFile diagramFile = EcoreDiagramEditorUtil.createNewDiagramFile(diagramFileCreator, containerPath, fileName, initialContents, kind, window.getShell(), progressMonitor);
        if (diagramFile != null && openEditor) {
            IDEEditorUtil.openDiagram((IFile)diagramFile, (IWorkbenchWindow)window, (boolean)saveDiagram, (IProgressMonitor)progressMonitor);
        }
        return diagramFile;
    }

    public static final IFile createNewDiagramFile(DiagramFileCreator diagramFileCreator, IPath containerFullPath, String fileName, InputStream initialContents, String kind, Shell shell, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        progressMonitor.beginTask("Creating diagram and model files", 4);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
        final IFile diagramFile = diagramFileCreator.createNewFile(containerFullPath, fileName, initialContents, shell, new IRunnableContext((IProgressMonitor)subProgressMonitor){
            private final /* synthetic */ IProgressMonitor val$subProgressMonitor;
            {
                this.val$subProgressMonitor = iProgressMonitor;
            }

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run(this.val$subProgressMonitor);
            }
        });
        final Resource diagramResource = resourceSet.createResource(URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString()));
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add(diagramFile);
        IPath modelFileRelativePath = diagramFile.getFullPath().removeFileExtension().addFileExtension("ecore");
        IFile modelFile = diagramFile.getParent().getFile((IPath)new Path(modelFileRelativePath.lastSegment()));
        final Resource modelResource = resourceSet.createResource(URI.createPlatformResourceURI((String)modelFile.getFullPath().toString()));
        affectedFiles.add(modelFile);
        final String kindParam = kind;
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Creating diagram and model", affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EPackage model = EcoreDiagramEditorUtil.createInitialModel();
                modelResource.getContents().add((Object)EcoreDiagramEditorUtil.createInitialRoot(model));
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)kindParam, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramFile.getName());
                    diagram.setElement((EObject)model);
                }
                try {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("ENCODING", "UTF-8");
                    modelResource.save(options);
                    diagramResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        try {
            modelFile.setCharset("UTF-8", (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (CoreException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to set charset for model file", e);
        }
        try {
            diagramFile.setCharset("UTF-8", (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (CoreException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to set charset for diagram file", e);
        }
        return diagramFile;
    }

    private static EPackage createInitialModel() {
        return EcoreFactory.eINSTANCE.createEPackage();
    }

    private static EObject createInitialRoot(EPackage model) {
        return model;
    }
}

