/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class CreateViewAndOptionallyElementCommand
extends AbstractCommand {
    private IAdaptable elementAdapter;
    private Point location;
    private IGraphicalEditPart containerEP;
    private Command command = null;
    private ObjectAdapter resultAdapter = new ObjectAdapter();
    private PreferencesHint preferencesHint;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CreateViewAndOptionallyElementCommand(IAdaptable elementAdapter, IGraphicalEditPart containerEP, Point location, PreferencesHint preferencesHint) {
        super(DiagramUIMessages.CreateCommand_Label, null);
        this.setElementAdapter(elementAdapter);
        this.setContainerEP(containerEP);
        if (location != null) {
            this.setLocation(location);
        } else {
            this.setLocation(this.getContainerEP().getFigure().getBounds().getTopRight().translate(100, 100));
        }
        this.setPreferencesHint(preferencesHint);
    }

    public List getAffectedFiles() {
        View view;
        if (this.containerEP != null && (view = (View)this.containerEP.getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }

    protected View getExistingView(EObject element) {
        IGraphicalEditPart theTarget = (IGraphicalEditPart)this.findChildEditPart((EditPart)this.getContainerEP(), element);
        if (theTarget != null) {
            return (View)theTarget.getModel();
        }
        return null;
    }

    private EditPart findChildEditPart(EditPart editpart, EObject theElement) {
        if (theElement == null) {
            return null;
        }
        ListIterator childLI = editpart.getChildren().listIterator();
        while (childLI.hasNext()) {
            EObject el;
            EditPart epChild = (EditPart)childLI.next();
            Object model = epChild.getModel();
            if (!(model instanceof View) || (el = ((View)model).getElement()) == null || !el.equals(theElement)) continue;
            return epChild;
        }
        return null;
    }

    protected boolean useExistingView(View view) {
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 192);
        messageBox.setText(DiagramUIMessages.CreateViewAndOptionallyElementCommand_ViewExists_Title);
        messageBox.setMessage(NLS.bind((String)DiagramUIMessages.CreateViewAndOptionallyElementCommand_ViewExists_Message, (Object)EMFCoreUtil.getName((EObject)view.getElement())));
        return messageBox.open() == 64;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IGraphicalEditPart target;
        CreateViewRequest createRequest;
        EObject element;
        IAdaptable iAdaptable = this.getElementAdapter();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = (EObject)iAdaptable.getAdapter((Class)clazz)) == null) {
            IElementType type;
            IAdaptable iAdaptable2 = this.getElementAdapter();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.IElementType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((type = (IElementType)iAdaptable2.getAdapter((Class)clazz2)) == null) {
                return CommandResult.newErrorCommandResult((String)this.getLabel());
            }
            createRequest = CreateViewRequestFactory.getCreateShapeRequest(type, this.getPreferencesHint());
        } else {
            createRequest = new CreateViewRequest(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(element), this.getPreferencesHint()));
        }
        createRequest.setLocation(this.getLocation());
        if (createRequest != null && (target = (IGraphicalEditPart)this.getContainerEP().getTargetEditPart((Request)createRequest)) != null) {
            Command theCmd = target.getCommand((Request)createRequest);
            this.setCommand(theCmd);
            View theExistingView = this.getExistingView(element);
            if (theExistingView != null && this.useExistingView(theExistingView)) {
                this.setResult((IAdaptable)new EObjectAdapter((EObject)theExistingView));
                return CommandResult.newOKCommandResult((Object)this.getResult());
            }
            if (this.getCommand().canExecute()) {
                ICommand cmd = DiagramCommandStack.getICommand(this.getCommand());
                cmd.execute(progressMonitor, info);
                if (progressMonitor.isCanceled()) {
                    return CommandResult.newCancelledCommandResult();
                }
                if (!cmd.getCommandResult().getStatus().isOK()) {
                    return cmd.getCommandResult();
                }
                Object obj = ((List)createRequest.getNewObject()).get(0);
                this.setResult((IAdaptable)obj);
                return CommandResult.newOKCommandResult((Object)this.getResult());
            }
        }
        this.containerEP = null;
        return CommandResult.newErrorCommandResult((String)this.getLabel());
    }

    public boolean canUndo() {
        return this.getCommand() != null && this.getCommand().canUndo();
    }

    public boolean canRedo() {
        return CommandUtilities.canRedo(this.command);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.getCommand() != null) {
            this.getCommand().redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.getCommand() != null) {
            this.getCommand().undo();
        }
        return CommandResult.newOKCommandResult();
    }

    public IAdaptable getResult() {
        return this.resultAdapter;
    }

    protected void setResult(IAdaptable viewAdapter) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gmf.runtime.notation.View");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        View view = (View)viewAdapter.getAdapter((Class)clazz);
        this.resultAdapter.setObject((Object)view);
    }

    protected IAdaptable getElementAdapter() {
        return this.elementAdapter;
    }

    protected void setElementAdapter(IAdaptable elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    protected Point getLocation() {
        return this.location;
    }

    protected void setLocation(Point location) {
        this.location = location;
    }

    protected IGraphicalEditPart getContainerEP() {
        return this.containerEP;
    }

    protected void setContainerEP(IGraphicalEditPart containerEP) {
        this.containerEP = containerEP;
    }

    protected PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    protected void setPreferencesHint(PreferencesHint preferencesHint) {
        this.preferencesHint = preferencesHint;
    }

    protected Command getCommand() {
        return this.command;
    }

    protected void setCommand(Command command) {
        this.command = command;
    }
}

