/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.services.elementselection;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractElementSelectionInput;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionScope;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionService;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionInput;
import org.eclipse.gmf.tests.runtime.common.ui.services.dialogs.TestElementSelectionProviderContext;
import org.eclipse.jface.viewers.IFilter;

public class ElementSelectionUserInputTest
extends TestCase {
    private AbstractElementSelectionInput input;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        ElementSelectionScope scope = ElementSelectionScope.VISIBLE;
        TestElementSelectionProviderContext context = new TestElementSelectionProviderContext();
        IFilter filter = new IFilter(){

            public boolean select(Object toTest) {
                return true;
            }
        };
        this.input = new AbstractElementSelectionInput(filter, (IAdaptable)context, scope, "");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.input = null;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ElementSelectionUserInputTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.ui.services.elementselection.ElementSelectionUserInputTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testBlankUserInput() {
        this.input.setInput("");
        List matches = ElementSelectionService.getInstance().getMatchingObjects((IElementSelectionInput)this.input);
        ElementSelectionUserInputTest.assertTrue((matches.size() == 0 ? 1 : 0) != 0);
    }

    public void testFullNameUserInput() {
        this.input.setInput("one");
        List matches = ElementSelectionService.getInstance().getMatchingObjects((IElementSelectionInput)this.input);
        ElementSelectionUserInputTest.assertTrue((matches.size() == 3 ? 1 : 0) != 0);
    }

    public void testNamePrefixUserInput() {
        this.input.setInput("t");
        List matches = ElementSelectionService.getInstance().getMatchingObjects((IElementSelectionInput)this.input);
        ElementSelectionUserInputTest.assertTrue((matches.size() == 6 ? 1 : 0) != 0);
    }

    public void testAnotherNamePrefixUserInput() {
        this.input.setInput("th");
        List matches = ElementSelectionService.getInstance().getMatchingObjects((IElementSelectionInput)this.input);
        ElementSelectionUserInputTest.assertTrue((matches.size() == 3 ? 1 : 0) != 0);
    }

    public void testAnyStringUserInput() {
        this.input.setInput("t*ee");
        List matches = ElementSelectionService.getInstance().getMatchingObjects((IElementSelectionInput)this.input);
        ElementSelectionUserInputTest.assertTrue((matches.size() == 3 ? 1 : 0) != 0);
    }

    public void testOnCharacterUserInput() {
        this.input.setInput("t?ree");
        List matches = ElementSelectionService.getInstance().getMatchingObjects((IElementSelectionInput)this.input);
        ElementSelectionUserInputTest.assertTrue((matches.size() == 3 ? 1 : 0) != 0);
    }
}

