/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestCommandCallback;

public class DiagramGraphicalViewerTests
extends AbstractTestBase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.logic.DiagramGraphicalViewerTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite s = new TestSuite((Class)clazz);
        return s;
    }

    public DiagramGraphicalViewerTests() {
        super("Diagram Graphical Viewer Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected LogicTestFixture getLogicTestFixture() {
        return (LogicTestFixture)this.getTestFixture();
    }

    public void testIDToEditPartRegistry() throws Exception {
        LogicTestFixture fixture = this.getLogicTestFixture();
        fixture.openDiagram();
        Rectangle rect = new Rectangle(this.getDiagramEditPart().getFigure().getBounds());
        this.getDiagramEditPart().getFigure().translateToAbsolute((Translatable)rect);
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
        Point createPt = new Point(100, 100);
        LEDEditPart led1EP = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(led1EP.getFigure().getSize().getExpanded(100, 100));
        LEDEditPart led2EP = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(led2EP.getFigure().getSize().getExpanded(100, 100));
        final IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)this.getDiagramEditPart().getViewer();
        EObject led1 = led1EP.getNotationView().getElement();
        EObject led2 = led2EP.getNotationView().getElement();
        final String led1ID = ((XMLResource)led1.eResource()).getID(led1);
        final String led2ID = ((XMLResource)led2.eResource()).getID(led2);
        EObject outputTerminal = (EObject)((LED)((View)led1EP.getModel()).getElement()).getOutputTerminals().get(0);
        String string = ((XMLResource)outputTerminal.eResource()).getID(outputTerminal);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TerminalEditPart outputTerminalEP = (TerminalEditPart)viewer.findEditPartsForElement(string, (Class)clazz).get(0);
        EObject inputTerminal = (EObject)((LED)((View)led2EP.getModel()).getElement()).getInputTerminals().get(0);
        String string2 = ((XMLResource)inputTerminal.eResource()).getID(inputTerminal);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TerminalEditPart inputTerminalEP = (TerminalEditPart)viewer.findEditPartsForElement(string2, (Class)clazz2).get(0);
        ConnectionEditPart wireEP = this.getLogicTestFixture().createConnectorUsingTool((IGraphicalEditPart)outputTerminalEP, (IGraphicalEditPart)inputTerminalEP, typeWire);
        EObject wire = ((View)wireEP.getModel()).getElement();
        String wireID = ((XMLResource)wire.eResource()).getID(wire);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DiagramGraphicalViewerTests.assertEquals((String)"Number of LEDEditPart for led1ID incorrect", (int)1, (int)viewer.findEditPartsForElement(led1ID, (Class)clazz3).size());
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.gef.ConnectionEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DiagramGraphicalViewerTests.assertEquals((String)"Number of ConnectionEditParts for led1ID incorrect", (int)0, (int)viewer.findEditPartsForElement(led1ID, (Class)clazz4).size());
        View shape3 = this.createShapeView(this.getDiagramEditPart(), ViewUtil.resolveSemanticElement((View)led2EP.getNotationView()), new Point(100, 200));
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DiagramGraphicalViewerTests.assertEquals((String)"Number of ShapeEditParts for led2ID incorrect", (int)2, (int)viewer.findEditPartsForElement(led2ID, (Class)clazz5).size());
        DeleteCommand delete = new DeleteCommand(this.getLogicTestFixture().getEditingDomain(), shape3);
        this.testCommand((ICommand)delete, new ITestCommandCallback(){

            public void onCommandExecution() {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DiagramGraphicalViewerTests.assertEquals((String)"Number of LEDEditParts for led1ID incorrect", (int)1, (int)viewer.findEditPartsForElement(led1ID, (Class)clazz).size());
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DiagramGraphicalViewerTests.assertEquals((String)"Number of LEDEditParts for led2ID incorrect", (int)1, (int)viewer.findEditPartsForElement(led2ID, (Class)clazz2).size());
            }
        });
        this.clearDiagram();
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DiagramGraphicalViewerTests.assertEquals((String)"Number of IGraphicalEditParts for led1ID incorrect", (int)0, (int)viewer.findEditPartsForElement(led1ID, (Class)clazz6).size());
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DiagramGraphicalViewerTests.assertEquals((String)"Number of IGraphicalEditParts for led2ID incorrect", (int)0, (int)viewer.findEditPartsForElement(led2ID, (Class)clazz7).size());
        Class<?> clazz8 = class$5;
        if (clazz8 == null) {
            try {
                clazz8 = class$5 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DiagramGraphicalViewerTests.assertEquals((String)"Number of IGraphicalEditParts for wireID incorrect", (int)0, (int)viewer.findEditPartsForElement(wireID, (Class)clazz8).size());
    }
}

