/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.AndGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.FlowContainer;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Model;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.OrGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.XORGate;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.ConnectionCreationTool;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.swt.graphics.RGB;

public class LogicViewRefactorTests
extends AbstractTestBase {
    public static Test suite() {
        TestSuite s = new TestSuite(LogicViewRefactorTests.class);
        return s;
    }

    public LogicViewRefactorTests() {
        super("Logic View Refactor Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new LogicRefactorTestFixture();
    }

    protected LogicRefactorTestFixture getLogicRefactorTestFixture() {
        return (LogicRefactorTestFixture)this.getTestFixture();
    }

    public void test_RefactorANDIntoXOR() {
        try {
            final IGraphicalEditPart andEP = this.getLogicRefactorTestFixture().getAndEP();
            final int color = FigureUtilities.RGBToInteger((RGB)new RGB(255, 0, 255));
            TransactionalEditingDomain editingDomain = this.getLogicRefactorTestFixture().getEditingDomain();
            this.getLogicRefactorTestFixture().execute((ICommand)new AbstractTransactionalCommand(editingDomain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    Node node = (Node)andEP.getNotationView();
                    Bounds bounds = (Bounds)node.getLayoutConstraint();
                    bounds.setX(800);
                    bounds.setY(3000);
                    FillStyle fStyle = (FillStyle)node.getStyle(NotationPackage.eINSTANCE.getFillStyle());
                    fStyle.setFillColor(color);
                    return CommandResult.newOKCommandResult();
                }
            });
            IElementType typeXor = ElementTypeRegistry.getInstance().getType("logic.xorgate");
            final Circuit circuit = (Circuit)ViewUtil.getContainerView((View)andEP.getNotationView()).getElement();
            CreateElementRequest createRequest = new CreateElementRequest(editingDomain, (EObject)circuit, typeXor);
            ICommand command = typeXor.getEditHelper().getEditCommand((IEditCommandRequest)createRequest);
            this.getLogicRefactorTestFixture().execute(command);
            LogicViewRefactorTests.assertTrue((String)"Xor creation failed", (circuit.getChildren().size() == 6 ? 1 : 0) != 0);
            Collection results = this.getLogicRefactorTestFixture().execute((ICommand)new AbstractTransactionalCommand(editingDomain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    AndGate oldObject = (AndGate)circuit.getChildren().get(1);
                    XORGate newObject = (XORGate)circuit.getChildren().get(5);
                    newObject.getTerminals().clear();
                    newObject.getTerminals().addAll((Collection)oldObject.getTerminals());
                    new ViewRefactorHelper(PreferencesHint.USE_DEFAULTS).refactor((EObject)oldObject, (EObject)newObject);
                    DestroyElementCommand.destroy((EObject)oldObject);
                    return CommandResult.newOKCommandResult((Object)newObject);
                }
            });
            XORGate xorGate = (XORGate)results.iterator().next();
            Collection newNodes = EMFCoreUtil.getReferencers((EObject)xorGate, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getView_Element()});
            LogicViewRefactorTests.assertFalse((String)"morphing view failed", (boolean)newNodes.isEmpty());
            Node newNode = (Node)newNodes.iterator().next();
            Bounds bounds = (Bounds)newNode.getLayoutConstraint();
            LogicViewRefactorTests.assertEquals((int)800, (int)bounds.getX());
            LogicViewRefactorTests.assertEquals((int)3000, (int)bounds.getY());
            FillStyle fStyle = (FillStyle)newNode.getStyle(NotationPackage.eINSTANCE.getFillStyle());
            LogicViewRefactorTests.assertEquals((int)color, (int)fStyle.getFillColor());
            LogicViewRefactorTests.assertEquals((int)1, (int)((Node)newNode.getChildren().get(0)).getTargetEdges().size());
            LogicViewRefactorTests.assertEquals((int)1, (int)((Node)newNode.getChildren().get(2)).getSourceEdges().size());
        }
        catch (Exception e) {
            LogicViewRefactorTests.assertTrue((String)e.toString(), (boolean)false);
        }
    }

    public void test_RefactorCircuitIntoLogicFlow() {
        try {
            final IGraphicalEditPart circuitEP = (IGraphicalEditPart)this.getLogicRefactorTestFixture().getAndEP().getParent().getParent();
            TransactionalEditingDomain editingDomain = this.getLogicRefactorTestFixture().getEditingDomain();
            final int color = FigureUtilities.RGBToInteger((RGB)new RGB(255, 0, 255));
            this.getLogicRefactorTestFixture().execute((ICommand)new AbstractTransactionalCommand(editingDomain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    Node node = (Node)circuitEP.getNotationView();
                    Bounds bounds = (Bounds)node.getLayoutConstraint();
                    bounds.setX(1000);
                    bounds.setY(1000);
                    FillStyle fStyle = (FillStyle)node.getStyle(NotationPackage.eINSTANCE.getFillStyle());
                    fStyle.setFillColor(color);
                    return CommandResult.newOKCommandResult();
                }
            });
            IElementType typeFlowContainer = ElementTypeRegistry.getInstance().getType("logic.flowcontainer");
            final Model model = (Model)ViewUtil.getContainerView((View)circuitEP.getNotationView()).getElement();
            CreateElementRequest createRequest = new CreateElementRequest(editingDomain, (EObject)model, typeFlowContainer);
            this.getLogicRefactorTestFixture().execute(typeFlowContainer.getEditHelper().getEditCommand((IEditCommandRequest)createRequest));
            LogicViewRefactorTests.assertTrue((String)"Flow Container creation failed", (model.getChildren().size() == 2 ? 1 : 0) != 0);
            Collection results = this.getLogicRefactorTestFixture().execute((ICommand)new AbstractTransactionalCommand(editingDomain, "", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    Circuit oldObject = (Circuit)model.getChildren().get(0);
                    FlowContainer newObject = (FlowContainer)model.getChildren().get(1);
                    newObject.getChildren().clear();
                    newObject.getChildren().addAll((Collection)oldObject.getChildren());
                    new ViewRefactorHelper(PreferencesHint.USE_DEFAULTS){

                        protected void copyViewChild(View oldView, View newView, Node oldChildNode) {
                            if (oldChildNode.getType().equals("LogicCompartment")) {
                                Node newChildNode = (Node)ViewUtil.getChildBySemanticHint((View)newView, (String)"LogicFlowCompartment");
                                if (newChildNode != null) {
                                    this.copyNodeFeatures(oldChildNode, newChildNode);
                                }
                            } else {
                                super.copyViewChild(oldView, newView, oldChildNode);
                            }
                        }
                    }.refactor((EObject)oldObject, (EObject)newObject);
                    DestroyElementCommand.destroy((EObject)oldObject);
                    return CommandResult.newOKCommandResult((Object)newObject);
                }
            });
            FlowContainer flowContainer = (FlowContainer)results.iterator().next();
            Collection newNodes = EMFCoreUtil.getReferencers((EObject)flowContainer, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getView_Element()});
            LogicViewRefactorTests.assertFalse((String)"morphing view failed", (boolean)newNodes.isEmpty());
            Node newNode = (Node)newNodes.iterator().next();
            Bounds bounds = (Bounds)newNode.getLayoutConstraint();
            LogicViewRefactorTests.assertEquals((int)1000, (int)bounds.getX());
            LogicViewRefactorTests.assertEquals((int)1000, (int)bounds.getY());
            FillStyle fStyle = (FillStyle)newNode.getStyle(NotationPackage.eINSTANCE.getFillStyle());
            LogicViewRefactorTests.assertEquals((int)color, (int)fStyle.getFillColor());
        }
        catch (Exception e) {
            LogicViewRefactorTests.assertTrue((String)e.toString(), (boolean)false);
        }
    }

    private class LogicRefactorTestFixture
    extends LogicTestFixture {
        private IGraphicalEditPart andEP;

        private LogicRefactorTestFixture() {
        }

        public IGraphicalEditPart getAndEP() {
            return this.andEP;
        }

        protected void createShapesAndConnectors() throws Exception {
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            CreateViewAndElementRequest shapeRequest = new CreateViewAndElementRequest(typeCircuit, this.getPreferencesHint());
            shapeRequest.setLocation(new Point(20, 20));
            shapeRequest.setSize(new Dimension(200, 200));
            this.execute(this.getDiagramEditPart().getCommand((Request)shapeRequest));
            LogicRefactorTestFixture.assertFalse((String)"Circuit creation failed", (boolean)this.getDiagramEditPart().getChildren().isEmpty());
            IGraphicalEditPart circuitEP = (IGraphicalEditPart)this.getDiagramEditPart().getChildren().get(0);
            IGraphicalEditPart logicCompartmentEP = circuitEP.getChildBySemanticHint("LogicCompartment");
            IElementType typeLed = ElementTypeRegistry.getInstance().getType("logic.led");
            shapeRequest = new CreateViewAndElementRequest(typeLed, this.getPreferencesHint());
            shapeRequest.setLocation(new Point(30, 30));
            this.execute(logicCompartmentEP.getCommand((Request)shapeRequest));
            LogicRefactorTestFixture.assertTrue((String)"Led creation failed", (logicCompartmentEP.getChildren().size() == 1 ? 1 : 0) != 0);
            IElementType typeAnd = ElementTypeRegistry.getInstance().getType("logic.andgate");
            shapeRequest = new CreateViewAndElementRequest(typeAnd, this.getPreferencesHint());
            shapeRequest.setLocation(new Point(30, 110));
            this.execute(logicCompartmentEP.getCommand((Request)shapeRequest));
            LogicRefactorTestFixture.assertTrue((String)"And gate creation failed", (logicCompartmentEP.getChildren().size() == 2 ? 1 : 0) != 0);
            IElementType typeOr = ElementTypeRegistry.getInstance().getType("logic.orgate");
            shapeRequest = new CreateViewAndElementRequest(typeOr, this.getPreferencesHint());
            shapeRequest.setLocation(new Point(100, 110));
            this.execute(logicCompartmentEP.getCommand((Request)shapeRequest));
            LogicRefactorTestFixture.assertTrue((String)"Or gate creation failed", (logicCompartmentEP.getChildren().size() == 3 ? 1 : 0) != 0);
            this.flushEventQueue();
            IGraphicalEditPart ledEP = (IGraphicalEditPart)logicCompartmentEP.getChildren().get(0);
            LED led = (LED)ledEP.getAdapter(LED.class);
            this.andEP = (IGraphicalEditPart)logicCompartmentEP.getChildren().get(1);
            AndGate andGate = (AndGate)this.andEP.getAdapter(AndGate.class);
            IGraphicalEditPart orEP = (IGraphicalEditPart)logicCompartmentEP.getChildren().get(2);
            OrGate orGate = (OrGate)orEP.getAdapter(OrGate.class);
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            Terminal outTerminal1 = (Terminal)led.getOutputTerminals().get(3);
            IGraphicalEditPart outTerminalEP1 = (IGraphicalEditPart)ledEP.findEditPart(null, (EObject)outTerminal1);
            Terminal inTerminal1 = (Terminal)andGate.getInputTerminals().get(0);
            IGraphicalEditPart inTerminalEP1 = (IGraphicalEditPart)this.andEP.findEditPart(null, (EObject)inTerminal1);
            this.createConnectorUsingTool(outTerminalEP1, inTerminalEP1, typeWire);
            LogicRefactorTestFixture.assertTrue((String)"Led to And gate connection failed", (this.getDiagramEditPart().getConnections().size() == 1 ? 1 : 0) != 0);
            Terminal outTerminal2 = (Terminal)andGate.getOutputTerminals().get(0);
            IGraphicalEditPart outTerminalEP2 = (IGraphicalEditPart)this.andEP.findEditPart(null, (EObject)outTerminal2);
            Terminal inTerminal2 = (Terminal)orGate.getInputTerminals().get(0);
            IGraphicalEditPart inTerminalEP2 = (IGraphicalEditPart)orEP.findEditPart(null, (EObject)inTerminal2);
            this.createConnectorUsingTool(outTerminalEP2, inTerminalEP2, typeWire);
            LogicRefactorTestFixture.assertTrue((String)"And to Or gate connection failed", (this.getDiagramEditPart().getConnections().size() == 2 ? 1 : 0) != 0);
        }

        public ConnectionEditPart createConnectorUsingTool(IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart, IElementType elementType) {
            class ConnectorCreationTool
            extends ConnectionCreationTool {
                public ConnectorCreationTool(IElementType theElementType) {
                    super(theElementType);
                }

                public Request createTargetRequest() {
                    return super.createTargetRequest();
                }

                protected PreferencesHint getPreferencesHint() {
                    return PreferencesHint.USE_DEFAULTS;
                }
            }
            ConnectorCreationTool tool = new ConnectorCreationTool(elementType);
            CreateConnectionRequest request = (CreateConnectionRequest)tool.createTargetRequest();
            request.setTargetEditPart((EditPart)sourceEditPart);
            request.setType((Object)"connection start");
            sourceEditPart.getCommand((Request)request);
            request.setSourceEditPart((EditPart)sourceEditPart);
            request.setTargetEditPart((EditPart)targetEditPart);
            request.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)request);
            this.getCommandStack().execute(cmd);
            Object newView = ((IAdaptable)request.getNewObject()).getAdapter(View.class);
            LogicRefactorTestFixture.assertNotNull((Object)newView);
            ConnectionEditPart newConnector = (ConnectionEditPart)this.getDiagramEditPart().getViewer().getEditPartRegistry().get(newView);
            LogicRefactorTestFixture.assertNotNull((Object)newConnector);
            return newConnector;
        }
    }
}

