/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.expression.ast;

import org.eclipse.gmf.internal.xpand.expression.ast.BooleanLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.Case;
import org.eclipse.gmf.internal.xpand.expression.ast.Cast;
import org.eclipse.gmf.internal.xpand.expression.ast.ChainExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.IfExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.IntegerLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.ListLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.NullLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.OperationCall;
import org.eclipse.gmf.internal.xpand.expression.ast.StringLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.SwitchExpression;
import org.eclipse.gmf.tests.expression.ast.AbstractExpressionTest;

public class ParserTest
extends AbstractExpressionTest {
    public final void testSimple() {
        Expression expr = this.parse("true == null");
        ParserTest.assertTrue((boolean)(expr instanceof OperationCall));
        OperationCall op = (OperationCall)expr;
        ParserTest.assertTrue((boolean)(op.getTarget() instanceof BooleanLiteral));
        ParserTest.assertTrue((boolean)(op.getParams()[0] instanceof NullLiteral));
    }

    public final void testSimple2() {
        Expression expr = this.parse("String.feature.test(true, {\"test\",\"hallo\"})");
        ParserTest.assertTrue((boolean)(expr instanceof OperationCall));
        OperationCall op = (OperationCall)expr;
        ParserTest.assertEquals((String)"test", (String)op.getName().getValue());
        ParserTest.assertTrue((boolean)(op.getTarget() instanceof FeatureCall));
        FeatureCall tl = (FeatureCall)op.getTarget();
        ParserTest.assertEquals((String)"feature", (String)tl.getName().getValue());
        tl = (FeatureCall)tl.getTarget();
        ParserTest.assertEquals((String)"String", (String)tl.getName().getValue());
        ParserTest.assertTrue((op.getParams().length == 2 ? 1 : 0) != 0);
        ParserTest.assertTrue((boolean)(op.getParams()[0] instanceof BooleanLiteral));
        ListLiteral colLit = (ListLiteral)op.getParams()[1];
        ParserTest.assertEquals((int)2, (int)colLit.getElements().length);
        ParserTest.assertEquals((String)"\"test\"", (String)((StringLiteral)colLit.getElements()[0]).getLiteralValue());
        ParserTest.assertEquals((String)"\"hallo\"", (String)((StringLiteral)colLit.getElements()[1]).getLiteralValue());
    }

    public final void testIfExpression() {
        Expression expr = this.parse("(client.sIdent1 != null) ? client.sIdent1 : \"XXXXXXXX\"");
        ParserTest.assertTrue((boolean)(expr instanceof IfExpression));
    }

    public final void testEscaped() {
        Expression expr = this.parse("\"\\\"\"");
        ParserTest.assertTrue((boolean)(expr instanceof StringLiteral));
        ParserTest.assertEquals((String)"\"", (String)((StringLiteral)expr).getValue());
    }

    public final void testNot() {
        Expression expr = this.parse("! ts.checked");
        ParserTest.assertNotNull((Object)expr);
    }

    public final void testCast() {
        Expression expr = this.parse("(List[InnerType]) anExpr");
        ParserTest.assertNotNull((Object)expr);
        Cast cast = (Cast)expr;
        ParserTest.assertEquals((String)"List[InnerType]", (String)cast.getType().getValue());
        FeatureCall fc = (FeatureCall)cast.getTarget();
        ParserTest.assertEquals((String)"anExpr", (String)fc.getName().getValue());
        ParserTest.assertNull((Object)fc.getTarget());
    }

    public final void testSwitch() {
        SwitchExpression expr = (SwitchExpression)this.parse("switch (5) { default : true }");
        ParserTest.assertNotNull((Object)expr.getSwitchExpr());
        ParserTest.assertTrue((boolean)expr.getCases().isEmpty());
        ParserTest.assertEquals((String)"true", (String)((BooleanLiteral)expr.getDefaultExpr()).getLiteralValue());
        expr = (SwitchExpression)this.parse("switch (\"test\") { case \"horst\": false default : true }");
        ParserTest.assertEquals((String)"\"test\"", (String)((StringLiteral)expr.getSwitchExpr()).getLiteralValue());
        Case c = (Case)expr.getCases().get(0);
        ParserTest.assertEquals((String)"\"horst\"", (String)((StringLiteral)c.getCondition()).getLiteralValue());
        ParserTest.assertEquals((String)"false", (String)((BooleanLiteral)c.getThenPart()).getLiteralValue());
        ParserTest.assertEquals((String)"true", (String)((BooleanLiteral)expr.getDefaultExpr()).getLiteralValue());
    }

    public final void testChainExpression() {
        ChainExpression expr = (ChainExpression)this.parse("1 -> 2 -> 3 -> 4");
        ParserTest.assertEquals((String)"4", (String)expr.getNext().toString());
        ParserTest.assertEquals((String)"1->2->3", (String)expr.getFirst().toString());
    }

    public final void testPositionInfo() {
        Expression exp = this.parse("\n\n\n1");
        ParserTest.assertEquals((int)4, (int)exp.getLine());
        ParserTest.assertEquals((int)0, (int)exp.getStart());
        ParserTest.assertEquals((int)1, (int)exp.getEnd());
    }

    public final void testPositionInfo2() {
        Expression exp = this.parse("/*\n\n\n*/1");
        ParserTest.assertEquals((int)4, (int)exp.getLine());
        ParserTest.assertEquals((int)2, (int)exp.getStart());
        ParserTest.assertEquals((int)3, (int)exp.getEnd());
    }

    public final void testPositionInfo3() {
        OperationCall exp = (OperationCall)this.parse("'/*\\n\\n\\n*/'+1");
        ParserTest.assertEquals((int)1, (int)exp.getLine());
        ParserTest.assertEquals((int)0, (int)exp.getStart());
        ParserTest.assertEquals((int)14, (int)exp.getEnd());
        StringLiteral target = (StringLiteral)exp.getTarget();
        ParserTest.assertEquals((int)1, (int)target.getLine());
        ParserTest.assertEquals((int)0, (int)target.getStart());
        ParserTest.assertEquals((int)12, (int)target.getEnd());
        IntegerLiteral param = (IntegerLiteral)exp.getParams()[0];
        ParserTest.assertEquals((int)1, (int)param.getLine());
        ParserTest.assertEquals((int)13, (int)param.getStart());
        ParserTest.assertEquals((int)14, (int)param.getEnd());
    }

    public final void testTypeLiterals() {
        Expression e = this.parse("{  Object,\n String,\n Collection[A],\n Set[B],\n List[C],\n oaw::Type,\n oaw::Feature,\n oaw::Property\n}");
        ParserTest.assertNotNull((Object)e);
    }
}

