/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.gmf.internal.validate.expressions.EnvironmentProvider;
import org.eclipse.gmf.internal.validate.expressions.ExpressionProviderRegistry;
import org.eclipse.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpressionProvider;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;
import org.eclipse.gmf.tests.EPath;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.LinksSessionSetup;

public class OCLExpressionAdapterTest
extends TestCase {
    EClassifier context;
    IModelExpressionProvider provider;
    EPath modelAccess;

    public OCLExpressionAdapterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.context = EcorePackage.eINSTANCE.getEClass();
        this.provider = ExpressionProviderRegistry.getInstance().getProvider("ocl");
        OCLExpressionAdapterTest.assertNotNull((String)"OCL expression provider must be available", (Object)this.provider);
        this.modelAccess = EPath.createEcorePathFromModel(Plugin.createURI(LinksSessionSetup.modelURI));
    }

    public void testEnvVariables() throws Exception {
        EClassifier oclIntegerType = this.provider.createExpression("'aString'", this.context).getResultType();
        EClassifier oclBooleanType = this.provider.createExpression("true", this.context).getResultType();
        IParseEnvironment env = EnvironmentProvider.createParseEnv();
        env.setVariable("intVar", oclIntegerType);
        env.setVariable("boolVar", oclBooleanType);
        Integer intVal = new Integer(1);
        Boolean boolVal = new Boolean(true);
        IEvaluationEnvironment evalEnv = EnvironmentProvider.createEvaluationEnv();
        evalEnv.setVariable("intVar", (Object)intVal);
        evalEnv.setVariable("boolVar", (Object)boolVal);
        EClass contextInstance = EcorePackage.eINSTANCE.getEClass();
        OCLExpressionAdapterTest.assertSame((Object)intVal, (Object)this.provider.createExpression("intVar", this.context, env).evaluate((Object)contextInstance, evalEnv));
        OCLExpressionAdapterTest.assertSame((Object)boolVal, (Object)this.provider.createExpression("boolVar", this.context, env).evaluate((Object)contextInstance, evalEnv));
    }

    public void testAssignReferenceMany() throws Exception {
        EReference ref = this.modelAccess.findReference("//Root/elements");
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("null.oclAsType(links::Node)").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertTrue((boolean)ref.getEReferenceType().isSuperTypeOf(this.modelAccess.findClass("//Node")));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("null.oclAsType(links::Container)").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertTrue((boolean)ref.getEReferenceType().isSuperTypeOf(this.modelAccess.findClass("//Container")));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("Bag { null.oclAsType(links::Container) }").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("null.oclAsType(links::Root)").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertFalse((boolean)ref.getEReferenceType().isSuperTypeOf(this.modelAccess.findClass("//Root")));
    }

    public void testAssignReferenceSingle() throws Exception {
        EReference ref = this.modelAccess.findReference("//Link/target");
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("null.oclAsType(links::Node)").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertTrue((boolean)ref.getEReferenceType().isSuperTypeOf(this.modelAccess.findClass("//Node")));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("null.oclAsType(links::Container)").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertTrue((boolean)ref.getEReferenceType().isSuperTypeOf(this.modelAccess.findClass("//Container")));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("null.oclAsType(links::Root)").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertFalse((boolean)ref.getEReferenceType().isSuperTypeOf(this.modelAccess.findClass("//Root")));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("Bag{null.oclAsType(links::Root)}").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertFalse((boolean)ref.getEReferenceType().isSuperTypeOf(this.modelAccess.findClass("//Root")));
    }

    public void testOCL_TypeType() throws Exception {
        EAttribute feature = this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEClassifier());
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("links::TestEnum").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("links::TestEnum::LIT1").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("ecore::EInt").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertFalse((String)"Collection can't be assigned to scalar", (boolean)this.expression("Bag{ecore::EInt}").isAssignableToElement((ETypedElement)feature));
        feature.setUpperBound(-1);
        OCLExpressionAdapterTest.assertTrue((String)"Scalar should allowed to intialize feature[0..*]", (boolean)this.expression("ecore::EInt").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("Bag{ecore::EInt, ecore::EInt}").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("Bag{links::TestEnum}").isAssignableToElement((ETypedElement)feature));
        EReference ref = this.createRef(EcorePackage.eINSTANCE.getEClass());
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("ecore::EInt").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("links::Node").isAssignableToElement((ETypedElement)ref));
        ref.setUpperBound(-1);
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("Bag{links::Node}").isAssignableToElement((ETypedElement)ref));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("Bag{ecore::EInt}").isAssignableToElement((ETypedElement)ref));
    }

    public void testOCLTypes() throws Exception {
        EAttribute feature = this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEDouble());
        OCLExpressionAdapterTest.assertTrue((String)"Integer should be taken as Real", (boolean)this.expression("self->size()").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertFalse((String)"Cardinality mismatch", (boolean)this.expression("Sequence{10}").isAssignableToElement((ETypedElement)feature));
        feature.setUpperBound(-1);
        OCLExpressionAdapterTest.assertTrue((String)"Bag must be compatible to feature [0..*]", (boolean)this.expression("Bag{self->size()/*int*/}").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((String)"Sequence must be compatible to feature [0..*]", (boolean)this.expression("Sequence{self->size()/*int*/}").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((String)"Set must be compatible to feature [0..*]", (boolean)this.expression("Set{self->size()/*int*/}").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((String)"OrderedSet must be compatible to feature [0..*]", (boolean)this.expression("OrderedSet{self->size()/*int*/}").isAssignableToElement((ETypedElement)feature));
        OCLExpressionAdapterTest.assertTrue((String)"OrderedSet must be compatible to feature [0..*]", (boolean)this.expression("Bag{ 10, 5.33 }").isAssignableToElement((ETypedElement)feature));
        EAttribute intFeature = this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEInt());
        OCLExpressionAdapterTest.assertFalse((String)"Real can't be assigned to Integer", (boolean)this.expression("1.55").isAssignableToElement((ETypedElement)intFeature));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("15").isAssignableToElement((ETypedElement)intFeature));
    }

    public void testPrimitivesConversion() throws Exception {
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("true").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEBoolean())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("true").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEInt())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEShort())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEShortObject())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getELong())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getELongObject())));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEInt())));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject())));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEShort())));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEShortObject())));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getELong())));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getELongObject())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEFloat())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEFloatObject())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEDouble())));
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("1.5").isAssignableToElement((ETypedElement)this.createAttr((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject())));
    }

    public void testEnumerationLiteral() throws Exception {
        EAttribute attr = this.modelAccess.findAttribute("//Container/enumAttr_Init");
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("links::TestEnum::LIT1").isAssignableToElement((ETypedElement)attr));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("links::TestEnum").isAssignableToElement((ETypedElement)attr));
        EAttribute manyEnumsAttr = this.createAttr(this.modelAccess.lookup("//TestEnum", EClassifier.class));
        manyEnumsAttr.setUpperBound(-1);
        OCLExpressionAdapterTest.assertTrue((boolean)this.expression("Bag{links::TestEnum::LIT0, links::TestEnum::LIT1}").isAssignableToElement((ETypedElement)manyEnumsAttr));
        OCLExpressionAdapterTest.assertFalse((boolean)this.expression("Bag{links::TestEnum}").isAssignableToElement((ETypedElement)manyEnumsAttr));
    }

    IModelExpression expression(String body) throws Exception {
        EPackageRegistryImpl reg = new EPackageRegistryImpl();
        reg.putAll((Map)EPackage.Registry.INSTANCE);
        EPackage model = this.modelAccess.lookup("/", EPackage.class);
        reg.put((Object)model.getNsURI(), (Object)model);
        IParseEnvironment env = EnvironmentProvider.createParseEnv();
        env.setImportRegistry((EPackage.Registry)reg);
        IModelExpression expression = this.provider.createExpression(body, this.context, env);
        OCLExpressionAdapterTest.assertTrue((String)("Invalid body: " + expression.getStatus().getMessage()), (boolean)expression.getStatus().isOK());
        return expression;
    }

    EAttribute createAttr(EClassifier eType) {
        OCLExpressionAdapterTest.assertNotNull((String)"non-null type required ", (Object)eType);
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        attribute.setName("myFeature_" + eType.getName());
        attribute.setEType(eType);
        return attribute;
    }

    EReference createRef(EClass eType) {
        OCLExpressionAdapterTest.assertNotNull((String)"non-null type required ", (Object)eType);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("myFeature_" + eType.getName());
        ref.setEType((EClassifier)eType);
        return ref;
    }
}

