/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.tr.AbstractMappingTransformerTest;

public abstract class GenModelTransformerTest
extends AbstractMappingTransformerTest {
    protected GenEditorGenerator myTransformationResult;
    private DiagramGenModelTransformer myTransformer;
    private final DiagramRunTimeModelHelper myDiagramModelHelper;

    protected GenModelTransformerTest(String name, DiagramRunTimeModelHelper rtHelper) {
        super(name);
        assert (rtHelper != null);
        this.myDiagramModelHelper = rtHelper;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Mapping m = this.getMapping();
        this.myTransformer = new DiagramGenModelTransformer(this.myDiagramModelHelper);
        this.myTransformer.setEMFGenModel(Utils.createGenModel(m.getDiagram().getDomainModel()));
        this.myTransformer.transform(m);
        this.myTransformationResult = this.myTransformer.getResult();
    }

    public void testGenModelTransform() {
        GenModelTransformerTest.assertNotNull((String)"GenEditorGenerator is expected as result of mapping transformation", (Object)this.myTransformationResult);
        GenModelTransformerTest.assertNotNull((String)"GenDiagram is expected to be set...", (Object)this.myTransformationResult.getDiagram());
        GenModelTransformerTest.assertNotNull((String)"... as well as GenPlugin is expected to be set", (Object)this.myTransformationResult.getPlugin());
        GenModelTransformerTest.assertNotNull((String)"Diagram filename extension not set", (Object)this.myTransformationResult.getDiagramFileExtension());
        GenNode[] genNodes = this.myTransformer.getTrace().find(this.getNodeMapping());
        GenModelTransformerTest.assertEquals((String)"Result model contains no GenNode for nodeMapping", (int)1, (int)genNodes.length);
        GenLink genLink = this.myTransformer.getTrace().find(this.getLinkMapping());
        GenModelTransformerTest.assertNotNull((String)"Result model contains no GenLink for linkMapping", (Object)genLink);
    }

    public void testCreatedPalette() {
        Palette palette = this.myTransformationResult.getDiagram().getPalette();
        for (TopNodeReference topNode : this.getMapping().getNodes()) {
            NodeMapping nodeMapping = topNode.getChild();
            GenTopLevelNode genNode = this.myTransformer.getTrace().findTopNode(nodeMapping);
            GenModelTransformerTest.assertNotNull((Object)genNode);
            GenModelTransformerTest.assertEquals((int)(nodeMapping.getTool() != null ? 1 : 0), (int)GenModelTransformerTest.countUses((GenCommonBase)genNode, palette));
        }
        for (LinkMapping linkMapping : this.getMapping().getLinks()) {
            GenLink genLink = this.myTransformer.getTrace().find(linkMapping);
            GenModelTransformerTest.assertNotNull((Object)genLink);
            GenModelTransformerTest.assertEquals((int)(linkMapping.getTool() != null ? 1 : 0), (int)GenModelTransformerTest.countUses((GenCommonBase)genLink, palette));
        }
    }

    private static int countUses(GenCommonBase genElement, Palette palette) {
        int uses = 0;
        for (ToolGroup nextGroup : palette.getGroups()) {
            for (ToolGroupItem item : nextGroup.getEntries()) {
                if (!(item instanceof ToolEntry)) continue;
                for (GenCommonBase cb : ((ToolEntry)item).getElements()) {
                    if (cb != genElement) continue;
                    ++uses;
                }
            }
        }
        return uses;
    }
}

