/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gmf.internal.xpand.codeassist.ExpandProposalComputer;
import org.eclipse.gmf.internal.xpand.codeassist.FastAnalyzer;
import org.eclipse.gmf.internal.xpand.codeassist.KeywordProposalComputer;
import org.eclipse.gmf.internal.xpand.codeassist.ProposalFactoryImpl;
import org.eclipse.gmf.internal.xpand.codeassist.StatementProposalComputer;
import org.eclipse.gmf.internal.xpand.codeassist.XpandPartition;
import org.eclipse.gmf.internal.xpand.editor.Activator;
import org.eclipse.gmf.internal.xpand.editor.EditorImages;
import org.eclipse.gmf.internal.xpand.editor.XpandEditor;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ExpressionProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.TypeProposalComputer;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;

public class XpandContentAssistProcessor
implements IContentAssistProcessor {
    private final XpandEditor editor;
    private final ProposalComparator comparator;

    public XpandContentAssistProcessor(XpandEditor editor) {
        this.editor = editor;
        this.comparator = new ProposalComparator();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        try {
            IDocument doc = viewer.getDocument();
            String txt = doc.get(0, documentOffset);
            int additionalTextLen = Math.min(doc.getLength(), documentOffset + doc.getLineLength(doc.getLineOfOffset(documentOffset))) - documentOffset;
            String textPastInsertionPoint = doc.get(documentOffset, additionalTextLen);
            ExecutionContext ctx = this.editor.createContext();
            XpandPartition p = FastAnalyzer.computePartition(txt);
            if (p == XpandPartition.COMMENT) {
                return new ICompletionProposal[0];
            }
            List<Object> proposals = new ArrayList(20);
            Point selectedRange = viewer.getSelectedRange();
            assert (selectedRange.x == documentOffset);
            ProposalFactoryImpl f = new ProposalFactoryImpl(documentOffset, selectedRange.y, EditorImages.get());
            if (p == XpandPartition.TYPE_DECLARATION) {
                ctx = FastAnalyzer.computeExecutionContext(txt, ctx);
                proposals = new TypeProposalComputer(f).computeProposals(txt, ctx);
                Collections.sort(proposals, this.comparator);
            } else if (p == XpandPartition.EXPRESSION) {
                ctx = FastAnalyzer.computeExecutionContext(txt, ctx);
                String expression = txt.substring(txt.lastIndexOf(171) + 1);
                List<ICompletionProposal> ep = new ExpressionProposalComputer(f).computeProposals(expression, ctx);
                Collections.sort(ep, this.comparator);
                proposals.addAll(ep);
                List<ICompletionProposal> kp = new KeywordProposalComputer(textPastInsertionPoint, f).computeProposals(txt, ctx);
                Collections.sort(kp, this.comparator);
                proposals.addAll(kp);
            } else if (p == XpandPartition.EXPAND_STATEMENT) {
                ctx = FastAnalyzer.computeExecutionContext(txt, ctx);
                List<ICompletionProposal> ep = new ExpandProposalComputer(doc.get(), f).computeProposals(txt, ctx);
                Collections.sort(ep, this.comparator);
                proposals.addAll(ep);
            } else if (p == XpandPartition.DEFAULT) {
                ctx = FastAnalyzer.computeExecutionContext(txt, ctx);
                List<ICompletionProposal> sp = new StatementProposalComputer(f).computeProposals(txt, ctx);
                Collections.sort(sp, this.comparator);
                proposals.addAll(sp);
                proposals.add(new CompletionProposal("\u00ab\u00bb", documentOffset, 0, 1));
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        catch (Exception e) {
            Activator.logError(e);
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal p1, ICompletionProposal p2) {
            return p1.getDisplayString().compareTo(p2.getDisplayString());
        }
    }
}

