/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.IOException;
import java.io.Reader;
import lpg.lpgjavaruntime.LexStream;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.StreamConverter;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExtensionFile;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;
import org.eclipse.gmf.internal.xpand.xtend.parser.XtendLexer;
import org.eclipse.gmf.internal.xpand.xtend.parser.XtendParser;

public class XtendResourceParser {
    public XtendResource parse(Reader source, String name) throws IOException, ParserException {
        ExtensionFile tpl = null;
        XtendLexer scanner = null;
        XtendParser parser = null;
        char[] buffer = new StreamConverter().toCharArray(source);
        try {
            scanner = new XtendLexer(buffer, name);
            parser = new XtendParser((LexStream)scanner);
            scanner.lexer(parser);
            tpl = parser.parser();
        }
        catch (Exception exception) {
            ParserException.ErrorLocationInfo[] errors = XtendResourceParser.extractErrors(scanner, parser);
            if (errors.length == 0) {
                throw new IOException("Unexpected exception while parsing");
            }
            throw new ParserException(name, errors);
        }
        if (tpl != null) {
            tpl.setFullyQualifiedName(name);
            return tpl;
        }
        ParserException.ErrorLocationInfo[] errors = XtendResourceParser.extractErrors(scanner, parser);
        assert (errors.length > 0) : "otherwise, no reason not to get template";
        throw new ParserException(name, errors);
    }

    private static ParserException.ErrorLocationInfo[] extractErrors(XtendLexer scanner, XtendParser parser) {
        ParserException.ErrorLocationInfo[] e1 = scanner.getErrors();
        ParserException.ErrorLocationInfo[] e2 = parser.getErrors();
        ParserException.ErrorLocationInfo[] res = new ParserException.ErrorLocationInfo[e1.length + e2.length];
        System.arraycopy(e1, 0, res, 0, e1.length);
        System.arraycopy(e2, 0, res, e1.length, e2.length);
        return res;
    }
}

