/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.MappingExtensionHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalAstWalker;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ReturnExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.QVTUMLReflection;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.parser.ValidationVisitor;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.ocl.utilities.Visitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalValidationVisitor
extends QvtOperationalAstWalker {
    private QvtOperationalEnv fEnv;

    public QvtOperationalValidationVisitor(QvtOperationalEnv environment) {
        super(new ValidationNodeProcessor(environment));
        this.fEnv = environment;
    }

    @Override
    public Object visitMappingCallExp(MappingCallExp mappingCallExp) {
        MappingOperation mappingOperation;
        if (mappingCallExp.getReferredOperation() instanceof MappingOperation && QvtOperationalUtil.hasAbstractOutputParamerter(mappingOperation = (MappingOperation)mappingCallExp.getReferredOperation()) && QvtOperationalParserUtil.isAbstractMappingOperation(mappingOperation) && mappingOperation.getDisjunct().isEmpty()) {
            String errMessage = NLS.bind((String)ValidationMessages.directCallToAbstractMappingDisallowed, (Object)QvtOperationalParserUtil.safeGetMappingQualifiedName(this.fEnv, mappingOperation));
            this.fEnv.reportError(errMessage, mappingCallExp.getStartPosition(), mappingCallExp.getEndPosition());
        }
        return super.visitMappingCallExp(mappingCallExp);
    }

    @Override
    public Object visitReturnExp(ReturnExp returnExp) {
        OperationBody body = QvtOperationalParserUtil.findParentElement(returnExp, OperationBody.class);
        if (body != null && body.getOperation() != null) {
            EClassifier actualType = (EClassifier)returnExp.getType();
            EClassifier declaredType = body.getOperation().getEType();
            if (actualType != null && declaredType != null) {
                int rel = TypeUtil.getRelationship((Environment)this.fEnv, (Object)actualType, (Object)declaredType);
                if ((rel & 3) == 0) {
                    String typeName = QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, declaredType);
                    this.fEnv.reportError(NLS.bind((String)ValidationMessages.typeMismatchError, (Object)typeName), returnExp.getStartPosition(), returnExp.getEndPosition());
                }
                if (returnExp.getValue() == null && !body.getOperation().getResult().isEmpty()) {
                    this.fEnv.reportError(ValidationMessages.missingReturnValueError, returnExp.getStartPosition(), returnExp.getEndPosition());
                }
            } else {
                if (actualType != null && returnExp.getValue() == null && declaredType == this.fEnv.getOCLStandardLibrary().getOclVoid()) {
                    return Boolean.TRUE;
                }
                String typeName = QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, declaredType);
                this.fEnv.reportError(NLS.bind((String)ValidationMessages.typeMismatchError, (Object)typeName), returnExp.getStartPosition(), returnExp.getEndPosition());
            }
            if (body instanceof MappingBody) {
                this.fEnv.reportError(ValidationMessages.returnNotAllowedInMappingYet, returnExp.getStartPosition(), returnExp.getEndPosition());
            }
        } else {
            this.fEnv.reportError(ValidationMessages.returnUsedOutsideOperationBody, returnExp.getStartPosition(), returnExp.getEndPosition());
        }
        return super.visitReturnExp(returnExp);
    }

    @Override
    public Object visitMappingOperation(MappingOperation operation) {
        boolean result = MappingExtensionHelper.validate(operation, this.fEnv);
        for (VarParameter resultParam : operation.getResult()) {
            result &= this.validateOutParamType(resultParam);
        }
        for (EParameter nextEParam : operation.getEParameters()) {
            VarParameter varParameter;
            if (!(nextEParam instanceof VarParameter) || (varParameter = (VarParameter)nextEParam).getKind() != DirectionKind.OUT) continue;
            result &= this.validateOutParamType(varParameter);
        }
        if (Boolean.TRUE.equals(super.visitMappingOperation(operation)) && result) {
            return true;
        }
        return false;
    }

    @Override
    public Object visitImperativeOperation(ImperativeOperation imperativeOperation) {
        EClassifier eType;
        boolean result = true;
        VarParameter context = imperativeOperation.getContext();
        if (context != null && !QvtOperationalValidationVisitor.isValidContextualType(eType = context.getEType())) {
            result = false;
            String errMessage = NLS.bind((String)ValidationMessages.QvtOperationalValidationVisitor_invalidContextualType, (Object)QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, eType));
            this.fEnv.reportError(errMessage, context.getStartPosition(), context.getEndPosition());
        }
        this.validateUniqueParamNames(imperativeOperation);
        for (EParameter nextEParam : imperativeOperation.getEParameters()) {
            VarParameter varParameter = (VarParameter)nextEParam;
            this.validateParamNameRequired(varParameter);
        }
        for (VarParameter nextResultParam : imperativeOperation.getResult()) {
            this.validateParamNameRequired(nextResultParam);
            if (nextResultParam.getKind() == DirectionKind.OUT) continue;
            this.fEnv.reportError(ValidationMessages.QvtOperationalValidationVisitor_resultParamDirectionMustBeOut, nextResultParam.getStartPosition(), nextResultParam.getEndPosition());
        }
        if (Boolean.TRUE.equals(super.visitImperativeOperation(imperativeOperation)) && result) {
            return true;
        }
        return false;
    }

    @Override
    public Object visitOperationBody(OperationBody operationBody) {
        ImperativeOperation operation;
        if (!(operationBody instanceof MappingBody) && (operation = operationBody.getOperation()).getEType() != null && operation.getEType() != this.fEnv.getOCLStandardLibrary().getOclVoid()) {
            EList<OCLExpression<EClassifier>> content = operationBody.getContent();
            if (operation.getResult().size() == 1 && (content.isEmpty() || !(content.get(content.size() - 1) instanceof ReturnExp))) {
                ImperativeOperation problemTarget = operation;
                String message = ValidationMessages.useReturnExpForOperationResult;
                this.fEnv.reportWarning(message, problemTarget.getStartPosition(), operationBody.getStartPosition());
            }
        }
        return super.visitOperationBody(operationBody);
    }

    private static boolean isValidContextualType(EClassifier type) {
        return type != null && !QVTUMLReflection.isModuleInstance(type);
    }

    private boolean validateOutParamType(VarParameter resultParam) {
        boolean result = true;
        EClassifier paramType = resultParam.getEType();
        if (paramType != null && (QVTUMLReflection.isModelTypeInstance(paramType) || QVTUMLReflection.isModuleInstance(paramType))) {
            result = false;
            this.fEnv.reportError(NLS.bind((String)ValidationMessages.nonModelTypeError, (Object)QvtOperationalParserUtil.safeGetQualifiedName(this.fEnv, paramType)), resultParam.getStartPosition(), resultParam.getEndPosition());
        }
        return result;
    }

    private void validateUniqueParamNames(ImperativeOperation operation) {
        List<ModelParameter> modelParams = QvtOperationalValidationVisitor.getModelParamsInScope(operation);
        EList regularParams = operation.getEParameters();
        EList<VarParameter> resultParams = operation.getResult();
        this.validateUniqueParamNames((List)regularParams, (List)modelParams);
        this.validateUniqueParamNames((List)regularParams, (List)regularParams);
        this.validateUniqueParamNames((List)resultParams, (List)modelParams);
        this.validateUniqueParamNames((List)resultParams, (List)regularParams);
        this.validateUniqueParamNames((List)resultParams, (List)resultParams);
    }

    private static List<ModelParameter> getModelParamsInScope(ImperativeOperation mappingOperation) {
        Module module = QvtOperationalParserUtil.getOwningModule(mappingOperation);
        return module != null ? module.getModelParameter() : Collections.emptyList();
    }

    private boolean validateParamNameRequired(VarParameter param) {
        boolean result = true;
        String name = param.getName();
        if (name == null || name.trim().length() == 0) {
            result = false;
            this.fEnv.reportError(ValidationMessages.QvtOperationalValidationVisitor_parameterNamedRequired, param.getStartPosition(), param.getEndPosition());
        }
        return result;
    }

    private <T extends VarParameter> boolean validateUniqueParamNames(List<? extends T> params, List<? extends T> scopeParameters) {
        boolean result = true;
        for (VarParameter nextParam : params) {
            VarParameter sameNameParam;
            if (nextParam.getName() == null || (sameNameParam = (VarParameter)QvtOperationalValidationVisitor.findParamByName(nextParam.getName(), scopeParameters)) == null || sameNameParam == nextParam) continue;
            result = false;
            this.fEnv.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_15, (Object[])new Object[]{nextParam.getName()}), nextParam.getStartPosition(), nextParam.getEndPosition());
        }
        return result;
    }

    private static <T extends EParameter> T findParamByName(String name, List<T> parameters) {
        for (EParameter nextParam : parameters) {
            String paramName = nextParam.getName();
            if (!(name != null ? name.equals(paramName) : name == paramName)) continue;
            return (T)nextParam;
        }
        return null;
    }

    private static class ValidationNodeProcessor
    implements QvtOperationalAstWalker.NodeProcessor {
        final Visitor<Boolean, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> myOclValidationVisitor;

        ValidationNodeProcessor(QvtOperationalEnv environment) {
            this.myOclValidationVisitor = ValidationVisitor.getInstance((Environment)environment);
        }

        public void process(Visitable e, Visitable parent) throws QvtOperationalAstWalker.StopException {
            try {
                e.accept(this.myOclValidationVisitor);
            }
            catch (Throwable throwable) {}
        }
    }
}

