/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNode;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNodeAccess;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.temp.ScopedNameCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.MetamodelElementHyperlink;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.ecore.PropertyCallExp;

public class ObjectPropertyHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode syntaxElement = context.getSyntaxElement();
        EStructuralFeature referredFeature = ObjectPropertyHyperlinkDetector.findDefinition(syntaxElement);
        if (referredFeature != null) {
            ModulePropertyCS propertyCS = ObjectPropertyHyperlinkDetector.findDefinitionCS(referredFeature);
            if (propertyCS != null) {
                URI sourceFileURI = CSTHelper.getSourceFile((CSTNode)propertyCS);
                ModulePropertyCS destNodeCS = propertyCS.getSimpleNameCS() != null ? propertyCS.getSimpleNameCS() : propertyCS;
                IRegion destRegion = HyperlinkUtil.createRegion((CSTNode)destNodeCS);
                return new QvtFileHyperlink(HyperlinkUtil.createRegion(syntaxElement), sourceFileURI, destRegion, destRegion);
            }
            return new MetamodelElementHyperlink(HyperlinkUtil.createRegion(syntaxElement), (EModelElement)referredFeature);
        }
        return null;
    }

    public static ModulePropertyCS findDefinitionCS(EStructuralFeature referencedFeature) {
        ASTSyntheticNode referencedDefinitionAST = ASTSyntheticNodeAccess.getASTNode((EObject)referencedFeature);
        ModulePropertyCS referencedDefinitionCS = referencedDefinitionAST != null ? (ModulePropertyCS)ASTSyntheticNodeAccess.getCST((ASTSyntheticNode)referencedDefinitionAST, ModulePropertyCS.class) : (ModulePropertyCS)ASTBindingHelper.resolveCSTNode((EObject)referencedFeature, ModulePropertyCS.class);
        return referencedDefinitionCS;
    }

    public static EStructuralFeature findDefinition(CSTNode syntaxElement) {
        if (syntaxElement instanceof SimpleNameCS || syntaxElement instanceof ScopedNameCS) {
            Object ast = syntaxElement.getAst();
            if (ast instanceof EStructuralFeature) {
                return (EStructuralFeature)ast;
            }
            if (ast instanceof PropertyCallExp) {
                return (EStructuralFeature)((PropertyCallExp)ast).getReferredProperty();
            }
        }
        return null;
    }
}

