/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.AcceleoOutlinePage;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoPartitionScanner;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class AcceleoDocumentProvider
extends FileDocumentProvider {
    private AcceleoEditor editor;
    private IPositionUpdater positionUpdater;

    public AcceleoDocumentProvider(AcceleoEditor editor) {
        this.editor = editor;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new AcceleoPartitionScanner(), AcceleoPartitionScanner.LEGAL_CONTENT_TYPES);
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            if (this.positionUpdater == null) {
                this.positionUpdater = new IPositionUpdater(){

                    public void update(DocumentEvent event) {
                        AcceleoDocumentProvider.this.handlePositionUpdate(event.getOffset(), event.getOffset() + event.getLength(), event.getText());
                    }
                };
                document.addPositionUpdater(this.positionUpdater);
            }
        }
        return document;
    }

    private void handlePositionUpdate(int posBegin, int posEnd, String newText) {
        AcceleoOutlinePage outline;
        CSTNode cstNode;
        if (this.editor.getContent() != null && (cstNode = this.editor.getContent().updateCST(posBegin, posEnd, newText)) != null && (outline = this.editor.getContentOutlinePage()).getControl() != null && !outline.getControl().isDisposed()) {
            outline.refresh(cstNode);
        }
    }

    protected void disconnected() {
        IDocument document;
        super.disconnected();
        if (this.positionUpdater != null && this.editor.getEditorInput() != null && (document = this.getDocument(this.editor.getEditorInput())) != null) {
            document.removePositionUpdater(this.positionUpdater);
        }
    }
}

