/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.io.IOException;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class AcceleoCompletionImportProposal
implements ICompletionProposal {
    private String dynamicReplacementString;
    private URI emtlURI;
    private String displayString;
    private int replacementOffset;
    private int replacementLength;
    private Image image;

    public AcceleoCompletionImportProposal(URI emtlURI, int replacementOffset, int replacementLength, Image image, String displayString) {
        this.dynamicReplacementString = new Path(emtlURI.lastSegment()).removeFileExtension().lastSegment();
        this.emtlURI = emtlURI;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.image = image;
        this.displayString = displayString;
    }

    public void apply(IDocument document) {
        try {
            EObject eObject;
            try {
                eObject = ModelUtils.load((URI)this.emtlURI, (ResourceSet)new ResourceSetImpl());
            }
            catch (IOException e) {
                eObject = null;
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
            if (eObject instanceof Module && ((Module)eObject).getNsURI() != null && ((Module)eObject).getNsURI().length() > 0) {
                this.dynamicReplacementString = ((Module)eObject).getNsURI();
            }
            document.replace(this.replacementOffset, this.replacementLength, this.dynamicReplacementString);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.dynamicReplacementString.length(), 0);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public String getAdditionalProposalInfo() {
        return "Project Name :\n " + this.getModuleProjectName() + "\n\nPath :\n " + this.getModulePackage();
    }

    private String getModuleProjectName() {
        String prefix;
        String path = this.emtlURI.toString();
        if (path.startsWith(prefix = "platform:/resource/")) {
            path = path.substring(prefix.length());
        } else {
            prefix = "platform:/plugin/";
            if (path.startsWith(prefix)) {
                path = path.substring(prefix.length());
            }
        }
        Path relativePath = new Path(path);
        String result = relativePath.segmentCount() > 1 ? (this.emtlURI.isPlatformPlugin() ? String.valueOf(relativePath.segment(0)) + " [plugin]" : relativePath.segment(0)) : "[others]";
        return result;
    }

    private String getModulePackage() {
        String prefix;
        String path = this.emtlURI.toString();
        if (path.startsWith(prefix = "platform:/resource/")) {
            path = path.substring(prefix.length());
        } else {
            prefix = "platform:/plugin/";
            if (path.startsWith(prefix)) {
                path = path.substring(prefix.length());
            }
        }
        Path relativePath = new Path(path);
        String result = relativePath.segmentCount() > 2 ? relativePath.removeFirstSegments(1).removeLastSegments(1).toString() : "";
        return result;
    }
}

