/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor;

import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AbstractRefactoringWithVariableContextAction;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class CreateProtectedAreaAction
extends AbstractRefactoringWithVariableContextAction {
    public static final String ACTION_ID = "org.eclipse.acceleo.ide.ui.editors.template.actions.refactor.createProtectedArea";
    public static final String COMMAND_ID = "org.eclipse.acceleo.ide.ui.createProtectedArea";

    protected int modify(IDocument document, AcceleoSourceContent content, int offset, int length) throws BadLocationException {
        int b = offset;
        int e = offset + length;
        CSTNode currentNode = content.getCSTNode(b, e);
        String paramName = this.getCurrentVariableName(currentNode, "e");
        try {
            String commentEndLine;
            String commentBeginLine;
            String indent = this.getIndent(content, offset);
            String text = content.getText();
            if (text.contains(".java")) {
                commentBeginLine = "// ";
                commentEndLine = "";
            } else if (text.contains(".xml")) {
                commentBeginLine = "<!-- ";
                commentEndLine = " -->";
            } else {
                commentBeginLine = "";
                commentEndLine = "";
            }
            String prefix = String.valueOf(commentBeginLine) + "[protected (" + paramName + ".name)]" + commentEndLine + '\n' + indent;
            String suffix = "\n" + indent + commentBeginLine + "[/protected]" + commentEndLine + '\n';
            document.replace(e, 0, suffix);
            document.replace(b, 0, prefix);
            return b + prefix.length();
        }
        catch (BadLocationException ex) {
            return offset;
        }
    }

    private String getIndent(AcceleoSourceContent content, int offset) {
        String text = content.getText();
        StringBuffer tabBuffer = new StringBuffer();
        int i = offset;
        while (i > 0 && Character.isWhitespace(text.charAt(i - 1)) && text.charAt(i - 1) != '\n') {
            tabBuffer.insert(0, text.charAt(i - 1));
            --i;
        }
        return tabBuffer.toString();
    }
}

