/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameModuleUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameVariableDescriptor;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoRenameModuleRefactoring
extends Refactoring {
    private static final String MODULE = "module";
    private static final String NEWNAME = "newName";
    private String fNewModuleName;
    private Map<IFile, TextFileChange> fChanges;
    private Refactoring javaCompUnitRenameRefactoring;
    private RefactoringContribution javaCompUnitRefactoringContribution;
    private RenameJavaElementDescriptor javaCompUnitRefactoringDescriptor;
    private Module fModule;
    private IProject fProject;
    private IFile file;
    private final String title = AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.RenameModuleTitle");
    private final boolean renameModule;
    private boolean renameJavaFile = true;

    public AcceleoRenameModuleRefactoring() {
        this.renameModule = true;
    }

    public AcceleoRenameModuleRefactoring(boolean renameModuleFile) {
        this.renameModule = renameModuleFile;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CheckingPreconditions"), 1);
            this.fChanges = new LinkedHashMap<IFile, TextFileChange>();
            this.putChangesFromWorkspace(monitor);
            if (this.renameJavaFile) {
                this.javaCompUnitRefactoringDescriptor.setNewName(String.valueOf(this.fNewModuleName.substring(0, 1).toUpperCase()) + this.fNewModuleName.substring(1));
                this.javaCompUnitRenameRefactoring = this.javaCompUnitRefactoringDescriptor.createRefactoring(status);
                status.merge(this.javaCompUnitRenameRefactoring.checkInitialConditions(monitor));
                status.merge(this.javaCompUnitRenameRefactoring.checkFinalConditions(monitor));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void putChangesFromWorkspace(IProgressMonitor monitor) {
        AcceleoProject acceleoProject = new AcceleoProject(this.fProject);
        List<Sequence> sequencesToFind = AcceleoBuilderUtils.getImportSequencesToSearch(acceleoProject, this.file);
        for (IFile mtlFile : this.getMTLFilesFromWorkspace()) {
            this.createChangesForFileWithDependencies(mtlFile, sequencesToFind);
        }
        StringBuffer fileModuleContent = FileContent.getFileContent((File)this.file.getLocation().toFile());
        this.createChangesForModuleDefinition(fileModuleContent);
    }

    private List<IFile> getMTLFilesFromWorkspace() {
        IProject[] projects;
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                try {
                    AcceleoBuilderUtils.members(fileList, (IContainer)project, "mtl", AcceleoRenameModuleUtils.getOutputFolder(project));
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return fileList;
    }

    private void createChangesForFileWithDependencies(IFile mtlFile, List<Sequence> sequencesToFind) {
        File ioFile = mtlFile.getLocation().toFile();
        StringBuffer mtlContent = FileContent.getFileContent((File)ioFile);
        for (Sequence sequence : sequencesToFind) {
            Region region = sequence.search(mtlContent);
            if (region.b() <= -1) continue;
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(mtlFile) && this.fChanges.get(mtlFile).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(mtlFile);
                edit = (MultiTextEdit)this.fChanges.get(mtlFile).getEdit();
            } else {
                tfc = new TextFileChange(this.title, mtlFile);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            int offset = region.e() - this.fModule.getName().length();
            edit.addChild((TextEdit)new ReplaceEdit(offset, this.fModule.getName().length(), this.fNewModuleName));
            this.fChanges.put(mtlFile, tfc);
        }
    }

    private void createChangesForModuleDefinition(StringBuffer fileModuleContent) {
        Sequence sequence;
        Region region;
        if (this.fModule != null && (region = (sequence = new Sequence("[", MODULE, this.fModule.getName())).search(fileModuleContent)).b() > -1) {
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(this.file) && this.fChanges.get(this.file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(this.file);
                edit = (MultiTextEdit)this.fChanges.get(this.file).getEdit();
            } else {
                tfc = new TextFileChange(this.title, this.file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            int offset = region.e() - this.fModule.getName().length();
            edit.addChild((TextEdit)new ReplaceEdit(offset, this.fModule.getName().length(), this.fNewModuleName));
            this.fChanges.put(this.file, tfc);
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        ICompilationUnit element = AcceleoRenameModuleUtils.getJavaCompilationUnitFromModuleFile(this.fProject, this.file);
        if (element == null || !element.exists()) {
            this.renameJavaFile = false;
        }
        if (this.fModule == null) {
            status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.NoModuleSpecified")));
        } else if (this.renameJavaFile) {
            this.javaCompUnitRefactoringContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.jdt.ui.rename.type");
            RefactoringDescriptor descriptor = this.javaCompUnitRefactoringContribution.createDescriptor();
            if (descriptor instanceof RenameJavaElementDescriptor) {
                this.javaCompUnitRefactoringDescriptor = (RenameJavaElementDescriptor)descriptor;
                this.javaCompUnitRefactoringDescriptor.setDescription(AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.JavaRenameDescription"));
                this.javaCompUnitRefactoringDescriptor.setJavaElement((IJavaElement)element.getType(String.valueOf(this.fModule.getName().substring(0, 1).toUpperCase()) + this.fModule.getName().substring(1)));
                this.javaCompUnitRefactoringDescriptor.setUpdateReferences(true);
            }
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CreatingChanges"), 1);
            Collection<TextFileChange> changes = this.fChanges.values();
            CompositeChange change = new CompositeChange(this.getName()){

                public ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String project = AcceleoRenameModuleRefactoring.this.fProject.getName();
                    String description = String.valueOf(AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.RenamingModule")) + " " + AcceleoRenameModuleRefactoring.this.fModule.getName();
                    String comment = AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.RenamingModuleWithNewName", AcceleoRenameModuleRefactoring.this.fModule.getName(), AcceleoRenameModuleRefactoring.this.fNewModuleName);
                    arguments.put(AcceleoRenameModuleRefactoring.MODULE, AcceleoRenameModuleRefactoring.this.fModule.getName());
                    arguments.put(AcceleoRenameModuleRefactoring.NEWNAME, AcceleoRenameModuleRefactoring.this.fNewModuleName);
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)new AcceleoRenameVariableDescriptor(project, description, comment, arguments));
                }
            };
            if (this.renameJavaFile) {
                change.add(this.javaCompUnitRenameRefactoring.createChange(monitor));
            }
            if (this.renameModule) {
                CompositeChange moduleFileChange = new CompositeChange(this.getName());
                for (TextFileChange textFileChange : changes) {
                    if (textFileChange.getFile().equals((Object)this.file)) {
                        moduleFileChange.add((Change)textFileChange);
                        continue;
                    }
                    change.add((Change)textFileChange);
                }
                RenameResourceChange changeRenameModule = new RenameResourceChange(this.file.getFullPath(), String.valueOf(this.fNewModuleName) + "." + "mtl");
                moduleFileChange.add((Change)changeRenameModule);
                change.add((Change)moduleFileChange);
            } else {
                for (TextFileChange textFileChange : changes) {
                    change.add((Change)textFileChange);
                }
            }
            CompositeChange compositeChange = change;
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public void setFile(IFile f) {
        this.file = f;
    }

    public String getName() {
        return this.title;
    }

    public void setModule(Module currentModule) {
        this.fModule = currentModule;
    }

    public Module getModule() {
        return this.fModule;
    }

    public RefactoringStatus setNewModuleName(String text) {
        this.fNewModuleName = text;
        RefactoringStatus status = this.checkModuleName(this.fNewModuleName);
        status.merge(this.checkOverLoading());
        return status;
    }

    private RefactoringStatus checkOverLoading() {
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        try {
            AcceleoBuilderUtils.members(fileList, (IContainer)this.fProject, "mtl", AcceleoRenameModuleUtils.getOutputFolder(this.fProject));
            for (IFile iFile : fileList) {
                if (iFile.getParent() == null || !iFile.getParent().equals((Object)this.file.getParent()) || !iFile.getName().equals(String.valueOf(this.fNewModuleName) + "." + "mtl")) continue;
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.ModuleOverloadingError")));
                break;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return status;
    }

    private RefactoringStatus checkModuleName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameModuleRefactoring.InvalidModuleName")));
                break;
            }
            ++i;
        }
        return status;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(MODULE);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewModuleName(value);
        }
        return status;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

