/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.io.IOException;
import java.util.List;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class AcceleoRenameModuleUtils {
    private static final String SLASH = "/";

    private AcceleoRenameModuleUtils() {
    }

    public static IPath getOutputFolder(IProject aProject) {
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            IFolder folder;
            IPath output = javaProject.getOutputLocation();
            if (output != null && output.segmentCount() > 1 && (folder = aProject.getWorkspace().getRoot().getFolder(output)).isAccessible()) {
                return folder.getFullPath();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public static IFile getFileFromModule(IProject project, Module module) {
        String uri = module.getNsURI();
        AcceleoProject acceleoProject = new AcceleoProject(project);
        IFile result = null;
        String pathStr = uri.replaceAll("::", SLASH);
        Path path = new Path(pathStr);
        try {
            for (IFile file : acceleoProject.getInputFiles()) {
                IPath p = file.getProjectRelativePath().removeFileExtension();
                if (!p.removeFirstSegments(1).equals((Object)path)) continue;
                result = file;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    public static ICompilationUnit getJavaCompilationUnitFromModuleFile(IProject project, IFile moduleFile) {
        ICompilationUnit compilationUnit = null;
        IPath path = moduleFile.getProjectRelativePath().removeLastSegments(1);
        String str = path.toString();
        String moduleName = moduleFile.getName().substring(0, moduleFile.getName().length() - (moduleFile.getFileExtension().length() + 1));
        path = new Path(str = String.valueOf(str) + SLASH + moduleName.substring(0, 1).toUpperCase() + moduleName.substring(1));
        IFile file = project.getFile(path.addFileExtension("java"));
        if (file.exists()) {
            compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        }
        return compilationUnit;
    }

    public static IFile getJavaFileFromModuleFile(IProject project, IFile moduleFile) {
        IFile file = null;
        IPath path = moduleFile.getProjectRelativePath().removeFileExtension();
        path = path.addFileExtension("java");
        file = project.getFile(path);
        return file;
    }

    public static Module getModuleFromFile(IFile moduleFile) {
        Module mod = null;
        AcceleoProject acceleoProject = new AcceleoProject(moduleFile.getProject());
        List<URI> uriList = acceleoProject.getOutputFiles();
        ResourceSetImpl newResourceSet = new ResourceSetImpl();
        block2: for (URI uri : uriList) {
            IPath path = acceleoProject.getOutputFilePath(moduleFile);
            URI moduleFileURI = null;
            if (path != null) {
                moduleFileURI = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
            }
            if (!uri.equals(moduleFileURI)) continue;
            try {
                ModelUtils.load((URI)uri, (ResourceSet)newResourceSet);
                EcoreUtil.resolveAll((ResourceSet)newResourceSet);
                for (Resource resource : newResourceSet.getResources()) {
                    if (resource.getContents().size() <= 0 || !(resource.getContents().get(0) instanceof Module)) continue;
                    mod = (Module)resource.getContents().get(0);
                    continue block2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return mod;
    }
}

