/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.module;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.wizards.module.example.IAcceleoInitializationStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.ModuleElementKind;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.AcceleoModuleWizardPage;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.example.AcceleoInitializationStrategyUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AcceleoModuleWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    protected IConfigurationElement configurationElement;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    private AcceleoModuleWizardPage acceleoModuleWizardPage;

    public AcceleoModuleWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewTemplatesWizard.Title"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iSelection) {
        this.workbench = iWorkbench;
        this.selection = iSelection;
    }

    public void addPages() {
        IStructuredSelection aSelection;
        IContainer firstContainer = null;
        if (this.selection != null && !this.selection.isEmpty() && (aSelection = this.selection).size() > 0) {
            Object element = aSelection.getFirstElement();
            if (element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
            }
            if (element instanceof IContainer) {
                firstContainer = (IContainer)element;
            } else if (element instanceof IResource) {
                firstContainer = ((IResource)element).getParent();
            }
        }
        if (firstContainer != null) {
            String container = firstContainer.getFullPath().toString();
            this.acceleoModuleWizardPage = new AcceleoModuleWizardPage(container);
        } else {
            this.acceleoModuleWizardPage = new AcceleoModuleWizardPage();
        }
        this.addPage((IWizardPage)this.acceleoModuleWizardPage);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public boolean performFinish() {
        AcceleoModule acceleoModule = this.acceleoModuleWizardPage.getAcceleoModule();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(acceleoModule.getProjectName());
        if (project.exists() && project.isAccessible()) {
            Path path = new Path(acceleoModule.getParentFolder());
            IFolder folder = project.getFolder(path.removeFirstSegments(1));
            AcceleoUIGenerator.getDefault().generateAcceleoModule(acceleoModule, (IContainer)folder);
            if (acceleoModule.isIsInitialized()) {
                String initializationKind = acceleoModule.getInitializationKind();
                IAcceleoInitializationStrategy strategy = null;
                List<IAcceleoInitializationStrategy> initializationStrategy = AcceleoInitializationStrategyUtils.getInitializationStrategy();
                for (IAcceleoInitializationStrategy iAcceleoInitializationStrategy : initializationStrategy) {
                    if (iAcceleoInitializationStrategy.getDescription() == null || !iAcceleoInitializationStrategy.getDescription().equals(initializationKind)) continue;
                    strategy = iAcceleoInitializationStrategy;
                    break;
                }
                IFile file = folder.getFile(String.valueOf(acceleoModule.getName()) + "." + "mtl");
                IFile exampleFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(acceleoModule.getInitializationPath()));
                String moduleElementKind = "template";
                if (acceleoModule.getModuleElement().getKind().equals((Object)ModuleElementKind.QUERY)) {
                    moduleElementKind = "query";
                }
                if (strategy != null && file.exists()) {
                    try {
                        strategy.configure(moduleElementKind, acceleoModule.getModuleElement().isGenerateFile(), acceleoModule.getModuleElement().isIsMain(), acceleoModule.isGenerateDocumentation());
                        String content = strategy.getContent(exampleFile, acceleoModule.getName(), (List<String>)acceleoModule.getMetamodelURIs(), acceleoModule.getModuleElement().getParameterType());
                        ByteArrayInputStream javaStream = new ByteArrayInputStream(content.getBytes("UTF8"));
                        file.setContents((InputStream)javaStream, true, false, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                    catch (UnsupportedEncodingException e) {
                        AcceleoUIActivator.log(e, true);
                    }
                }
            }
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        return true;
    }
}

