/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui.resources;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoProject {
    private static Map<String, List<URI>> bundle2outputFiles = new HashMap<String, List<URI>>();
    private static boolean allBundlesOutputFilesFound;
    private static boolean registryInitialized;
    private IProject project;
    private List<IPath> sourceFolders;
    private List<URI> outputFilesWithManifest;
    private long manifestModificationStamp = -1L;

    public AcceleoProject(IProject project) {
        IClasspathEntry[] entries;
        if (!registryInitialized) {
            registryInitialized = true;
            AcceleoProject.registerPackages();
        }
        this.project = project;
        this.sourceFolders = new ArrayList<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e1) {
            entries = new IClasspathEntry[]{};
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                this.sourceFolders.add(entry.getPath());
            }
            ++i;
        }
    }

    private static void registerPackages() {
        if (!EPackage.Registry.INSTANCE.containsKey((Object)MtlPackage.eINSTANCE.getNsURI())) {
            EPackage.Registry.INSTANCE.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)AcceleoProject.getOCLStdLibPackage());
            EPackage.Registry.INSTANCE.put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        }
    }

    private static EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        return (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AcceleoProject) {
            return ((AcceleoProject)obj).project.equals((Object)this.project);
        }
        return false;
    }

    public int hashCode() {
        return this.project.getName().hashCode();
    }

    public List<IFile> getInputFiles() throws CoreException {
        ArrayList<IFile> filesInput = new ArrayList<IFile>();
        for (IPath sourceFolderPath : this.sourceFolders) {
            IFolder sourceFolder;
            if (sourceFolderPath.segmentCount() <= 1 || (sourceFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(sourceFolderPath)) == null || !sourceFolder.isAccessible()) continue;
            this.computeInputFiles(filesInput, (IContainer)sourceFolder);
        }
        return filesInput;
    }

    private void computeInputFiles(List<IFile> filesInput, IContainer container) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension())) {
                    filesInput.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.computeInputFiles(filesInput, (IContainer)resource);
                }
                ++i;
            }
        }
    }

    public IPath getOutputFilePath(IFile fileAcceleo) {
        IPath acceleoFilePath;
        IPath projectPath = this.project.getRawLocation();
        if (projectPath == null) {
            projectPath = this.project.getLocation();
        }
        if ((acceleoFilePath = fileAcceleo.getRawLocation()) == null) {
            acceleoFilePath = fileAcceleo.getLocation();
        }
        IPath filePath = AcceleoProject.makeRelativeTo(acceleoFilePath, projectPath);
        IFolder folder = AcceleoProject.getOutputFolder(this.project);
        if (folder != null) {
            Iterator<IPath> itSourceFolders = this.sourceFolders.iterator();
            while (itSourceFolders.hasNext()) {
                IPath sourcePath = AcceleoProject.makeRelativeTo(itSourceFolders.next(), this.project.getFullPath());
                if (!sourcePath.isPrefixOf(filePath)) continue;
                IPath relativePath = filePath.removeFirstSegments(sourcePath.segmentCount());
                return folder.getFullPath().append(relativePath.removeFileExtension().addFileExtension("emtl"));
            }
        }
        return null;
    }

    public IPath getInputFilePath(IPath fileEMTL) {
        IFolder folder = AcceleoProject.getOutputFolder(this.project);
        if (folder != null && folder.getFullPath().isPrefixOf(fileEMTL)) {
            IPath relativePath = fileEMTL.removeFileExtension().addFileExtension("mtl").removeFirstSegments(folder.getFullPath().segmentCount());
            Iterator<IPath> itSourceFolders = this.sourceFolders.iterator();
            while (itSourceFolders.hasNext()) {
                IPath sourcePath = itSourceFolders.next().append(relativePath);
                if (!ResourcesPlugin.getWorkspace().getRoot().exists(sourcePath)) continue;
                return sourcePath;
            }
        }
        return null;
    }

    public List<IPath> getResolvedClasspath() {
        IClasspathEntry[] entries;
        ArrayList<IPath> result = new ArrayList<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e1) {
            AcceleoUIActivator.getDefault().getLog().log(e1.getStatus());
            entries = new IClasspathEntry[]{};
        }
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            result.add(entry.getPath());
            ++i;
        }
        return result;
    }

    public String getPackageName(IFile fileAcceleo) {
        IPath acceleoFilePath;
        IPath projectPath = this.project.getRawLocation();
        if (projectPath == null) {
            projectPath = this.project.getLocation();
        }
        if ((acceleoFilePath = fileAcceleo.getRawLocation()) == null) {
            acceleoFilePath = fileAcceleo.getLocation();
        }
        IPath filePath = AcceleoProject.makeRelativeTo(acceleoFilePath, projectPath);
        Iterator<IPath> itSourceFolders = this.sourceFolders.iterator();
        while (itSourceFolders.hasNext()) {
            IPath sourcePath = AcceleoProject.makeRelativeTo(itSourceFolders.next(), this.project.getFullPath());
            if (!sourcePath.isPrefixOf(filePath)) continue;
            StringBuffer name = new StringBuffer();
            String[] segments = filePath.removeFirstSegments(sourcePath.segmentCount()).removeLastSegments(1).segments();
            int i = 0;
            while (i < segments.length) {
                if (i > 0) {
                    name.append(".");
                }
                name.append(segments[i]);
                ++i;
            }
            return name.toString();
        }
        return "";
    }

    private static IFolder getOutputFolder(IProject aProject) {
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            IFolder folder;
            IPath output = javaProject.getOutputLocation();
            if (output != null && output.segmentCount() > 1 && (folder = aProject.getWorkspace().getRoot().getFolder(output)).isAccessible()) {
                return folder;
            }
        }
        catch (JavaModelException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    public List<URI> getOutputFiles() {
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        AcceleoProject.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)AcceleoProject.getOutputFolder(this.project));
        return outputURIs;
    }

    public List<URI> getAccessibleOutputFiles() {
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        AcceleoProject.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)AcceleoProject.getOutputFolder(this.project));
        this.computeAccessibleOutputFilesWithPluginXML(outputURIs, this.project);
        this.computeAccessibleOutputFilesWithProjectDependencies(outputURIs, this.project);
        return outputURIs;
    }

    private static void computeAccessibleOutputFilesInFolder(List<URI> outputURIs, IContainer folder) {
        if (folder == null) {
            return;
        }
        try {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member instanceof IFile) {
                    URI uri;
                    if ("emtl".equals(((IFile)member).getFileExtension()) && !outputURIs.contains(uri = URI.createPlatformResourceURI((String)((IFile)member).getFullPath().toString(), (boolean)false))) {
                        outputURIs.add(uri);
                    }
                } else if (member instanceof IContainer) {
                    AcceleoProject.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)member);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }

    public static List<URI> computeAcceleoModuleInRequiredPlugins(IProject project) {
        ArrayList<URI> uris = new ArrayList<URI>();
        AcceleoProject acceleoProject = new AcceleoProject(project);
        acceleoProject.computeAccessibleOutputFilesWithPluginXML(uris, project);
        return uris;
    }

    private void computeAccessibleOutputFilesWithPluginXML(List<URI> outputURIs, IProject aProject) {
        IFile manifest = aProject.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (this.outputFilesWithManifest == null || manifest.isAccessible() && manifest.getModificationStamp() != this.manifestModificationStamp) {
            this.outputFilesWithManifest = new ArrayList<URI>();
            this.manifestModificationStamp = manifest.getModificationStamp();
            IPluginModelBase plugin = PluginRegistry.findModel((IProject)aProject);
            if (plugin != null && plugin.getBundleDescription() != null) {
                BundleDescription[] requiredPlugins = plugin.getBundleDescription().getResolvedRequires();
                int i = 0;
                while (i < requiredPlugins.length) {
                    String requiredSymbolicName = requiredPlugins[i].getSymbolicName();
                    IProject requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredSymbolicName);
                    if (requiredProject != null && requiredProject.isAccessible()) {
                        AcceleoProject.computeAccessibleOutputFilesInFolder(this.outputFilesWithManifest, (IContainer)AcceleoProject.getOutputFolder(requiredProject));
                    } else {
                        AcceleoProject.computeAccessibleOutputFilesWithBundle(this.outputFilesWithManifest, Platform.getBundle((String)requiredSymbolicName));
                    }
                    ++i;
                }
            }
        }
        for (URI uri : this.outputFilesWithManifest) {
            if (outputURIs.contains(uri)) continue;
            outputURIs.add(uri);
        }
    }

    private static void computeAccessibleOutputFilesWithBundle(List<URI> outputURIs, Bundle bundle) {
        if (bundle != null && (bundle.getState() == 4 || bundle.getState() == 32 || bundle.getState() == 2 || bundle.getState() == 8)) {
            outputURIs.addAll(AcceleoProject.getOrCreatePlatformPluginSavedURIs(bundle));
        }
    }

    private void computeAccessibleOutputFilesWithProjectDependencies(List<URI> outputURIs, IProject aProject) {
        IClasspathEntry[] entries;
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException e1) {
            AcceleoUIActivator.getDefault().getLog().log(e1.getStatus());
            entries = new IClasspathEntry[]{};
        }
        int i = 0;
        while (i < entries.length) {
            IProject requiredProject;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 2 && (requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString())) != null && requiredProject.exists()) {
                AcceleoProject.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)AcceleoProject.getOutputFolder(requiredProject));
            }
            ++i;
        }
    }

    public List<AcceleoProject> getRecursivelyAccessibleAcceleoProjects() {
        ArrayList<AcceleoProject> result = new ArrayList<AcceleoProject>();
        for (IProject aProject : this.getRecursivelyAccessibleProjects()) {
            try {
                if (!aProject.isAccessible() || !aProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) continue;
                result.add(new AcceleoProject(aProject));
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return result;
    }

    public List<IProject> getRecursivelyAccessibleProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        this.computeAccessibleProjects(result, this.project);
        return result;
    }

    private void computeAccessibleProjects(List<IProject> accessibleProjects, IProject current) {
        if (!accessibleProjects.contains(current)) {
            IClasspathEntry[] entries;
            accessibleProjects.add(current);
            IPluginModelBase plugin = PluginRegistry.findModel((IProject)current);
            if (plugin != null && plugin.getBundleDescription() != null) {
                BundleDescription[] requiredPlugins = plugin.getBundleDescription().getResolvedRequires();
                int i = 0;
                while (i < requiredPlugins.length) {
                    String requiredSymbolicName = requiredPlugins[i].getSymbolicName();
                    IProject requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredSymbolicName);
                    if (requiredProject != null && requiredProject.isAccessible()) {
                        this.computeAccessibleProjects(accessibleProjects, requiredProject);
                    }
                    ++i;
                }
            }
            IJavaProject javaProject = JavaCore.create((IProject)current);
            try {
                entries = javaProject.getResolvedClasspath(true);
            }
            catch (JavaModelException e1) {
                AcceleoUIActivator.getDefault().getLog().log(e1.getStatus());
                entries = new IClasspathEntry[]{};
            }
            int i = 0;
            while (i < entries.length) {
                IProject requiredProject;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && (requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString())) != null && requiredProject.exists()) {
                    this.computeAccessibleProjects(accessibleProjects, requiredProject);
                }
                ++i;
            }
        }
    }

    @Deprecated
    public ResourceSet loadAccessibleOutputFiles() {
        return this.loadAccessibleOutputFiles((IProgressMonitor)new NullProgressMonitor());
    }

    public ResourceSet loadAccessibleOutputFiles(IProgressMonitor monitor) {
        ResourceSetImpl oResourceSet = new ResourceSetImpl();
        List<URI> outputURIs = this.getAccessibleOutputFiles();
        Iterator<URI> itOutputURIs = outputURIs.iterator();
        while (itOutputURIs.hasNext() && !monitor.isCanceled()) {
            URI oURI = itOutputURIs.next();
            try {
                ModelUtils.load((URI)oURI, (ResourceSet)oResourceSet);
            }
            catch (WrappedException wrappedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return oResourceSet;
    }

    public ResourceSet loadNotAccessibleOutputFiles(IProgressMonitor monitor) {
        return AcceleoProject.loadAllPlatformOutputFiles(this, monitor);
    }

    public static ResourceSet loadAllPlatformOutputFiles(IProgressMonitor monitor) {
        if (!registryInitialized) {
            registryInitialized = true;
            AcceleoProject.registerPackages();
        }
        return AcceleoProject.loadAllPlatformOutputFiles(null, monitor);
    }

    private static ResourceSet loadAllPlatformOutputFiles(AcceleoProject excludeAccessible, IProgressMonitor monitor) {
        ResourceSetImpl oResourceSet = new ResourceSetImpl();
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            try {
                if (aProject.isAccessible() && aProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                    AcceleoProject.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)AcceleoProject.getOutputFolder(aProject));
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
        outputURIs.addAll(AcceleoProject.getAllPlatformPluginOutputFiles());
        List<URI> excludeURIs = excludeAccessible != null ? excludeAccessible.getAccessibleOutputFiles() : null;
        Iterator itOutputURIs = outputURIs.iterator();
        while (itOutputURIs.hasNext() && !monitor.isCanceled()) {
            URI oURI = (URI)itOutputURIs.next();
            if (excludeURIs != null && excludeURIs.contains(oURI)) continue;
            try {
                ModelUtils.load((URI)oURI, (ResourceSet)oResourceSet);
            }
            catch (WrappedException wrappedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return oResourceSet;
    }

    public static List<URI> getAllPlatformResourceOutputFiles() {
        IProject[] projects;
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            try {
                if (aProject.isAccessible() && aProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                    AcceleoProject.computeAccessibleOutputFilesInFolder(outputURIs, (IContainer)AcceleoProject.getOutputFolder(aProject));
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
        return outputURIs;
    }

    public static List<URI> getAccessiblePluginModules(IProject project) {
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        ArrayList<String> bundles = new ArrayList<String>();
        IPluginModelBase plugin = PluginRegistry.findModel((IProject)project);
        if (plugin != null && plugin.getBundleDescription() != null) {
            BundleDescription[] requiredPlugins = plugin.getBundleDescription().getResolvedRequires();
            int i = 0;
            while (i < requiredPlugins.length) {
                String requiredSymbolicName = requiredPlugins[i].getSymbolicName();
                bundles.add(requiredSymbolicName);
                ++i;
            }
        }
        for (String bundle : bundles) {
            outputURIs.addAll((Collection<URI>)bundle2outputFiles.get(bundle));
        }
        return outputURIs;
    }

    public static List<URI> getAllPlatformPluginOutputFiles() {
        ArrayList<URI> outputURIs = new ArrayList<URI>();
        if (!allBundlesOutputFilesFound) {
            IBundleGroupProvider[] providers;
            IProject[] projects;
            CompactHashSet done = new CompactHashSet();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject aProject = iProjectArray[n2];
                try {
                    if (aProject.isAccessible() && aProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                        done.add(aProject.getName());
                    }
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
                ++n2;
            }
            IBundleGroupProvider[] iBundleGroupProviderArray = providers = Platform.getBundleGroupProviders();
            int n3 = providers.length;
            n = 0;
            while (n < n3) {
                IBundleGroupProvider provider = iBundleGroupProviderArray[n];
                IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
                int n4 = iBundleGroupArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IBundleGroup group = iBundleGroupArray[n5];
                    Bundle[] bundleArray = group.getBundles();
                    int n6 = bundleArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Bundle bundle = bundleArray[n7];
                        String name = bundle.getSymbolicName();
                        if (!(done.contains(name) || bundle.getState() != 4 && bundle.getState() != 32 && bundle.getState() != 2 && bundle.getState() != 8)) {
                            done.add(name);
                            outputURIs.addAll(AcceleoProject.getOrCreatePlatformPluginSavedURIs(bundle));
                        }
                        ++n7;
                    }
                    ++n5;
                }
                ++n;
            }
            iBundleGroupProviderArray = Platform.getPluginRegistry().getPluginDescriptors();
            n3 = iBundleGroupProviderArray.length;
            n = 0;
            while (n < n3) {
                IBundleGroupProvider descriptor = iBundleGroupProviderArray[n];
                String name = descriptor.getUniqueIdentifier();
                if (!done.contains(name)) {
                    done.add(name);
                    Bundle bundle = Platform.getBundle((String)name);
                    if (bundle != null) {
                        outputURIs.addAll(AcceleoProject.getOrCreatePlatformPluginSavedURIs(bundle));
                    }
                }
                ++n;
            }
            allBundlesOutputFilesFound = true;
        } else {
            for (List<URI> values : bundle2outputFiles.values()) {
                outputURIs.addAll(values);
            }
        }
        return outputURIs;
    }

    private static List<URI> getOrCreatePlatformPluginSavedURIs(Bundle bundle) {
        String name = bundle.getSymbolicName();
        List<URI> savedURIs = bundle2outputFiles.get(name);
        if (savedURIs == null) {
            savedURIs = new ArrayList<URI>();
            bundle2outputFiles.put(name, savedURIs);
            String required = (String)bundle.getHeaders().get("Require-Bundle");
            if (required != null && required.indexOf("org.eclipse.acceleo.engine") != -1) {
                AcceleoProject.computeSaveURIs(bundle, savedURIs);
            }
        }
        return savedURIs;
    }

    private static void computeSaveURIs(Bundle bundle, List<URI> savedURIs) {
        Enumeration entriesMTL = bundle.findEntries("/", "*.mtl", true);
        Enumeration entriesEMTL = bundle.findEntries("/", "*.emtl", true);
        if (entriesEMTL != null && entriesEMTL.hasMoreElements()) {
            while (entriesEMTL.hasMoreElements()) {
                Path path;
                URL entry = (URL)entriesEMTL.nextElement();
                if (entry == null || (path = new Path(entry.getPath())).segmentCount() <= 0) continue;
                savedURIs.add(URI.createPlatformPluginURI((String)new Path(bundle.getSymbolicName()).append((IPath)path).toString(), (boolean)false));
            }
        }
    }

    public List<IPath> getSourceFolders() {
        return new ArrayList<IPath>(this.sourceFolders);
    }

    public static IPath makeRelativeTo(IPath path1, IPath path2) {
        IPath path = path1;
        if (path1.getDevice() == path2.getDevice() || path1.getDevice() != null && path1.getDevice().equalsIgnoreCase(path2.getDevice())) {
            int commonLength = path1.matchingFirstSegments(path2);
            int differenceLength = path2.segmentCount() - commonLength;
            int newSegmentLength = differenceLength + path1.segmentCount() - commonLength;
            if (newSegmentLength == 0) {
                return Path.EMPTY;
            }
            path = new Path("");
            Object[] newSegments = new String[newSegmentLength];
            Arrays.fill(newSegments, 0, differenceLength, "..");
            System.arraycopy(path1.segments(), commonLength, newSegments, differenceLength, newSegmentLength - differenceLength);
            Object[] objectArray = newSegments;
            int n = newSegments.length;
            int n2 = 0;
            while (n2 < n) {
                Object segment = objectArray[n2];
                path = path.append((IPath)new Path((String)segment));
                ++n2;
            }
        }
        return path;
    }
}

