/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoModelManager;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoProjectState;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderSettings;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoBuilderUtils;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoCompileOperation;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoMarkerUtils;
import org.eclipse.acceleo.internal.ide.ui.builders.runner.CreateRunnableAcceleoOperation;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoParser;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoProjectClasspathEntry;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.parser.AcceleoParserInfo;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserWarning;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.acceleo.ide.ui.acceleoBuilder";
    private Set<File> outputFolders = new LinkedHashSet<File>();
    private Map<IJavaProject, org.eclipse.acceleo.internal.parser.compiler.AcceleoProject> mappedProjects = new HashMap<IJavaProject, org.eclipse.acceleo.internal.parser.compiler.AcceleoProject>();
    private AcceleoProjectState lastState;

    protected IProject[] build(int kind, Map arguments, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return new IProject[0];
        }
        this.mappedProjects.clear();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Set<AcceleoProjectClasspathEntry> entries = this.computeProjectClassPath(javaProject);
        File projectRoot = project.getLocation().toFile();
        org.eclipse.acceleo.internal.parser.compiler.AcceleoProject acceleoProject = new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject(projectRoot, entries);
        acceleoProject = this.computeProjectDependencies(acceleoProject, javaProject);
        org.eclipse.acceleo.ide.ui.resources.AcceleoProject aProject = new org.eclipse.acceleo.ide.ui.resources.AcceleoProject(project);
        List<Object> accessibleProjects = new ArrayList();
        accessibleProjects = aProject.getRecursivelyAccessibleProjects();
        for (IProject iProject : Lists.reverse(accessibleProjects)) {
            List<IFile> members = this.members((IContainer)iProject, "ecore");
            for (IFile iFile : members) {
                AcceleoPackageRegistry.INSTANCE.registerEcorePackages(iFile.getFullPath().toString(), AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
            }
        }
        List<URI> accessibleOutputFiles = org.eclipse.acceleo.ide.ui.resources.AcceleoProject.computeAcceleoModuleInRequiredPlugins(project);
        acceleoProject.addDependencies((Set)Sets.newHashSet(accessibleOutputFiles));
        AcceleoBuilderSettings settings = new AcceleoBuilderSettings(project);
        String resourceKind = settings.getResourceKind();
        boolean useBinaryResources = !"xmi".equals(resourceKind);
        boolean usePlatformResourcePath = "compilation.platform.resource".equals(settings.getCompilationKind());
        LinkedHashSet<File> mainFiles = new LinkedHashSet<File>();
        this.lastState = this.getLastState(this.getProject());
        if (kind == 6) {
            mainFiles.addAll(this.buildAll(acceleoProject, project, useBinaryResources, usePlatformResourcePath, monitor));
        } else if (this.lastState == null) {
            mainFiles.addAll(this.buildAll(acceleoProject, project, useBinaryResources, usePlatformResourcePath, monitor));
        } else if (kind == 10 || kind == 9) {
            mainFiles.addAll(this.incrementalBuild(acceleoProject, project, useBinaryResources, usePlatformResourcePath, monitor));
        } else if (kind == 15) {
            acceleoProject.clean();
            this.cleanAcceleoMarkers((IResource)project);
        }
        Set fileNotCompiled = acceleoProject.getFileNotCompiled();
        for (File fileToBuild : fileNotCompiled) {
            AcceleoParser acceleoParser = new AcceleoParser(acceleoProject, useBinaryResources, usePlatformResourcePath);
            Set builtFiles = acceleoParser.buildFile(fileToBuild, BasicMonitor.toMonitor((IProgressMonitor)monitor));
            this.addAcceleoMarkers(builtFiles, acceleoParser);
            mainFiles.addAll(acceleoParser.getMainFiles());
        }
        ArrayList<IFile> filesWithMainTag = new ArrayList<IFile>();
        for (File mainFile : mainFiles) {
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(mainFile.getAbsolutePath()));
            filesWithMainTag.add(workspaceFile);
        }
        if (filesWithMainTag.size() > 0) {
            monitor.subTask(AcceleoUIMessages.getString("AcceleoBuilder.GeneratingAcceleoFiles"));
            CreateRunnableAcceleoOperation createRunnableAcceleoOperation = new CreateRunnableAcceleoOperation(new org.eclipse.acceleo.ide.ui.resources.AcceleoProject(project), filesWithMainTag);
            createRunnableAcceleoOperation.run(monitor);
        }
        monitor.subTask(AcceleoUIMessages.getString("AcceleoBuilder.RefreshingProjects"));
        HashSet projectsToRefresh = Sets.newHashSet((Object[])new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject[]{acceleoProject});
        projectsToRefresh.addAll(acceleoProject.getProjectDependencies());
        projectsToRefresh.addAll(acceleoProject.getDependentProjects());
        for (org.eclipse.acceleo.internal.parser.compiler.AcceleoProject projectToRefresh : projectsToRefresh) {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                if (iProject.isAccessible() && projectToRefresh.getProjectRoot().equals(iProject.getLocation().toFile())) {
                    iProject.refreshLocal(2, monitor);
                }
                ++n2;
            }
        }
        this.generateAcceleoBuildFile(monitor);
        monitor.done();
        return accessibleProjects.toArray(new IProject[accessibleProjects.size()]);
    }

    private boolean isWorthBuilding(Set<IProject> projects) {
        boolean isWorthBuilding = false;
        AcceleoProjectState state = this.getLastState(this.getProject());
        if (state == null) {
            isWorthBuilding = true;
            AcceleoUIActivator.log((IStatus)new Status(1, "org.eclipse.acceleo.ide.ui", "DEBUG - Acceleo has decided to build " + projects + " since there are no previous state saved."));
        } else {
            for (IProject iProject : projects) {
                try {
                    ITimestampResourceVisitor visitor = new ITimestampResourceVisitor();
                    iProject.accept((IResourceVisitor)visitor);
                    long ts = visitor.getTimestamp();
                    if (state.getLaststructuralBuildTime() >= ts) continue;
                    isWorthBuilding = true;
                    AcceleoUIActivator.log((IStatus)new Status(1, "org.eclipse.acceleo.ide.ui", "DEBUG - Acceleo has decided to build " + projects + " since at leats a file seems to have been modified."));
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
        if (!isWorthBuilding) {
            AcceleoUIActivator.log((IStatus)new Status(1, "org.eclipse.acceleo.ide.ui", "DEBUG - Acceleo has decided NOT to build " + projects + " since the data shows that it is unnecessary."));
        }
        return isWorthBuilding;
    }

    private Set<File> buildAll(org.eclipse.acceleo.internal.parser.compiler.AcceleoProject acceleoProject, IProject project, boolean useBinaryResources, boolean usePlatformResourcePath, IProgressMonitor monitor) {
        LinkedHashSet<File> filesBuilt = new LinkedHashSet<File>();
        this.clearLastState();
        this.cleanAcceleoMarkers((IResource)project);
        AcceleoParser acceleoParser = new AcceleoParser(acceleoProject, useBinaryResources, usePlatformResourcePath);
        Set builtFiles = acceleoParser.buildAll(BasicMonitor.toMonitor((IProgressMonitor)monitor));
        for (File builtFile : builtFiles) {
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(builtFile.getAbsolutePath()));
            this.cleanAcceleoMarkers((IResource)workspaceFile);
        }
        this.addAcceleoMarkers(builtFiles, acceleoParser);
        filesBuilt.addAll(acceleoParser.getMainFiles());
        AcceleoProjectState state = new AcceleoProjectState();
        state.setProjectName(this.getProject().getName());
        state.setLastStructuralBuildTime(System.currentTimeMillis());
        this.recordNewState(state);
        return filesBuilt;
    }

    private Set<File> incrementalBuild(org.eclipse.acceleo.internal.parser.compiler.AcceleoProject acceleoProject, IProject project, boolean useBinaryResources, boolean usePlatformResourcePath, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<File> filesBuilt = new LinkedHashSet<File>();
        this.clearLastState();
        List<IFile> deltaMembers = this.deltaMembers(this.getDelta(project), monitor);
        AcceleoParser acceleoParser = new AcceleoParser(acceleoProject, useBinaryResources, usePlatformResourcePath);
        for (IFile iFile : deltaMembers) {
            File fileToBuild = iFile.getLocation().toFile();
            Set builtFiles = acceleoParser.buildFile(fileToBuild, BasicMonitor.toMonitor((IProgressMonitor)monitor));
            for (File builtFile : builtFiles) {
                IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(builtFile.getAbsolutePath()));
                this.cleanAcceleoMarkers((IResource)workspaceFile);
            }
            this.addAcceleoMarkers(builtFiles, acceleoParser);
            filesBuilt.addAll(acceleoParser.getMainFiles());
        }
        AcceleoProjectState state = new AcceleoProjectState();
        state.setProjectName(this.getProject().getName());
        state.setLastStructuralBuildTime(System.currentTimeMillis());
        this.recordNewState(state);
        return filesBuilt;
    }

    private void addAcceleoMarkers(Set<File> builtFiles, AcceleoParser parser) {
        for (File builtFile : builtFiles) {
            try {
                IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(builtFile.getAbsolutePath()));
                Collection infos = parser.getInfos(builtFile);
                for (AcceleoParserInfo info : infos) {
                    AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.info", workspaceFile, info.getLine(), info.getPosBegin(), info.getPosEnd(), info.getMessage());
                }
                Collection warnings = parser.getWarnings(builtFile);
                for (AcceleoParserWarning warning : warnings) {
                    AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.warning", workspaceFile, warning.getLine(), warning.getPosBegin(), warning.getPosEnd(), warning.getMessage());
                }
                Collection problems = parser.getProblems(builtFile);
                for (AcceleoParserProblem problem : problems) {
                    AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.problem", workspaceFile, problem.getLine(), problem.getPosBegin(), problem.getPosEnd(), problem.getMessage());
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
    }

    private void cleanAcceleoMarkers(IResource resource) {
        try {
            if (resource.exists() && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.acceleo.ide.ui.problem", true, 2);
                resource.deleteMarkers("org.eclipse.acceleo.ide.ui.warning", true, 2);
                resource.deleteMarkers("org.eclipse.acceleo.ide.ui.info", true, 2);
                resource.deleteMarkers("org.eclipse.acceleo.ide.ui.override", true, 2);
                resource.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    private org.eclipse.acceleo.internal.parser.compiler.AcceleoProject computeProjectDependencies(org.eclipse.acceleo.internal.parser.compiler.AcceleoProject acceleoProject, IJavaProject javaProject) {
        this.mappedProjects.put(javaProject, acceleoProject);
        try {
            IProject[] projects;
            String[] requiredProjectNames;
            String[] stringArray = requiredProjectNames = javaProject.getRequiredProjectNames();
            int n = requiredProjectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredProjectName = stringArray[n2];
                IProject requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredProjectName);
                try {
                    if (requiredProject.isAccessible() && requiredProject.hasNature("org.eclipse.jdt.core.javanature") && requiredProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                        IJavaProject requiredJavaProject = JavaCore.create((IProject)requiredProject);
                        File projectRoot = requiredProject.getLocation().toFile();
                        org.eclipse.acceleo.internal.parser.compiler.AcceleoProject mappedProject = this.mappedProjects.get(requiredJavaProject);
                        if (mappedProject != null) {
                            acceleoProject.addProjectDependencies((Set)Sets.newHashSet((Object[])new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject[]{mappedProject}));
                        } else {
                            Set<AcceleoProjectClasspathEntry> entries = this.computeProjectClassPath(requiredJavaProject);
                            org.eclipse.acceleo.internal.parser.compiler.AcceleoProject requiredAcceleoProject = new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject(projectRoot, entries);
                            if (!acceleoProject.getProjectDependencies().contains(requiredAcceleoProject)) {
                                acceleoProject.addProjectDependencies((Set)Sets.newHashSet((Object[])new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject[]{requiredAcceleoProject}));
                                requiredAcceleoProject = this.computeProjectDependencies(requiredAcceleoProject, requiredJavaProject);
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
                ++n2;
            }
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n3 = projects.length;
            n = 0;
            while (n < n3) {
                IProject iProject = iProjectArray[n];
                try {
                    if (iProject.isAccessible() && iProject.hasNature("org.eclipse.jdt.core.javanature") && iProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
                        String[] projectNames;
                        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                        boolean requiring = false;
                        String[] stringArray2 = projectNames = iJavaProject.getRequiredProjectNames();
                        int n4 = projectNames.length;
                        int requiredAcceleoProject = 0;
                        while (requiredAcceleoProject < n4) {
                            String projectName = stringArray2[requiredAcceleoProject];
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            if (acceleoProject.getProjectRoot().equals(project.getLocation().toFile())) {
                                requiring = true;
                            }
                            ++requiredAcceleoProject;
                        }
                        org.eclipse.acceleo.internal.parser.compiler.AcceleoProject mappedProject = this.mappedProjects.get(iJavaProject);
                        if (requiring && mappedProject != null) {
                            acceleoProject.addDependentProjects((Set)Sets.newHashSet((Object[])new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject[]{mappedProject}));
                        } else if (requiring && mappedProject == null) {
                            Set<AcceleoProjectClasspathEntry> entries = this.computeProjectClassPath(iJavaProject);
                            org.eclipse.acceleo.internal.parser.compiler.AcceleoProject requiringAcceleoProject = new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject(iProject.getLocation().toFile(), entries);
                            if (!acceleoProject.getDependentProjects().contains(requiringAcceleoProject)) {
                                acceleoProject.addDependentProjects((Set)Sets.newHashSet((Object[])new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject[]{requiringAcceleoProject}));
                                requiringAcceleoProject = this.computeProjectDependencies(requiringAcceleoProject, iJavaProject);
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
        return acceleoProject;
    }

    private Set<AcceleoProjectClasspathEntry> computeProjectClassPath(IJavaProject javaProject) {
        LinkedHashSet<AcceleoProjectClasspathEntry> classpathEntries = new LinkedHashSet<AcceleoProjectClasspathEntry>();
        try {
            IClasspathEntry[] rawClasspath;
            IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                int entryKind = iClasspathEntry.getEntryKind();
                if (3 == entryKind) {
                    IProject project;
                    IPath inputFolderPath = iClasspathEntry.getPath();
                    IPath outputFolderPath = iClasspathEntry.getOutputLocation();
                    if (outputFolderPath == null) {
                        outputFolderPath = javaProject.getOutputLocation();
                    }
                    if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(inputFolderPath.lastSegment())) == null || !project.exists() || !project.equals((Object)javaProject.getProject())) {
                        IFolder inputContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder(inputFolderPath);
                        IFolder outputContainer = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputFolderPath);
                        if (inputContainer != null && outputContainer != null) {
                            File inputDirectory = inputContainer.getLocation().toFile();
                            File outputDirectory = outputContainer.getLocation().toFile();
                            AcceleoProjectClasspathEntry entry = new AcceleoProjectClasspathEntry(inputDirectory, outputDirectory);
                            classpathEntries.add(entry);
                            this.outputFolders.add(outputDirectory);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
        return classpathEntries;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        ArrayList<IFile> filesOutput = new ArrayList<IFile>();
        for (File outputFolder : this.outputFolders) {
            Path path = new Path(outputFolder.getAbsolutePath());
            AcceleoBuilderUtils.members(filesOutput, (IContainer)this.getProject(), "mtl", (IPath)path);
            if (filesOutput.size() <= 0) continue;
            Collections.sort(filesOutput, new Comparator<IFile>(){

                @Override
                public int compare(IFile arg0, IFile arg1) {
                    long m1;
                    long m0 = arg0.getLocation().toFile().lastModified();
                    if (m0 < (m1 = arg1.getLocation().toFile().lastModified())) {
                        return 1;
                    }
                    return -1;
                }
            });
            this.registerAccessibleEcoreFiles();
            IFile[] files = filesOutput.toArray(new IFile[filesOutput.size()]);
            AcceleoCompileOperation compileOperation = new AcceleoCompileOperation(this.getProject(), files, false);
            compileOperation.run(monitor);
            this.generateAcceleoBuildFile(monitor);
        }
    }

    private void registerAccessibleEcoreFiles() throws CoreException {
        ArrayList<IFile> ecoreFiles = new ArrayList<IFile>();
        org.eclipse.acceleo.ide.ui.resources.AcceleoProject acceleoProject = new org.eclipse.acceleo.ide.ui.resources.AcceleoProject(this.getProject());
        for (IProject project : acceleoProject.getRecursivelyAccessibleProjects()) {
            if (!project.isAccessible()) continue;
            for (File outputFolder : this.outputFolders) {
                Path path = new Path(outputFolder.getAbsolutePath());
                AcceleoBuilderUtils.members(ecoreFiles, (IContainer)project, "ecore", (IPath)path);
            }
        }
        for (IFile ecoreFile : Lists.reverse(ecoreFiles)) {
            AcceleoPackageRegistry.INSTANCE.registerEcorePackages(ecoreFile.getFullPath().toString(), AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
        }
    }

    private void generateAcceleoBuildFile(IProgressMonitor monitor) throws CoreException {
        IFile buildProperties = this.getProject().getFile("build.properties");
        for (File outputFolder : this.outputFolders) {
            Path path = new Path(outputFolder.getAbsolutePath());
            if (path.segmentCount() < 1) continue;
            IFile buildAcceleo = this.getProject().getFile("build.acceleo");
            org.eclipse.acceleo.ide.ui.resources.AcceleoProject project = new org.eclipse.acceleo.ide.ui.resources.AcceleoProject(this.getProject());
            List<IProject> dependencies = project.getRecursivelyAccessibleProjects();
            dependencies.remove(this.getProject());
            AcceleoProject acceleoProject = AcceleowizardmodelFactory.eINSTANCE.createAcceleoProject();
            EList<String> pluginDependencies = acceleoProject.getPluginDependencies();
            for (IProject iProject : dependencies) {
                pluginDependencies.add(iProject.getName());
            }
            AcceleoUIGenerator.getDefault().generateBuildAcceleo(acceleoProject, buildAcceleo.getParent());
            if (!buildProperties.exists() || FileContent.getFileContent((File)buildProperties.getLocation().toFile()).indexOf(buildAcceleo.getName()) != -1) continue;
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", AcceleoUIMessages.getString("AcceleoBuilder.AcceleoBuildFileIssue", this.getProject().getName())));
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        List<IFile> deltaFilesOutput = this.deltaMembers(delta, monitor);
        if (deltaFilesOutput.size() > 0) {
            boolean containsManifest = false;
            int i = 0;
            while (!containsManifest && i < deltaFilesOutput.size()) {
                containsManifest = "MANIFEST.MF".equals(deltaFilesOutput.get(i).getName());
                ++i;
            }
            if (containsManifest) {
                deltaFilesOutput.clear();
                for (File outputFolder : this.outputFolders) {
                    Path path = new Path(outputFolder.getAbsolutePath());
                    AcceleoBuilderUtils.members(deltaFilesOutput, (IContainer)this.getProject(), "mtl", (IPath)path);
                }
            } else {
                this.computeOtherFilesToBuild(deltaFilesOutput);
            }
        }
        if (deltaFilesOutput.size() > 0) {
            Collections.sort(deltaFilesOutput, new Comparator<IFile>(){

                @Override
                public int compare(IFile arg0, IFile arg1) {
                    long m1;
                    long m0 = arg0.getLocation().toFile().lastModified();
                    if (m0 < (m1 = arg1.getLocation().toFile().lastModified())) {
                        return 1;
                    }
                    return -1;
                }
            });
            this.registerAccessibleEcoreFiles();
            IFile[] files = deltaFilesOutput.toArray(new IFile[deltaFilesOutput.size()]);
            AcceleoCompileOperation compileOperation = new AcceleoCompileOperation(this.getProject(), files, false);
            compileOperation.run(monitor);
            this.generateAcceleoBuildFile(monitor);
        } else {
            ArrayList<IFile> deltaRemovedFilesOutput = new ArrayList<IFile>();
            this.deltaRemovedMembers(deltaRemovedFilesOutput, delta, monitor);
            if (deltaRemovedFilesOutput.size() > 0) {
                for (IFile removedFile : deltaRemovedFilesOutput) {
                    if (!"java".equals(removedFile.getFileExtension())) continue;
                    this.fullBuild(monitor);
                    break;
                }
            }
        }
    }

    private void computeOtherFilesToBuild(List<IFile> deltaFiles) throws CoreException {
        org.eclipse.acceleo.ide.ui.resources.AcceleoProject acceleoProject = new org.eclipse.acceleo.ide.ui.resources.AcceleoProject(this.getProject());
        ArrayList<IFile> otherTemplates = new ArrayList<IFile>();
        for (File outputFolder : this.outputFolders) {
            Path path = new Path(outputFolder.getAbsolutePath());
            AcceleoBuilderUtils.members(otherTemplates, (IContainer)this.getProject(), "mtl", (IPath)path);
        }
        ArrayList<Sequence> importSequencesToSearch = new ArrayList<Sequence>();
        int i = 0;
        while (i < deltaFiles.size()) {
            IFile deltaFile = deltaFiles.get(i);
            if ("mtl".equals(deltaFile.getFileExtension())) {
                importSequencesToSearch.addAll(AcceleoBuilderUtils.getImportSequencesToSearch(acceleoProject, deltaFile));
                otherTemplates.remove(deltaFile);
            }
            ++i;
        }
        List<IFile> otherTemplatesToBuild = this.getOtherTemplatesToBuild(acceleoProject, otherTemplates, importSequencesToSearch);
        while (otherTemplatesToBuild.size() > 0) {
            int i2 = 0;
            while (i2 < otherTemplatesToBuild.size()) {
                IFile otherTemplateToBuild = otherTemplatesToBuild.get(i2);
                otherTemplates.remove(otherTemplateToBuild);
                if (!deltaFiles.contains(otherTemplateToBuild)) {
                    deltaFiles.add(otherTemplateToBuild);
                    importSequencesToSearch.addAll(AcceleoBuilderUtils.getImportSequencesToSearch(acceleoProject, otherTemplateToBuild));
                }
                ++i2;
            }
            otherTemplatesToBuild = this.getOtherTemplatesToBuild(acceleoProject, otherTemplates, importSequencesToSearch);
        }
    }

    private List<IFile> getOtherTemplatesToBuild(org.eclipse.acceleo.ide.ui.resources.AcceleoProject acceleoProject, List<IFile> otherTemplates, List<Sequence> importSequencesToSearch) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        int i = 0;
        while (i < otherTemplates.size()) {
            IFile otherTemplate = otherTemplates.get(i);
            IPath outputPath = acceleoProject.getOutputFilePath(otherTemplate);
            if (outputPath != null && !this.getProject().getFile(outputPath.removeFirstSegments(1)).exists()) {
                result.add(otherTemplate);
            } else {
                StringBuffer otherTemplateContent = FileContent.getFileContent((File)otherTemplate.getLocation().toFile());
                int j = 0;
                while (j < importSequencesToSearch.size()) {
                    Sequence importSequence = importSequencesToSearch.get(j);
                    if (importSequence.search(otherTemplateContent).b() > -1) {
                        result.add(otherTemplate);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        File projectRoot = project.getLocation().toFile();
        Set<AcceleoProjectClasspathEntry> entries = this.computeProjectClassPath(javaProject);
        org.eclipse.acceleo.internal.parser.compiler.AcceleoProject acceleoProject = new org.eclipse.acceleo.internal.parser.compiler.AcceleoProject(projectRoot, entries);
        acceleoProject = this.computeProjectDependencies(acceleoProject, javaProject);
        acceleoProject.clean();
        this.cleanAcceleoMarkers((IResource)project);
    }

    private List<IFile> deltaMembers(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFile> deltaFilesOutput = new ArrayList<IFile>();
        if (delta != null) {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                if (delta.getKind() == 2 && "mtl".equals(resource.getFileExtension())) {
                    this.removeOutputFile((IFile)resource, monitor);
                }
                if (delta.getKind() != 2 && ("mtl".equals(resource.getFileExtension()) || "MANIFEST.MF".equals(resource.getName())) || "plugin.xml".equals(resource.getName())) {
                    deltaFilesOutput.add((IFile)resource);
                }
            } else {
                boolean shouldConsider = true;
                for (File outputFolder : this.outputFolders) {
                    if (outputFolder != null && !new Path(outputFolder.getAbsolutePath()).isPrefixOf(resource.getLocation())) continue;
                    shouldConsider = false;
                }
                if (shouldConsider) {
                    IResourceDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    while (i < children.length) {
                        deltaFilesOutput.addAll(this.deltaMembers(children[i], monitor));
                        ++i;
                    }
                }
            }
        }
        return deltaFilesOutput;
    }

    private void deltaRemovedMembers(List<IFile> deltaFilesOutput, IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        if (delta != null) {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                if (delta.getKind() == 2) {
                    deltaFilesOutput.add((IFile)resource);
                }
            } else {
                for (File outputFolder : this.outputFolders) {
                    if (outputFolder != null && new Path(outputFolder.getAbsolutePath()).isPrefixOf(resource.getLocation())) continue;
                    IResourceDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.deltaRemovedMembers(deltaFilesOutput, children[i], monitor);
                        ++i;
                    }
                }
            }
        }
    }

    private void removeOutputFile(IFile inputFile, IProgressMonitor monitor) throws CoreException {
        org.eclipse.acceleo.ide.ui.resources.AcceleoProject acceleoProject = new org.eclipse.acceleo.ide.ui.resources.AcceleoProject(this.getProject());
        IPath outputPath = acceleoProject.getOutputFilePath(inputFile);
        IResource outputFile = ResourcesPlugin.getWorkspace().getRoot().findMember(outputPath);
        if (outputFile instanceof IFile && outputFile.isAccessible()) {
            outputFile.delete(true, monitor);
        }
    }

    private List<IFile> members(IContainer container, String extension) throws CoreException {
        IResource[] children;
        ArrayList<IFile> output = new ArrayList<IFile>();
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && extension.equals(((IFile)resource).getFileExtension())) {
                    output.add((IFile)resource);
                } else if (resource instanceof IContainer) {
                    output.addAll(this.members((IContainer)resource, extension));
                }
                ++i;
            }
        }
        return output;
    }

    private void recordNewState(AcceleoProjectState state) {
        AcceleoModelManager.getManager().setProjectState(this.getProject(), state);
    }

    private void clearLastState() {
        AcceleoModelManager.getManager().setProjectState(this.getProject(), null);
    }

    private AcceleoProjectState getLastState(IProject project) {
        return AcceleoModelManager.getManager().getLastBuiltState(project, (IProgressMonitor)new NullProgressMonitor());
    }

    private class ITimestampResourceVisitor
    implements IResourceVisitor {
        private long timestamp;

        private ITimestampResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.exists() && resource.isAccessible() && (resource instanceof IFolder || resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension())) && resource.getLocation().toFile().lastModified() > this.timestamp) {
                this.timestamp = resource.getLocation().toFile().lastModified();
            }
            return true;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

