/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.NewVariableAction;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableDropListener
extends DropTargetAdapter {
    private TreeViewer viewer;

    public VariableDropListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragEnter(DropTargetEvent event) {
        if (!LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
            return;
        }
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        Collection<?> selection = this.getSelection(event);
        if (!selection.isEmpty()) {
            Widget targetItem = event.item;
            if (targetItem instanceof TreeItem) {
                Object targetVariable = targetItem.getData();
                while (targetItem != null && !(targetVariable instanceof Variable)) {
                    if ((targetItem = ((TreeItem)targetItem).getParentItem()) == null) continue;
                    targetVariable = targetItem.getData();
                }
                if (targetVariable instanceof Variable) {
                    this.addToVariable((Variable)targetVariable, selection);
                } else {
                    this.createNewVariable(selection);
                }
            } else {
                this.createNewVariable(selection);
            }
        }
    }

    private void addToVariable(Variable targetVariable, Collection<?> selection) {
        ArrayList<Object> newValue;
        Object currentValue = targetVariable.getValue();
        if (currentValue instanceof Collection) {
            newValue = (ArrayList<Object>)currentValue;
        } else {
            newValue = new ArrayList<Object>();
            if (currentValue != null) {
                newValue.add(currentValue);
            }
        }
        newValue.addAll(selection);
        if (newValue.size() == 1) {
            targetVariable.setValue(newValue.iterator().next());
        } else {
            targetVariable.setValue(newValue);
        }
        this.viewer.refresh();
    }

    private void createNewVariable(Collection<?> selection) {
        Collection<?> variableValue = selection.size() == 1 ? selection.iterator().next() : selection;
        NewVariableAction action = new NewVariableAction(this.viewer, variableValue);
        action.run();
    }

    private Collection<?> getSelection(DropTargetEvent event) {
        if (event.data instanceof IStructuredSelection) {
            List objectList = ((IStructuredSelection)event.data).toList();
            ArrayList<Object> variablesValues = new ArrayList<Object>();
            for (Object object : objectList) {
                EObject variableEObject = null;
                variableEObject = object instanceof EObject ? (EObject)object : (object instanceof IAdaptable ? (EObject)((IAdaptable)object).getAdapter(EObject.class) : (EObject)Platform.getAdapterManager().getAdapter(object, EObject.class));
                if (variableEObject != null) {
                    variablesValues.add(variableEObject);
                    continue;
                }
                variablesValues.add(object);
            }
            return variablesValues;
        }
        return Collections.emptyList();
    }
}

