/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast;

import java.util.List;
import org.eclipse.acceleo.common.utils.AcceleoASTNodeAdapter;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.internal.parser.ast.ASTFactory;
import org.eclipse.acceleo.internal.parser.ast.IASTProvider;
import org.eclipse.acceleo.internal.parser.ast.ocl.OCLParser;
import org.eclipse.acceleo.model.mtl.Comment;
import org.eclipse.acceleo.model.mtl.CommentBody;
import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.acceleo.model.mtl.DocumentedElement;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.FileBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.OpenModeKind;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TraceBlock;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CST2ASTConverter {
    protected static final String UNIX_LINE_SEPARATOR = "\n";
    protected static final String MAC_LINE_SEPARATOR = "\r";
    protected static final String DOS_LINE_SEPARATOR = "\r\n";
    protected ASTFactory factory = new ASTFactory();
    protected IASTProvider astProvider = null;
    protected boolean isCanceled = false;

    public OCLParser getOCL() {
        return this.factory.getOCL();
    }

    public void setASTProvider(IASTProvider theASTProvider) {
        this.astProvider = theASTProvider;
        this.factory.setLogHandler(this.astProvider);
    }

    protected void logProblem(String message, int posBegin, int posEnd) {
        if (this.astProvider != null) {
            this.astProvider.logProblem(message, posBegin, posEnd);
        }
    }

    protected void logWarning(String message, int posBegin, int posEnd) {
        if (this.astProvider != null) {
            this.astProvider.logWarning(message, posBegin, posEnd);
        }
    }

    protected void logInfo(String message, int posBegin, int posEnd) {
        if (this.astProvider != null) {
            this.astProvider.logInfo(message, posBegin, posEnd);
        }
    }

    public void createAST(org.eclipse.acceleo.parser.cst.Module rootCST, Resource resourceAST) {
        if (rootCST != null) {
            Module oModule = this.factory.getOrCreateModule(rootCST);
            resourceAST.getContents().add(0, (Object)oModule);
            this.factory.initOCL(resourceAST);
            this.transformStepCopy(rootCST);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Module iModule) {
        Module oModule = this.factory.getOrCreateModule(iModule);
        if (iModule != null && oModule != null) {
            String ioName = iModule.getName();
            if (ioName != null && !"".equals(ioName)) {
                oModule.setName(ioName);
            }
            oModule.setStartHeaderPosition(iModule.getStartPosition());
            oModule.setEndHeaderPosition(-1);
            this.transformStepCopyModuleDocumentation(iModule, oModule);
            this.transformStepCopyOwnedModuleElement(iModule, oModule);
            for (org.eclipse.acceleo.parser.cst.TypedModel iNext : iModule.getInput()) {
                TypedModel oNext = this.factory.getOrCreateTypedModel(iNext);
                if (oNext != null) {
                    oModule.getInput().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            if (iModule.getExtends() != null && iModule.getExtends().size() > 1) {
                int posBegin = ((ModuleExtendsValue)iModule.getExtends().get(0)).getStartPosition();
                int posEnd = ((ModuleExtendsValue)iModule.getExtends().get(iModule.getExtends().size() - 1)).getEndPosition();
                this.logWarning(AcceleoParserMessages.getString("AcceleoParser.Warning.MultipleExtends"), posBegin, posEnd);
            }
        }
    }

    private void transformStepCopyModuleDocumentation(org.eclipse.acceleo.parser.cst.Module iModule, Module oModule) {
        org.eclipse.acceleo.parser.cst.Documentation iDocumentation;
        Documentation oDocumentation;
        if (iModule.getDocumentation() != null && (oDocumentation = this.factory.getOrCreateDocumentation(iDocumentation = iModule.getDocumentation())) != null) {
            CommentBody oCommentBody = MtlFactory.eINSTANCE.createCommentBody();
            oDocumentation.setName(iDocumentation.getName());
            oDocumentation.setStartPosition(iDocumentation.getStartPosition());
            oDocumentation.setEndPosition(iDocumentation.getEndPosition());
            oCommentBody.setStartPosition(-1);
            oCommentBody.setEndPosition(-1);
            oCommentBody.setValue(iDocumentation.getBody());
            oDocumentation.setBody(oCommentBody);
            oModule.setDocumentation(oDocumentation);
            oDocumentation.setDocumentedElement((DocumentedElement)oModule);
            if (oDocumentation.getBody().getValue().contains("@deprecated")) {
                oModule.setDeprecated(true);
            }
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.TypedModel iTypedModel) {
        TypedModel oTypedModel = this.factory.getOrCreateTypedModel(iTypedModel);
        if (iTypedModel != null && oTypedModel != null) {
            for (EPackage ioNext : iTypedModel.getTakesTypesFrom()) {
                oTypedModel.getTakesTypesFrom().add((Object)ioNext);
            }
        }
    }

    private void transformStepCopy(Template iTemplate) {
        org.eclipse.acceleo.model.mtl.Template oTemplate = this.factory.getOrCreateTemplate(iTemplate);
        if (iTemplate != null && oTemplate != null) {
            EList<TemplateOverridesValue> overrides;
            InitSection iInit;
            org.eclipse.acceleo.model.mtl.InitSection oInit;
            org.eclipse.acceleo.parser.cst.VisibilityKind iVisibility = iTemplate.getVisibility();
            VisibilityKind oVisibility = VisibilityKind.get((int)iVisibility.getValue());
            oTemplate.setVisibility(oVisibility);
            this.transformStepCopyPositions(iTemplate, (ASTNode)oTemplate);
            String ioName = iTemplate.getName();
            if (ioName != null && !"".equals(ioName)) {
                oTemplate.setName(ioName);
            }
            if ((oInit = this.factory.getOrCreateInitSection(iInit = iTemplate.getInit())) != null) {
                oTemplate.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iGuard = iTemplate.getGuard();
            this.transformStepCopy(iGuard);
            ModelExpression iPost = iTemplate.getPost();
            this.transformStepCopy(iPost);
            this.transformStepCopyBody(iTemplate, (org.eclipse.acceleo.model.mtl.Block)oTemplate);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iTemplate.getParameter()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oTemplate.getParameter().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            boolean isMain = false;
            TreeIterator iChildren = iTemplate.eAllContents();
            while (!isMain && iChildren.hasNext()) {
                EObject iChild = (EObject)iChildren.next();
                if (!(iChild instanceof org.eclipse.acceleo.parser.cst.Comment) || ((org.eclipse.acceleo.parser.cst.Comment)iChild).getBody() == null || ((org.eclipse.acceleo.parser.cst.Comment)iChild).getBody().indexOf("@main") <= -1) continue;
                if (2 != oTemplate.getVisibility().getValue()) {
                    this.logWarning(AcceleoParserMessages.getString("CSTParser.InvalidVisibilityOfMainTemplate"), ((org.eclipse.acceleo.parser.cst.Comment)iChild).getStartPosition(), ((org.eclipse.acceleo.parser.cst.Comment)iChild).getEndPosition());
                }
                isMain = true;
                oTemplate.setMain(isMain);
            }
            if (iTemplate.getOverrides().size() > 1) {
                overrides = iTemplate.getOverrides();
                this.logWarning(AcceleoParserMessages.getString("AcceleoParser.Warning.MultipleOverrides"), ((TemplateOverridesValue)overrides.get(0)).getStartPosition(), ((TemplateOverridesValue)overrides.get(overrides.size() - 1)).getEndPosition());
            }
            if (iTemplate.getOverrides().size() > 0) {
                overrides = iTemplate.getOverrides();
                String message = AcceleoParserMessages.getString("AcceleoParser.Info.TemplateOverride", iTemplate.getName(), ((TemplateOverridesValue)overrides.get(0)).getName());
                this.logInfo("AcceleoParser.Info.TemplateOverride" + message, ((TemplateOverridesValue)overrides.get(0)).getStartPosition(), ((TemplateOverridesValue)overrides.get(overrides.size() - 1)).getEndPosition());
            }
            if (oTemplate.isDeprecated()) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.DeprecatedTemplate", oTemplate.getName()), oTemplate.getStartPosition(), oTemplate.getEndPosition());
            }
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Variable iVariable) {
        Variable oVariable = this.factory.getOrCreateVariable(iVariable);
        if (iVariable != null && oVariable != null) {
            this.transformStepCopyPositions(iVariable, (ASTNode)oVariable);
            String ioName = iVariable.getName();
            if (ioName != null && !"".equals(ioName)) {
                oVariable.setName(ioName);
            }
            String ioType = iVariable.getType();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("MTL");
            eAnnotation.getDetails().put((Object)"type", (Object)ioType);
            oVariable.getEAnnotations().add((Object)eAnnotation);
        }
    }

    private void transformStepCopy(ModelExpression iModelExpression) {
    }

    private void transformStepCopy(TextExpression iTextExpression) {
        StringLiteralExp oTextExpression = this.factory.getOrCreateStringLiteralExp(iTextExpression);
        if (iTextExpression != null && oTextExpression != null) {
            this.transformStepCopyPositions(iTextExpression, (ASTNode)oTextExpression);
            this.transformFormattedText(iTextExpression, oTextExpression);
            if ("".equals(oTextExpression.getStringSymbol())) {
                EcoreUtil.remove((EObject)oTextExpression);
            }
        }
    }

    private boolean isRelevantLine(List<CSTNode> bodyContent, int index, boolean checkStartPosition) {
        TextExpression expression = (TextExpression)bodyContent.get(index);
        boolean isSingleLineExpression = this.isSingleLineExpression(expression);
        boolean result = true;
        if (this.isSingleLineExpression((CSTNode)expression.eContainer()) || isSingleLineExpression && !this.isEmpty(expression.getValue())) {
            return true;
        }
        if (index > 0 && (isSingleLineExpression || checkStartPosition && this.startsInEmptyLine(expression.getValue()))) {
            result = this.containsRelevantExpressionsOnLine(bodyContent, index - 1, true);
        }
        if (index < bodyContent.size() - 1 && (isSingleLineExpression || !checkStartPosition && this.endsInEmptyLine(expression.getValue()))) {
            result = this.containsRelevantExpressionsOnLine(bodyContent, index + 1, false);
        }
        return result;
    }

    private boolean containsRelevantExpressionsOnLine(List<? extends CSTNode> bodyContent, int index, boolean lookbehind) {
        int startIndex;
        EList<TemplateExpression> nextBody;
        boolean result = false;
        int increment = 1;
        if (lookbehind) {
            increment = -1;
        }
        int nextIndex = index;
        CSTNode nextNode = bodyContent.get(nextIndex);
        while (nextIndex + increment > 0 && nextIndex + increment < bodyContent.size() - 1 && this.isSingleLineExpression(nextNode)) {
            if (nextNode instanceof org.eclipse.acceleo.parser.cst.Comment) {
                nextIndex += increment;
            } else {
                if (nextNode instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                    result = true;
                    break;
                }
                if (nextNode instanceof TextExpression && this.isEmpty(((TextExpression)nextNode).getValue())) {
                    nextIndex += increment;
                } else if (nextNode instanceof Block) {
                    nextBody = ((Block)nextNode).getBody();
                    if (nextBody.size() == 0) {
                        nextIndex += increment;
                    } else {
                        startIndex = 0;
                        if (lookbehind) {
                            startIndex = nextBody.size() - 1;
                        }
                        if (this.containsRelevantExpressionsOnLine((List<? extends CSTNode>)nextBody, startIndex, lookbehind)) {
                            result = true;
                            break;
                        }
                        nextIndex += increment;
                    }
                } else {
                    result = true;
                    break;
                }
            }
            nextNode = bodyContent.get(nextIndex);
        }
        if (result) {
            return result;
        }
        if (nextNode instanceof org.eclipse.acceleo.parser.cst.Comment) {
            result = false;
        } else if (nextNode instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
            result = true;
        } else if (nextNode instanceof TextExpression) {
            result = lookbehind && this.endsInEmptyLine(((TextExpression)nextNode).getValue()) ? false : lookbehind || !this.startsInEmptyLine(((TextExpression)nextNode).getValue());
        } else if (nextNode instanceof Block) {
            nextBody = ((Block)nextNode).getBody();
            if (nextBody.size() == 0) {
                result = false;
            } else {
                startIndex = 0;
                if (lookbehind) {
                    startIndex = nextBody.size() - 1;
                }
                if (this.containsRelevantExpressionsOnLine((List<? extends CSTNode>)nextBody, startIndex, lookbehind)) {
                    result = true;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean isSingleLineExpression(CSTNode node) {
        if (node instanceof TextExpression) {
            return !((TextExpression)node).getValue().contains(UNIX_LINE_SEPARATOR) && !((TextExpression)node).getValue().contains(MAC_LINE_SEPARATOR);
        }
        return this.astProvider.getLineOfOffset(node.getStartPosition()) == this.astProvider.getLineOfOffset(node.getEndPosition() - 1);
    }

    private boolean shouldKeepLastNewLine(String textValue, String transformedValue) {
        String lineSeparator;
        if (textValue.contains(DOS_LINE_SEPARATOR)) {
            lineSeparator = DOS_LINE_SEPARATOR;
        } else if (textValue.contains(UNIX_LINE_SEPARATOR)) {
            lineSeparator = UNIX_LINE_SEPARATOR;
        } else if (textValue.contains(MAC_LINE_SEPARATOR)) {
            lineSeparator = MAC_LINE_SEPARATOR;
        } else {
            return false;
        }
        return textValue.equals(String.valueOf(lineSeparator) + lineSeparator) && transformedValue.equals(lineSeparator);
    }

    private boolean startsInEmptyLine(String text) {
        int endIndex = text.length();
        if (text.contains(DOS_LINE_SEPARATOR)) {
            endIndex = text.indexOf(DOS_LINE_SEPARATOR);
        } else if (text.contains(UNIX_LINE_SEPARATOR)) {
            endIndex = text.indexOf(UNIX_LINE_SEPARATOR);
        } else if (text.contains(MAC_LINE_SEPARATOR)) {
            endIndex = text.indexOf(MAC_LINE_SEPARATOR);
        }
        boolean endsInEmptyLine = true;
        int i = 0;
        while (i < endIndex) {
            if (!Character.isWhitespace(text.charAt(i))) {
                endsInEmptyLine = false;
                break;
            }
            ++i;
        }
        return endsInEmptyLine;
    }

    private boolean isEmpty(String text) {
        boolean endsInEmptyLine = true;
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                endsInEmptyLine = false;
                break;
            }
            ++i;
        }
        return endsInEmptyLine;
    }

    private boolean endsInEmptyLine(String text) {
        int startIndex = 0;
        if (text.contains(DOS_LINE_SEPARATOR)) {
            startIndex = text.lastIndexOf(DOS_LINE_SEPARATOR) + 2;
        } else if (text.contains(UNIX_LINE_SEPARATOR)) {
            startIndex = text.lastIndexOf(UNIX_LINE_SEPARATOR) + 1;
        } else if (text.contains(MAC_LINE_SEPARATOR)) {
            startIndex = text.lastIndexOf(MAC_LINE_SEPARATOR) + 1;
        }
        boolean endsInEmptyLine = true;
        int i = startIndex;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                endsInEmptyLine = false;
                break;
            }
            ++i;
        }
        return endsInEmptyLine;
    }

    private void transformFormattedText(TextExpression iTextExpression, StringLiteralExp oTextExpression) {
        String ioValue = iTextExpression.getValue();
        if (ioValue == null || iTextExpression.eContainingFeature() != CstPackage.eINSTANCE.getBlock_Body() || iTextExpression.eContainer() == null) {
            oTextExpression.setStringSymbol(ioValue);
            return;
        }
        List eBody = (List)iTextExpression.eContainer().eGet((EStructuralFeature)CstPackage.eINSTANCE.getBlock_Body());
        if (eBody != null && eBody.size() > 0) {
            int shiftEnd;
            int index = eBody.indexOf(iTextExpression);
            int shiftBegin = index == 0 && iTextExpression.eContainer() instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock ? 0 : (index == 0 && this.isSingleLineExpression((CSTNode)iTextExpression.eContainer()) ? 0 : (index > 0 && !this.isRelevantLine(eBody, index, true) ? this.shiftBegin(ioValue) : (index == 0 || eBody.get(index - 1) instanceof Block && !(eBody.get(index - 1) instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) && !this.isSingleLineExpression((CSTNode)eBody.get(index - 1)) ? this.shiftBegin(ioValue) : 0)));
            if (shiftBegin > ioValue.length()) {
                oTextExpression.setStartPosition(oTextExpression.getStartPosition() + ioValue.length());
                ioValue = "";
            } else if (shiftBegin > 0) {
                oTextExpression.setStartPosition(oTextExpression.getStartPosition() + shiftBegin);
                ioValue = ioValue.substring(shiftBegin);
            }
            if (index == eBody.size() - 1 && iTextExpression.eContainer() instanceof Template) {
                boolean keepNewLine = this.shouldKeepLastNewLine(iTextExpression.getValue(), ioValue);
                shiftEnd = this.shiftEnd(ioValue, keepNewLine);
            } else {
                shiftEnd = index == eBody.size() - 1 && !this.isSingleLineExpression((CSTNode)iTextExpression.eContainer()) ? this.shiftEnd(ioValue, true) : (!this.isRelevantLine(eBody, index, false) ? this.shiftEnd(ioValue, true) : (index + 1 < eBody.size() && eBody.get(index + 1) instanceof Block && !this.isSingleLineExpression((CSTNode)eBody.get(index + 1)) ? this.shiftEnd(ioValue, true) : 0));
            }
            if (shiftEnd > ioValue.length()) {
                oTextExpression.setEndPosition(oTextExpression.getEndPosition() - ioValue.length());
                ioValue = "";
            } else if (shiftEnd > 0) {
                oTextExpression.setEndPosition(oTextExpression.getEndPosition() - shiftEnd);
                ioValue = ioValue.substring(0, ioValue.length() - shiftEnd);
            }
        }
        oTextExpression.setStringSymbol(ioValue);
    }

    private int shiftBegin(String ioValue) {
        int shiftBegin = -1;
        int b = 0;
        while (shiftBegin == -1 && b < ioValue.length()) {
            char c = ioValue.charAt(b);
            if (c == '\n') {
                shiftBegin = b + 1;
            } else if (c == '\r' && (b == ioValue.length() - 1 || ioValue.charAt(b + 1) != '\n')) {
                shiftBegin = b + 1;
            } else if (!Character.isWhitespace(c)) {
                shiftBegin = 0;
            }
            ++b;
        }
        if (shiftBegin == -1) {
            shiftBegin = ioValue.length();
        }
        return shiftBegin;
    }

    private int shiftEnd(String ioValue, boolean keepPreviousReturn) {
        int shiftEnd = -1;
        int e = ioValue.length() - 1;
        while (shiftEnd == -1 && e >= 0) {
            char c = ioValue.charAt(e);
            if (c == '\n') {
                shiftEnd = keepPreviousReturn ? ioValue.length() - (e + 1) : (e > 0 && ioValue.charAt(e - 1) == '\r' ? ioValue.length() - (e - 1) : ioValue.length() - e);
            } else if (!Character.isWhitespace(c)) {
                shiftEnd = 0;
            }
            --e;
        }
        if (shiftEnd == -1) {
            shiftEnd = ioValue.length();
        }
        return shiftEnd;
    }

    private void transformStepCopy(Block iBlock) {
        org.eclipse.acceleo.model.mtl.Block oBlock = this.factory.getOrCreateBlock(iBlock);
        if (iBlock != null && oBlock != null) {
            this.transformStepCopyPositions(iBlock, (ASTNode)oBlock);
            InitSection iInit = iBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            this.transformStepCopyBody(iBlock, oBlock);
        }
    }

    private void transformStepCopy(InitSection iInitSection) {
        org.eclipse.acceleo.model.mtl.InitSection oInitSection = this.factory.getOrCreateInitSection(iInitSection);
        if (iInitSection != null && oInitSection != null) {
            this.transformStepCopyPositions(iInitSection, (ASTNode)oInitSection);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iInitSection.getVariable()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oInitSection.getVariable().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.ProtectedAreaBlock iProtectedAreaBlock) {
        ProtectedAreaBlock oProtectedAreaBlock = this.factory.getOrCreateProtectedAreaBlock(iProtectedAreaBlock);
        if (iProtectedAreaBlock != null && oProtectedAreaBlock != null) {
            this.transformStepCopyPositions(iProtectedAreaBlock, (ASTNode)oProtectedAreaBlock);
            InitSection iInit = iProtectedAreaBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oProtectedAreaBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iMarker = iProtectedAreaBlock.getMarker();
            this.transformStepCopy(iMarker);
            this.transformStepCopyBody(iProtectedAreaBlock, (org.eclipse.acceleo.model.mtl.Block)oProtectedAreaBlock);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.ForBlock iForBlock) {
        ForBlock oForBlock = this.factory.getOrCreateForBlock(iForBlock);
        if (iForBlock != null && oForBlock != null) {
            this.transformStepCopyPositions(iForBlock, (ASTNode)oForBlock);
            InitSection iInit = iForBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oForBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iIterSet = iForBlock.getIterSet();
            this.transformStepCopy(iIterSet);
            ModelExpression iBefore = iForBlock.getBefore();
            this.transformStepCopy(iBefore);
            ModelExpression iEach = iForBlock.getEach();
            this.transformStepCopy(iEach);
            ModelExpression iAfter = iForBlock.getAfter();
            this.transformStepCopy(iAfter);
            ModelExpression iGuard = iForBlock.getGuard();
            this.transformStepCopy(iGuard);
            this.transformStepCopyBody(iForBlock, (org.eclipse.acceleo.model.mtl.Block)oForBlock);
            org.eclipse.acceleo.parser.cst.Variable iLoopVariable = iForBlock.getLoopVariable();
            Variable oLoopVariable = this.factory.getOrCreateVariable(iLoopVariable);
            if (oLoopVariable != null) {
                oForBlock.setLoopVariable(oLoopVariable);
            }
            this.transformStepCopy(iLoopVariable);
        }
    }

    private void transformStepCopy(IfBlock iIfBlock) {
        org.eclipse.acceleo.model.mtl.IfBlock oIfBlock = this.factory.getOrCreateIfBlock(iIfBlock);
        if (iIfBlock != null && oIfBlock != null) {
            org.eclipse.acceleo.model.mtl.Template oElse;
            Block iElse = iIfBlock.getElse();
            if (iElse instanceof Template) {
                oElse = this.factory.getOrCreateTemplate((Template)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                oElse = this.factory.getOrCreateProtectedAreaBlock((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                oElse = this.factory.getOrCreateForBlock((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                oElse = this.factory.getOrCreateIfBlock((IfBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                oElse = this.factory.getOrCreateLetBlock((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                oElse = this.factory.getOrCreateFileBlock((FileBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                oElse = this.factory.getOrCreateTraceBlock((TraceBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                oElse = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                oElse = this.factory.getOrCreateBlock(iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy(iElse);
            }
            this.transformStepCopyPositions(iIfBlock, (ASTNode)oIfBlock);
            for (IfBlock iNext : iIfBlock.getElseIf()) {
                org.eclipse.acceleo.model.mtl.IfBlock oNext = this.factory.getOrCreateIfBlock(iNext);
                if (oNext != null) {
                    oIfBlock.getElseIf().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            InitSection iInit = iIfBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oIfBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iIfExpr = iIfBlock.getIfExpr();
            this.transformStepCopy(iIfExpr);
            this.transformStepCopyBody(iIfBlock, (org.eclipse.acceleo.model.mtl.Block)oIfBlock);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.LetBlock iLetBlock) {
        LetBlock oLetBlock = this.factory.getOrCreateLetBlock(iLetBlock);
        if (iLetBlock != null && oLetBlock != null) {
            org.eclipse.acceleo.model.mtl.Template oElse;
            Block iElse = iLetBlock.getElse();
            if (iElse instanceof Template) {
                oElse = this.factory.getOrCreateTemplate((Template)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                oElse = this.factory.getOrCreateProtectedAreaBlock((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                oElse = this.factory.getOrCreateForBlock((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                oElse = this.factory.getOrCreateIfBlock((IfBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                oElse = this.factory.getOrCreateLetBlock((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                oElse = this.factory.getOrCreateFileBlock((FileBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                oElse = this.factory.getOrCreateTraceBlock((TraceBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                oElse = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                oElse = this.factory.getOrCreateBlock(iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy(iElse);
            }
            this.transformStepCopyPositions(iLetBlock, (ASTNode)oLetBlock);
            InitSection iInit = iLetBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oLetBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            for (org.eclipse.acceleo.parser.cst.LetBlock iNext : iLetBlock.getElseLet()) {
                LetBlock oNext = this.factory.getOrCreateLetBlock(iNext);
                if (oNext != null) {
                    oLetBlock.getElseLet().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            org.eclipse.acceleo.parser.cst.Variable iLetVariable = iLetBlock.getLetVariable();
            Variable oLetVariable = this.factory.getOrCreateVariable(iLetVariable);
            if (oLetVariable != null) {
                oLetBlock.setLetVariable(oLetVariable);
            }
            this.transformStepCopy(iLetVariable);
            this.transformStepCopyBody(iLetBlock, (org.eclipse.acceleo.model.mtl.Block)oLetBlock);
        }
    }

    private void transformStepCopy(FileBlock iFileBlock) {
        org.eclipse.acceleo.model.mtl.FileBlock oFileBlock = this.factory.getOrCreateFileBlock(iFileBlock);
        if (iFileBlock != null && oFileBlock != null) {
            OpenModeKind iOpenMode = iFileBlock.getOpenMode();
            org.eclipse.acceleo.model.mtl.OpenModeKind oOpenMode = org.eclipse.acceleo.model.mtl.OpenModeKind.get((int)iOpenMode.getValue());
            oFileBlock.setOpenMode(oOpenMode);
            this.transformStepCopyPositions(iFileBlock, (ASTNode)oFileBlock);
            InitSection iInit = iFileBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oFileBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iFileUrl = iFileBlock.getFileUrl();
            this.transformStepCopy(iFileUrl);
            ModelExpression iFileCharset = iFileBlock.getCharset();
            this.transformStepCopy(iFileCharset);
            this.transformStepCopyBody(iFileBlock, (org.eclipse.acceleo.model.mtl.Block)oFileBlock);
        }
    }

    private void transformStepCopy(TraceBlock iTraceBlock) {
        org.eclipse.acceleo.model.mtl.TraceBlock oTraceBlock = this.factory.getOrCreateTraceBlock(iTraceBlock);
        if (iTraceBlock != null && oTraceBlock != null) {
            this.transformStepCopyPositions(iTraceBlock, (ASTNode)oTraceBlock);
            InitSection iInit = iTraceBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oTraceBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iModelElement = iTraceBlock.getModelElement();
            this.transformStepCopy(iModelElement);
            this.transformStepCopyBody(iTraceBlock, (org.eclipse.acceleo.model.mtl.Block)oTraceBlock);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Macro iMacro) {
        Macro oMacro = this.factory.getOrCreateMacro(iMacro);
        if (iMacro != null && oMacro != null) {
            InitSection iInit;
            org.eclipse.acceleo.model.mtl.InitSection oInit;
            org.eclipse.acceleo.parser.cst.VisibilityKind iVisibility = iMacro.getVisibility();
            VisibilityKind oVisibility = VisibilityKind.get((int)iVisibility.getValue());
            oMacro.setVisibility(oVisibility);
            this.transformStepCopyPositions(iMacro, (ASTNode)oMacro);
            String ioName = iMacro.getName();
            if (ioName != null && !"".equals(ioName)) {
                oMacro.setName(ioName);
            }
            if ((oInit = this.factory.getOrCreateInitSection(iInit = iMacro.getInit())) != null) {
                oMacro.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            this.transformStepCopyBody(iMacro, (org.eclipse.acceleo.model.mtl.Block)oMacro);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iMacro.getParameter()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oMacro.getParameter().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            String ioType = iMacro.getType();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("MTL");
            eAnnotation.getDetails().put((Object)"type", (Object)ioType);
            oMacro.getEAnnotations().add((Object)eAnnotation);
            if (oMacro.isDeprecated()) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.DeprecatedMacro", oMacro.getName()), oMacro.getStartPosition(), oMacro.getEndPosition());
            }
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Query iQuery) {
        Query oQuery = this.factory.getOrCreateQuery(iQuery);
        if (iQuery != null && oQuery != null) {
            org.eclipse.acceleo.parser.cst.VisibilityKind iVisibility = iQuery.getVisibility();
            VisibilityKind oVisibility = VisibilityKind.get((int)iVisibility.getValue());
            oQuery.setVisibility(oVisibility);
            this.transformStepCopyPositions(iQuery, (ASTNode)oQuery);
            String ioName = iQuery.getName();
            if (ioName != null && !"".equals(ioName)) {
                oQuery.setName(ioName);
            }
            ModelExpression iExpression = iQuery.getExpression();
            this.transformStepCopy(iExpression);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iQuery.getParameter()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oQuery.getParameter().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            String ioType = iQuery.getType();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("MTL");
            eAnnotation.getDetails().put((Object)"type", (Object)ioType);
            oQuery.getEAnnotations().add((Object)eAnnotation);
            if (oQuery.isDeprecated()) {
                this.logWarning(AcceleoParserMessages.getString("CST2ASTConverterWithResolver.DeprecatedQuery", oQuery.getName()), oQuery.getStartPosition(), oQuery.getEndPosition());
            }
        }
    }

    private void transformStepCopyOwnedModuleElement(org.eclipse.acceleo.parser.cst.Module iModule, Module oModule) {
        if (!this.isCanceled) {
            CompactHashSet allSignatures = new CompactHashSet();
            for (org.eclipse.acceleo.parser.cst.ModuleElement iNext : iModule.getOwnedModuleElement()) {
                String sign;
                boolean first;
                org.eclipse.acceleo.model.mtl.Template oNext;
                StringBuilder signature = new StringBuilder();
                signature.append(iNext.getName());
                if (iNext instanceof Template) {
                    oNext = this.factory.getOrCreateTemplate((Template)iNext);
                    if (oNext != null) {
                        this.computeDepreciation(oModule, (DocumentedElement)oNext);
                        oModule.getOwnedModuleElement().add((Object)oNext);
                    }
                    this.transformStepCopy((Template)iNext);
                    signature.append('(');
                    first = true;
                    for (org.eclipse.acceleo.parser.cst.Variable iVariable : ((Template)iNext).getParameter()) {
                        if (first) {
                            first = false;
                        } else {
                            signature.append(',');
                        }
                        signature.append(iVariable.getType());
                    }
                    signature.append(')');
                    if (((Template)iNext).getGuard() != null) {
                        signature.append(((Template)iNext).getGuard().getBody());
                    }
                } else if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    oNext = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    if (oNext != null) {
                        this.computeDepreciation(oModule, (DocumentedElement)oNext);
                        oModule.getOwnedModuleElement().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    signature.append('(');
                    first = true;
                    for (org.eclipse.acceleo.parser.cst.Variable iVariable : ((org.eclipse.acceleo.parser.cst.Macro)iNext).getParameter()) {
                        if (first) {
                            first = false;
                        } else {
                            signature.append(',');
                        }
                        signature.append(iVariable.getType());
                    }
                    signature.append(')');
                } else if (iNext instanceof org.eclipse.acceleo.parser.cst.Query) {
                    oNext = this.factory.getOrCreateQuery((org.eclipse.acceleo.parser.cst.Query)iNext);
                    if (oNext != null) {
                        this.computeDepreciation(oModule, (DocumentedElement)oNext);
                        oModule.getOwnedModuleElement().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.Query)iNext);
                    signature.append('(');
                    first = true;
                    for (org.eclipse.acceleo.parser.cst.Variable iVariable : ((org.eclipse.acceleo.parser.cst.Query)iNext).getParameter()) {
                        if (first) {
                            first = false;
                        } else {
                            signature.append(',');
                        }
                        signature.append(iVariable.getType());
                    }
                    signature.append(')');
                } else if (iNext instanceof org.eclipse.acceleo.parser.cst.Documentation) {
                    oNext = this.factory.getOrCreateDocumentation((org.eclipse.acceleo.parser.cst.Documentation)iNext);
                    if (oNext != null) {
                        oModule.getOwnedModuleElement().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.Documentation)iNext);
                } else if (iNext instanceof org.eclipse.acceleo.parser.cst.Comment) {
                    oNext = this.factory.getOrCreateComment((org.eclipse.acceleo.parser.cst.Comment)iNext);
                    if (oNext != null) {
                        oModule.getOwnedModuleElement().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.Comment)iNext);
                }
                if (allSignatures.contains(sign = signature.toString())) {
                    this.logProblem(AcceleoParserMessages.getString("CST2ASTConverter.SignatureConflict", sign), iNext.getStartPosition(), iNext.getEndPosition());
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Comment) continue;
                allSignatures.add(sign);
            }
        }
    }

    private void computeDepreciation(Module oModule, DocumentedElement oNext) {
        EList ownedModuleElement;
        boolean depreciated = false;
        depreciated = oModule.isDeprecated();
        if (!depreciated && (ownedModuleElement = oModule.getOwnedModuleElement()).size() > 0) {
            ModuleElement moduleElement = (ModuleElement)ownedModuleElement.get(ownedModuleElement.size() - 1);
            Documentation documentation = null;
            if (moduleElement instanceof Documentation) {
                documentation = (Documentation)moduleElement;
            }
            if (documentation != null && documentation.getBody() != null && documentation.getBody().getValue() != null) {
                depreciated = documentation.getBody().getValue().contains("@deprecated");
            }
        }
        oNext.setDeprecated(depreciated);
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Comment iComment) {
        Comment oComment = this.factory.getOrCreateComment(iComment);
        if (oComment != null && iComment != null) {
            oComment.setStartPosition(iComment.getStartPosition());
            oComment.setEndPosition(iComment.getEndPosition());
            oComment.setName(iComment.getName());
            CommentBody oCommentBody = MtlFactory.eINSTANCE.createCommentBody();
            oCommentBody.setValue(iComment.getBody());
            oCommentBody.setStartPosition(-1);
            oCommentBody.setEndPosition(-1);
            oComment.setBody(oCommentBody);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Documentation iDocumentation) {
        Documentation oDocumentation = this.factory.getOrCreateDocumentation(iDocumentation);
        if (oDocumentation != null && iDocumentation != null) {
            oDocumentation.setStartPosition(iDocumentation.getStartPosition());
            oDocumentation.setEndPosition(iDocumentation.getEndPosition());
            oDocumentation.setName(iDocumentation.getName());
            CommentBody oCommentBody = MtlFactory.eINSTANCE.createCommentBody();
            oCommentBody.setValue(iDocumentation.getBody());
            oCommentBody.setStartPosition(-1);
            oCommentBody.setEndPosition(-1);
            oDocumentation.setBody(oCommentBody);
        }
    }

    private void transformStepCopyBody(Block iBlock, org.eclipse.acceleo.model.mtl.Block oBlock) {
        if (!this.isCanceled) {
            for (TemplateExpression iNext : iBlock.getBody()) {
                org.eclipse.acceleo.model.mtl.Template oNext;
                if (iNext instanceof Template) {
                    oNext = this.factory.getOrCreateTemplate((Template)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((Template)iNext);
                    continue;
                }
                if (iNext instanceof TextExpression) {
                    oNext = this.factory.getOrCreateStringLiteralExp((TextExpression)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((TextExpression)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                    oNext = this.factory.getOrCreateProtectedAreaBlock((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                    oNext = this.factory.getOrCreateForBlock((org.eclipse.acceleo.parser.cst.ForBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.ForBlock)iNext);
                    continue;
                }
                if (iNext instanceof IfBlock) {
                    oNext = this.factory.getOrCreateIfBlock((IfBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((IfBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                    oNext = this.factory.getOrCreateLetBlock((org.eclipse.acceleo.parser.cst.LetBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.LetBlock)iNext);
                    continue;
                }
                if (iNext instanceof FileBlock) {
                    oNext = this.factory.getOrCreateFileBlock((FileBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((FileBlock)iNext);
                    continue;
                }
                if (iNext instanceof TraceBlock) {
                    oNext = this.factory.getOrCreateTraceBlock((TraceBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((TraceBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    oNext = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    continue;
                }
                if (iNext instanceof Block) {
                    oNext = this.factory.getOrCreateBlock((Block)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((Block)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Comment || (oNext = this.factory.getOrCreateTemporaryTemplateExpression(iNext)) == null) continue;
                oBlock.getBody().add((Object)oNext);
            }
        }
    }

    private void transformStepCopyPositions(CSTNode iNode, ASTNode oNode) {
        int ioStartPosition = iNode.getStartPosition();
        oNode.setStartPosition(ioStartPosition);
        int ioEndPosition = iNode.getEndPosition();
        oNode.setEndPosition(ioEndPosition);
        oNode.eAdapters().add((Object)new AcceleoASTNodeAdapter(this.astProvider.getLineOfOffset(ioStartPosition)));
    }

    public void canceling(boolean cancel) {
        this.isCanceled = cancel;
    }

    public void clear() {
        this.factory.clear();
    }
}

