/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import java.io.IOException;
import java.net.URL;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleURLConverter {
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_PROTOCOL = "jar:";
    private static final String PLATFORM_PLUGIN_PROTOCOL = "platform:/plugin";
    private final String baseURL;
    private Bundle bundle;
    private String bundlePath;
    private String nativeProtocolURL;

    public BundleURLConverter(String base) {
        this.baseURL = base;
    }

    private static boolean isBundleIDCandidate(String s) {
        if (s.length() == 0 || s.length() > 5) {
            return false;
        }
        boolean isInteger = true;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                isInteger = false;
            }
            ++n2;
        }
        return isInteger;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String resolveAsNativeProtocolURL() {
        if (this.nativeProtocolURL == null) {
            this.resolveBundle();
        }
        return this.nativeProtocolURL;
    }

    public String resolveAsPlatformPlugin() {
        Bundle containingBundle = this.resolveBundle();
        String relativePath = this.bundlePath;
        if (this.bundlePath == null || containingBundle == null) {
            return null;
        }
        return "platform:/plugin/" + containingBundle.getSymbolicName() + relativePath;
    }

    public Bundle resolveBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        String actualPath = this.baseURL;
        if (actualPath.startsWith(JAR_PROTOCOL)) {
            actualPath = (actualPath = actualPath.substring(JAR_PROTOCOL.length())).contains("_") ? actualPath.replaceFirst("/([^/]*?)_[^_]*\\.jar!/", "/$1/") : actualPath.replaceFirst("\\.jar!", "");
        }
        if (actualPath.startsWith("file:/")) {
            actualPath = actualPath.substring(FILE_PROTOCOL.length() + 1);
        }
        Bundle tempBundle = null;
        String tempPath = null;
        String[] segments = actualPath.split("/");
        int i = segments.length - 1;
        while (i >= 0 && this.bundle == null) {
            tempBundle = BundleURLConverter.isBundleIDCandidate(segments[i]) ? AcceleoCommonPlugin.getDefault().getContext().getBundle(Long.valueOf(segments[i]).longValue()) : Platform.getBundle((String)segments[i]);
            if (tempBundle != null) {
                tempPath = "";
                int pathStart = i + 1;
                if (!".cp".equals(segments[pathStart]) && segments.length > pathStart + 1 && ".cp".equals(segments[pathStart + 1])) {
                    pathStart += 2;
                }
                int j = ++pathStart;
                while (j < segments.length) {
                    tempPath = String.valueOf(tempPath) + '/' + segments[j];
                    ++j;
                }
                URL fileURL = tempBundle.getEntry(tempPath);
                if (fileURL != null) {
                    this.bundle = tempBundle;
                    this.bundlePath = tempPath;
                    try {
                        this.nativeProtocolURL = FileLocator.resolve((URL)fileURL).toString();
                    }
                    catch (IOException iOException) {}
                }
            }
            --i;
        }
        return this.bundle;
    }
}

