/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.compiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IncludeDependencies
implements Serializable {
    private static final long serialVersionUID = 3810681358080776836L;
    private static final String[] EMPTY_STRINGS_ARRAY = new String[0];
    private Map dependentPathToTemplates = new HashMap();
    private transient Map templatePathToDependencies = new HashMap();

    public void addDependencies(String templatePath, String[] dependencies) {
        HashSet<String> dependents = (HashSet<String>)this.templatePathToDependencies.get(templatePath);
        if (dependents == null) {
            dependents = new HashSet<String>(Arrays.asList(dependencies));
            this.templatePathToDependencies.put(templatePath, dependents);
        } else {
            dependents.addAll(Arrays.asList(dependencies));
        }
        int i = 0;
        while (i < dependencies.length) {
            String dependentPath = dependencies[i];
            HashSet<String> templates = (HashSet<String>)this.dependentPathToTemplates.get(dependentPath);
            if (templates == null) {
                templates = new HashSet<String>();
                this.dependentPathToTemplates.put(dependentPath, templates);
            }
            templates.add(templatePath);
            ++i;
        }
    }

    public void removeDependencies(String templatePath) {
        Set dependencies = (Set)this.templatePathToDependencies.remove(templatePath);
        if (dependencies != null) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                String dependentPath = (String)i.next();
                Set templates = (Set)this.dependentPathToTemplates.get(dependentPath);
                if (templates == null) continue;
                templates.remove(templatePath);
                if (templates.size() != 0) continue;
                this.dependentPathToTemplates.remove(dependentPath);
            }
        }
    }

    public String[] getAffectedTemplates(String dependency) {
        Set templates = (Set)this.dependentPathToTemplates.get(dependency);
        return templates == null ? EMPTY_STRINGS_ARRAY : templates.toArray(EMPTY_STRINGS_ARRAY);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.templatePathToDependencies = new HashMap();
        Iterator i = this.dependentPathToTemplates.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String dependentPath = (String)entry.getKey();
            Set templates = (Set)entry.getValue();
            Iterator j = templates.iterator();
            while (j.hasNext()) {
                String templatePath = (String)j.next();
                HashSet<String> dependents = (HashSet<String>)this.templatePathToDependencies.get(templatePath);
                if (dependents == null) {
                    dependents = new HashSet<String>();
                    this.templatePathToDependencies.put(templatePath, dependents);
                }
                dependents.add(dependentPath);
            }
        }
    }
}

