/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions;

import java.util.List;
import org.eclipse.jet.internal.xpath.functions.StringFunction;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;

public class NumberFunction
implements XPathFunction {
    public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("number", null, new NumberFunction(), 1, 1);

    public Object evaluate(List args) {
        if (args == null || args.size() != 1) {
            throw new IllegalArgumentException();
        }
        return new Double(NumberFunction.evaluate(args.get(0)));
    }

    public static double evaluate(Object obj) {
        double result = Double.NaN;
        if (obj instanceof Double) {
            result = (Double)obj;
        } else if (obj instanceof String) {
            String s = (String)obj;
            try {
                result = Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                result = Double.NaN;
            }
        } else if (obj instanceof Boolean) {
            result = (Boolean)obj != false ? 1 : 0;
        } else {
            String s = StringFunction.evaluate(obj);
            result = NumberFunction.evaluate(s);
        }
        return result;
    }
}

