/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.BodyElements;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.XMLBodyElementEnd;
import org.eclipse.jet.core.parser.ast.XMLElement;
import org.eclipse.jet.taglib.TagDefinition;

public final class XMLBodyElement
extends XMLElement {
    private BodyElements bodyElements = null;
    private XMLBodyElementEnd endTag = null;

    XMLBodyElement(JETAST ast, int line, int colOffset, int start, int end, String name, Map attributes, TagDefinition td) {
        super(ast, line, colOffset, start, end, name, attributes, td);
    }

    BodyElements getInternalBodyElements() {
        if (this.bodyElements == null) {
            this.bodyElements = new BodyElements(this);
        }
        return this.bodyElements;
    }

    public final List getBodyElements() {
        if (this.bodyElements == null) {
            return Collections.EMPTY_LIST;
        }
        return this.bodyElements.getBodyElements();
    }

    protected final void accept0(JETASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            Iterator i = this.getBodyElements().iterator();
            while (i.hasNext()) {
                JETASTElement element = (JETASTElement)i.next();
                element.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public void setEndTag(XMLBodyElementEnd endTag) {
        this.endTag = endTag;
    }

    public final XMLBodyElementEnd getEndTag() {
        return this.endTag;
    }

    public String toString() {
        return "Line " + this.getLine() + ": <" + this.getName() + ">";
    }

    public JETASTElement getNextElement() {
        if (this.getBodyElements().size() > 0) {
            return (JETASTElement)this.getBodyElements().get(0);
        }
        return super.getNextElement();
    }

    public void addBodyElement(BodyElement bodyElement) {
        this.getInternalBodyElements().addBodyElement(bodyElement);
    }

    public JETASTElement elementAfter(JETASTElement element) {
        return this.bodyElements.elementAfter(element);
    }

    public BodyElement elementBefore(JETASTElement element) {
        return this.bodyElements.elementBefore(element);
    }
}

