/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.text.MessageFormat;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.RuntimeTagElement;
import org.eclipse.jet.taglib.TagInfo;

public abstract class SafeCustomRuntimeTag
implements RuntimeTagElement {
    private RuntimeTagElement parentTag;
    private TagInfo tagInfo;
    private JET2Context context;
    private JET2Writer out;
    private final CustomTag untrustedTag;

    public SafeCustomRuntimeTag(CustomTag tag) {
        this.untrustedTag = tag;
    }

    public final void setRuntimeParent(RuntimeTagElement parentTag) {
        this.parentTag = parentTag;
        final CustomTag customParent = parentTag instanceof SafeCustomRuntimeTag ? ((SafeCustomRuntimeTag)parentTag).untrustedTag : null;
        SafeRunner.run((ISafeRunnable)new TagSafeRunnable(){

            public void doRun() throws Exception {
                SafeCustomRuntimeTag.this.untrustedTag.setParent(customParent);
            }
        });
    }

    public final RuntimeTagElement getParent() {
        return this.parentTag;
    }

    public final void setTagInfo(TagInfo tagInfo) {
        this.tagInfo = tagInfo;
    }

    public final TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public void doStart(JET2Context startContext, JET2Writer startOut) {
        this.context = startContext;
        this.out = startOut;
        this.untrustedTag.setTagInfo(this.tagInfo);
        this.untrustedTag.setContext(this.context);
        this.untrustedTag.setOut(this.out);
    }

    public void doEnd() {
    }

    public final JET2Context getContext() {
        return this.context;
    }

    public final JET2Writer getWriter() {
        return this.out;
    }

    protected final CustomTag getUntrustedTag() {
        return this.untrustedTag;
    }

    protected abstract class TagSafeRunnable
    implements ISafeRunnable {
        protected TagSafeRunnable() {
        }

        public void handleException(Throwable exception) {
            if (exception instanceof OperationCanceledException) {
                throw (OperationCanceledException)exception;
            }
            if (exception instanceof RuntimeException && !(exception instanceof JET2TagException)) {
                String msg = MessageFormat.format(JET2Messages.SafeCustomRuntimeTag_ErrorExecutingHandler, exception.toString());
                SafeCustomRuntimeTag.this.context.logError(SafeCustomRuntimeTag.this.tagInfo, msg, exception);
                if (Platform.inDevelopmentMode()) {
                    exception.printStackTrace();
                }
            } else {
                SafeCustomRuntimeTag.this.context.logError(SafeCustomRuntimeTag.this.tagInfo, null, exception);
            }
        }

        public final void run() throws Exception {
            try {
                this.doRun();
            }
            catch (JET2TagException e) {
                this.handleException(e);
            }
        }

        protected abstract void doRun() throws Exception;
    }
}

