/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.examples.internal.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.acceleo.examples.internal.AcceleoExamplesMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExampleWizard
extends Wizard
implements INewWizard {
    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        final Collection<ProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor m) throws CoreException, InvocationTargetException, InterruptedException {
                            m.beginTask(AcceleoExamplesMessages.getString("AbstractExampleWizard.Task.Unzip"), projectDescriptors.size());
                            for (ProjectDescriptor project : projectDescriptors) {
                                AbstractExampleWizard.this.unzipProject(project, m);
                                m.worked(1);
                            }
                        }
                    };
                    op.run(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            this.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected abstract Collection<ProjectDescriptor> getProjectDescriptors();

    protected abstract void log(Exception var1);

    protected void unzipProject(ProjectDescriptor descriptor, IProgressMonitor monitor) {
        String bundleName = descriptor.getBundleName();
        String zipLocation = descriptor.getZipLocation();
        String projectName = descriptor.getProjectName();
        URL interpreterZipUrl = FileLocator.find((Bundle)Platform.getBundle((String)bundleName), (IPath)new Path(zipLocation), null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            return;
        }
        try {
            project.create(monitor);
            ZipInputStream zipFileStream = new ZipInputStream(interpreterZipUrl.openStream());
            ZipEntry zipEntry = zipFileStream.getNextEntry();
            String regexedProjectName = projectName.replaceAll("\\.", "\\.");
            while (zipEntry != null) {
                File file = new File(project.getLocation().toString(), zipEntry.getName().replaceFirst("^" + regexedProjectName + "/", ""));
                if (!zipEntry.isDirectory()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(file);
                        byte[] buffer = new byte[102400];
                        while (true) {
                            int len = zipFileStream.read(buffer);
                            if (zipFileStream.available() == 0) {
                                break;
                            }
                            ((OutputStream)os).write(buffer, 0, len);
                        }
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
                zipFileStream.closeEntry();
                zipEntry = zipFileStream.getNextEntry();
            }
            project.open(monitor);
            project.refreshLocal(2, monitor);
            project.close(monitor);
            project.open(monitor);
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (CoreException e) {
            this.log((Exception)((Object)e));
        }
    }

    public static class ProjectDescriptor {
        private final String bundleName;
        private final String projectName;
        private final String zipLocation;

        public ProjectDescriptor(String bundleName, String zipLocation, String projectName) {
            this.bundleName = bundleName;
            this.zipLocation = zipLocation;
            this.projectName = projectName;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getZipLocation() {
            return this.zipLocation;
        }
    }
}

