/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.TemplateInputException;
import org.eclipse.jet.internal.core.url.URLUtility;

public class DefaultTemplateInput
implements ITemplateInput {
    private final URI baseLocation;
    private final String templatePath;
    private final String encoding;

    public DefaultTemplateInput(URI baseLocation, String templatePath, String encoding) {
        this.baseLocation = baseLocation;
        this.templatePath = templatePath;
        this.encoding = encoding;
    }

    public URI getBaseLocation() {
        return this.baseLocation;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public Reader getReader() throws TemplateInputException {
        try {
            URI templateURI = new URI(null, this.templatePath, null);
            URI resolvedURI = this.baseLocation.resolve(templateURI);
            URL url = URLUtility.toURL(resolvedURI);
            InputStream urlStream = url.openStream();
            return new BufferedReader(new InputStreamReader(urlStream, this.getEncoding()));
        }
        catch (IOException e) {
            throw new TemplateInputException(e);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException wrapper = new IllegalArgumentException();
            wrapper.initCause(e);
            throw wrapper;
        }
    }

    public String getEncoding() throws TemplateInputException {
        return this.encoding;
    }
}

