/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.configuration.delegates.java;

import java.util.ArrayList;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.configuration.delegates.IJETDefaultTextColorerDelegate;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaContentPartitionConfigurationDelegate
implements IJETDefaultTextColorerDelegate {
    private JETJavaSourceViewerConfiguration javaConfiguration;

    public JavaContentPartitionConfigurationDelegate(JETTextEditor editor) {
        this.javaConfiguration = new JETJavaSourceViewerConfiguration(editor);
    }

    public String getName() {
        return "Java Text Content Colorer";
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
    }

    public IPredicateRule[] getPartitioningRules() {
        Token string = new Token((Object)"__java_string");
        Token character = new Token((Object)"__java_character");
        Token javaDoc = new Token((Object)"__java_javadoc");
        Token multiLineComment = new Token((Object)"__java_multiline_comment");
        Token singleLineComment = new Token((Object)"__java_singleline_comment");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)singleLineComment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)character, '\\'));
        EmptyCommentRule wordRule = new EmptyCommentRule((IToken)multiLineComment);
        rules.add((Object)wordRule);
        rules.add(new MultiLineRule("/**", "*/", (IToken)javaDoc));
        rules.add(new MultiLineRule("/*", "*/", (IToken)multiLineComment));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        return result;
    }

    public ITokenScanner getTokenScanner(String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return this.javaConfiguration.getCodeScanner();
        }
        if ("__java_javadoc".equals(contentType)) {
            return this.javaConfiguration.getJavaDocScanner();
        }
        if ("__java_multiline_comment".equals(contentType)) {
            return this.javaConfiguration.getMultilineCommentScanner();
        }
        if ("__java_singleline_comment".equals(contentType)) {
            return this.javaConfiguration.getSinglelineCommentScanner();
        }
        if ("__java_string".equals(contentType)) {
            return this.javaConfiguration.getStringScanner();
        }
        if ("__java_character".equals(contentType)) {
            return this.javaConfiguration.getStringScanner();
        }
        return this.javaConfiguration.getCodeScanner();
    }

    private class EmptyCommentDetector
    implements IWordDetector {
        private EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    private class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }
    }

    private class JETJavaSourceViewerConfiguration
    extends JavaSourceViewerConfiguration {
        public RuleBasedScanner getCodeScanner() {
            return super.getCodeScanner();
        }

        public RuleBasedScanner getMultilineCommentScanner() {
            return super.getMultilineCommentScanner();
        }

        public RuleBasedScanner getSinglelineCommentScanner() {
            return super.getSinglelineCommentScanner();
        }

        public RuleBasedScanner getStringScanner() {
            return super.getStringScanner();
        }

        public RuleBasedScanner getJavaDocScanner() {
            return super.getJavaDocScanner();
        }

        public JETJavaSourceViewerConfiguration(JETTextEditor editor) {
            super(JavaUI.getColorManager(), editor.getEditorPreferenceStore(), (ITextEditor)editor, null);
        }
    }
}

