/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.internal.ui.l10n.Messages;
import org.eclipse.jet.internal.ui.launch.LaunchShortcut;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.ui.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JETTransformMainTab
extends AbstractLaunchConfigurationTab {
    private static final String EMPTY_STRING = "";
    private Text sourceField;
    private Button workspaceLocationButton;
    private final Listener fListener = new Listener();
    private Image tabImage;
    private Combo transformCombo;
    private Text transformName;
    private Text transformDescription;
    private Combo logLevelCombo;
    private String[] logLevels;
    static /* synthetic */ Class class$0;

    private void handleTransformSelection() {
        String id = this.transformCombo.getText();
        IJETBundleDescriptor descriptor = JET2Platform.getJETBundleManager().getDescriptor(id);
        this.transformName.setText(descriptor.getName());
        this.transformDescription.setText(descriptor.getDescription().trim());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createInputBlock(composite);
        this.createTransformBlock(composite);
        this.createMessagesBlock(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createMessagesBlock(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.JETTransformMainTab_DisplayMessage_Gropu);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.createLogLevelsSection(group);
    }

    private void createLogLevelsSection(Group parent) {
        Label label = new Label((Composite)parent, 0);
        label.setText(Messages.JETTransformMainTab_SeverityLabel);
        this.logLevelCombo = new Combo((Composite)parent, 12);
        this.logLevelCombo.setLayoutData((Object)new GridData(768));
        this.logLevelCombo.setItems(this.getLogLevels());
        this.logLevelCombo.addSelectionListener((SelectionListener)this.fListener);
    }

    private void createTransformBlock(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.JETTransformMainTab_TransformGroupLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.createTransformIdSection(group);
        this.createTransformNameSection(group);
        this.createTransformDescriptionSection(group);
    }

    private void createTransformDescriptionSection(Group parent) {
        Label label = new Label((Composite)parent, 0);
        label.setText(Messages.JETTransformMainTab_DescriptionLabel);
        this.transformDescription = new Text((Composite)parent, 2058);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 40;
        this.transformDescription.setLayoutData((Object)gd);
    }

    private void createTransformNameSection(Group parent) {
        Label label = new Label((Composite)parent, 0);
        label.setText(Messages.JETTransformMainTab_NameLabel);
        this.transformName = new Text((Composite)parent, 2056);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.transformName.setLayoutData((Object)gd);
    }

    private void createTransformIdSection(Group parent) {
        Label label = new Label((Composite)parent, 0);
        label.setText(Messages.JETTransformMainTab_IdLabel);
        this.transformCombo = new Combo((Composite)parent, 12);
        this.transformCombo.setLayoutData((Object)new GridData(768));
        this.transformCombo.setItems(JET2Platform.getJETBundleManager().getAllTransformIds());
        this.transformCombo.addSelectionListener((SelectionListener)this.fListener);
    }

    private void createInputBlock(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.JETTransformMainTab_TransformInputGroup);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.sourceField = new Text((Composite)group, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.sourceField.setLayoutData((Object)gridData);
        this.sourceField.addModifyListener((ModifyListener)this.fListener);
        final String accessibleName = group.getText().replaceFirst("(?<!&)&", EMPTY_STRING);
        this.sourceField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = accessibleName;
            }
        });
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceLocationButton = this.createPushButton(buttonComposite, Messages.JETTransformMainTab_BrowseButtonLabel, null);
        this.workspaceLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource = JETTransformMainTab.chooseResource(JETTransformMainTab.this.getShell());
                if (resource != null) {
                    JETTransformMainTab.this.sourceField.setText(resource.getFullPath().makeRelative().toString());
                }
            }
        });
    }

    private static IResource chooseResource(Shell shell) {
        IResource resource = null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.JETTransformMainTab_SelectResourceDialogTitle);
        dialog.setMessage(Messages.JETTransformMainTab_SelectResourceDialogTitle);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0) {
                    return new Status(0, Activator.getDefault().getBundle().getSymbolicName(), 0, JETTransformMainTab.EMPTY_STRING, null);
                }
                return new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 4, JETTransformMainTab.EMPTY_STRING, null);
            }
        });
        if (dialog.open() == 0) {
            resource = (IResource)dialog.getFirstResult();
        }
        return resource;
    }

    public String getName() {
        return Messages.LaunchWizard_MainTab_Name;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        int level;
        try {
            String id = configuration.getAttribute("org.eclipse.jet.id", EMPTY_STRING);
            this.transformCombo.setText(id);
            IJETBundleDescriptor descriptor = JET2Platform.getJETBundleManager().getDescriptor(id);
            if (descriptor != null) {
                this.transformName.setText(descriptor.getName());
                this.transformDescription.setText(descriptor.getDescription().trim());
            }
        }
        catch (CoreException coreException) {
            this.transformCombo.setText(EMPTY_STRING);
        }
        try {
            this.sourceField.setText(configuration.getAttribute("org.eclipse.jet.source", EMPTY_STRING));
        }
        catch (CoreException coreException) {
            this.sourceField.setText(EMPTY_STRING);
        }
        try {
            level = configuration.getAttribute("org.eclipse.jet.logFilterLevel", 3);
        }
        catch (CoreException coreException) {
            level = 3;
        }
        this.logLevelCombo.setText(this.getLogLevelText(level));
    }

    private String[] getLogLevels() {
        if (this.logLevels == null) {
            this.logLevels = new String[]{Messages.JETTransformMainTab_ErrorSeverity, Messages.JETTransformMainTab_WarningSeverity, Messages.JETTransformMainTab_InformationSeverity, Messages.JETTransformMainTab_TraceSeverity, Messages.JETTransformMainTab_DebugSeverity};
        }
        return this.logLevels;
    }

    private int getLogLevelFromIndex(int selectionIndex) {
        return this.getLogLevels().length - selectionIndex;
    }

    private String getLogLevelText(int logLevel) {
        return this.getLogLevels()[this.getLogLevels().length - logLevel];
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.jet.id", this.transformCombo.getText());
        configuration.setAttribute("org.eclipse.jet.source", this.sourceField.getText());
        configuration.setAttribute("org.eclipse.jet.logFilterLevel", this.getLogLevelFromIndex(this.logLevelCombo.getSelectionIndex()));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        IFile resource = null;
        String id = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object firstElement = iss.getFirstElement();
            if (firstElement instanceof IFile) {
                resource = (IFile)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)firstElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IFile)iAdaptable.getAdapter((Class)clazz);
            }
        }
        if (resource != null) {
            configuration.setAttribute("org.eclipse.jet.source", resource.getFullPath().makeRelative().toString());
            IProject project = resource.getProject();
            IJETBundleDescriptor descriptor = JET2Platform.getProjectDescription((String)project.getName());
            if (descriptor != null) {
                id = descriptor.getId();
                configuration.setAttribute("org.eclipse.jet.id", id);
            }
        }
        configuration.setAttribute("org.eclipse.jet.logFilterLevel", 3);
        configuration.rename(LaunchShortcut.generateLaunchName(id, resource));
    }

    public Image getImage() {
        if (this.tabImage == null) {
            ImageDescriptor imageDescriptor = Activator.getImageDescriptor("icons/JET2LaunchIcon.gif");
            this.tabImage = imageDescriptor.createImage();
        }
        return this.tabImage;
    }

    public void dispose() {
        if (this.tabImage != null) {
            this.tabImage.dispose();
        }
        super.dispose();
    }

    private class Listener
    extends SelectionAdapter
    implements ModifyListener {
        private Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            JETTransformMainTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == JETTransformMainTab.this.transformCombo) {
                JETTransformMainTab.this.handleTransformSelection();
            }
            JETTransformMainTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent e) {
            JETTransformMainTab.this.setDirty(true);
            JETTransformMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

