/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.taglib.ExtensionTagLibraryImpl;
import org.eclipse.jet.internal.taglib.TagAttributeDefinitionImpl;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.CustomTagKind;
import org.eclipse.jet.taglib.TagAttributeDefinition;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibrary;

public final class TagDefinitionImpl
implements TagDefinition {
    private static final String CLASS__ATTR = "class";
    private static final String USE__ATTR = "use";
    private static final String USE__VALUE__REQUIRED = "required";
    private static final String NAME__ATTR = "name";
    private static final String ATTRIBUTE__ELEMENT = "attribute";
    private static final String ALLOW_AS_EMPTY__ATTR = "allowAsEmpty";
    private static final String CONTENT_PROCESSING__VALUE__CUSTOM = "custom";
    private static final String CONTENT_PROCESSING__ATTR = "processContents";
    private static final String DEPRECATED__ATTR = "deprecated";
    private static final String TYPE__ATTR = "type";
    private static final String WHEN_CONTAINING_LINE_IS_EMPTY__ATTR = "whenContainingLineIsEmpty";
    private static final String REMOVE = "remove";
    private final String name;
    private final CustomTagKind kind;
    private final IConfigurationElement configElement;
    private final Map attributeDefinitions;
    private final boolean deprecated;
    private final boolean customContentProcessing;
    private final boolean allowAsEmpty;
    private final TagLibrary tagLibrary;
    private final String description;
    private final boolean removeWhenContainingLineIsEmpty;

    public TagDefinitionImpl(TagLibrary tagLibrary, String tagName, CustomTagKind kind, String description, boolean customContentProcessing, boolean allowAsEmpty, boolean deprecated, boolean removeWhenContainingLineIsEmpty) {
        this.tagLibrary = tagLibrary;
        this.name = tagName;
        this.kind = kind;
        this.description = description;
        this.customContentProcessing = customContentProcessing;
        this.allowAsEmpty = allowAsEmpty;
        this.deprecated = deprecated;
        this.removeWhenContainingLineIsEmpty = removeWhenContainingLineIsEmpty;
        this.attributeDefinitions = new HashMap();
        this.configElement = null;
    }

    public TagDefinitionImpl(String tagName, IConfigurationElement configElement, CustomTagKind kind, TagLibrary tagLibrary) {
        this.configElement = configElement;
        this.kind = kind;
        this.name = tagName;
        this.tagLibrary = tagLibrary;
        this.deprecated = Boolean.valueOf(configElement.getAttribute(DEPRECATED__ATTR));
        this.customContentProcessing = CONTENT_PROCESSING__VALUE__CUSTOM.equals(configElement.getAttribute(CONTENT_PROCESSING__ATTR));
        this.allowAsEmpty = Boolean.valueOf(configElement.getAttribute(ALLOW_AS_EMPTY__ATTR));
        String removeWhenEmpty = configElement.getAttribute(WHEN_CONTAINING_LINE_IS_EMPTY__ATTR);
        this.removeWhenContainingLineIsEmpty = removeWhenEmpty == null ? kind != CustomTagKind.EMPTY && kind != CustomTagKind.FUNCTION : REMOVE.equals(removeWhenEmpty);
        this.description = ExtensionTagLibraryImpl.getDescription(configElement);
        IConfigurationElement[] children = configElement.getChildren(ATTRIBUTE__ELEMENT);
        this.attributeDefinitions = new HashMap(children.length);
        int i = 0;
        while (i < children.length) {
            TagAttributeDefinitionImpl tad = new TagAttributeDefinitionImpl(children[i].getAttribute(NAME__ATTR), USE__VALUE__REQUIRED.equalsIgnoreCase(children[i].getAttribute(USE__ATTR)), Boolean.valueOf(children[i].getAttribute(DEPRECATED__ATTR)), ExtensionTagLibraryImpl.getDescription(children[i]), children[i].getAttribute(TYPE__ATTR));
            if (tad.getName() != null) {
                this.addTagAttribute(tad);
            } else {
                String msg = JET2Messages.TagDefinitionImpl_MissingName;
                InternalJET2Platform.logError(MessageFormat.format(msg, children[i].getDeclaringExtension().getExtensionPointUniqueIdentifier(), children[i].getDeclaringExtension().getNamespace()));
            }
            ++i;
        }
    }

    public void addTagAttribute(TagAttributeDefinition tagAttributeDefinition) {
        this.attributeDefinitions.put(tagAttributeDefinition.getName(), tagAttributeDefinition);
    }

    public final String getName() {
        return this.name;
    }

    public CustomTagKind getKind() {
        return this.kind;
    }

    public CustomTag newTagElement() throws CoreException {
        return this.configElement != null ? (CustomTag)this.configElement.createExecutableExtension(CLASS__ATTR) : null;
    }

    public TagAttributeDefinition getAttributeDefinition(String attrName) {
        return (TagAttributeDefinition)this.attributeDefinitions.get(attrName);
    }

    public List getAttributeDefinitions() {
        ArrayList list = new ArrayList(this.attributeDefinitions.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                TagAttributeDefinition ad1 = (TagAttributeDefinition)o1;
                TagAttributeDefinition ad2 = (TagAttributeDefinition)o2;
                return ad1.getName().compareTo(ad2.getName());
            }
        });
        return list;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean requiresNewWriter() {
        boolean required = false;
        if (this.kind == CustomTagKind.FUNCTION) {
            required = true;
        } else if (this.customContentProcessing && (this.kind == CustomTagKind.CONTAINER || this.kind == CustomTagKind.CONDITIONAL || this.kind == CustomTagKind.ITERATING)) {
            required = true;
        }
        return required;
    }

    public boolean isEmptyTagAllowed() {
        boolean allowed = false;
        if (this.kind == CustomTagKind.EMPTY) {
            allowed = true;
        } else if (this.allowAsEmpty && (this.kind == CustomTagKind.CONTAINER || this.kind == CustomTagKind.CONDITIONAL || this.kind == CustomTagKind.ITERATING)) {
            allowed = true;
        }
        return allowed;
    }

    public boolean isContentAllowed() {
        boolean allowed = false;
        if (this.kind == CustomTagKind.FUNCTION || this.kind == CustomTagKind.CONTAINER || this.kind == CustomTagKind.CONDITIONAL || this.kind == CustomTagKind.ITERATING || this.kind == CustomTagKind.OTHER) {
            allowed = true;
        }
        return allowed;
    }

    public TagLibrary getTagLibrary() {
        return this.tagLibrary;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean removeWhenContainingLineIsEmpty() {
        return this.removeWhenContainingLineIsEmpty;
    }
}

