/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;

public class WsProjectAction
extends AbstractWorkspaceAction
implements IWorkspaceAction {
    private final IProject project;
    private final JET2Context context;
    private final IProjectDescription description;

    public WsProjectAction(JET2Context context, String templatePath, TagInfo tagInfo, IProject project, IProjectDescription description) {
        super(tagInfo, templatePath);
        this.context = context;
        this.project = project;
        this.description = description;
    }

    public IResource getResource() {
        return this.project;
    }

    public boolean requiresValidateEdit() {
        return false;
    }

    public void performAction(IProgressMonitor monitor) throws JET2TagException {
        ActionsUtil.createProject(this.project, this.description, monitor);
        String createMessage = MessageFormat.format(JET2Messages.WsProjectAction_CreatingProject, this.project.getName());
        RuntimeLoggerContextExtender.log(this.context, createMessage, this.getTagInfo(), this.getTemplatePath(), 3);
    }
}

