/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class JET2ProjectNature
implements IProjectNature {
    private static final String JAVA_BUILDER_ID = "org.eclipse.jdt.core.javabuilder";
    private static final String JET_BUILDER_ID = "org.eclipse.jet.builder";
    private static final String EMF_JET_BUILDER_ID = "org.eclipse.emf.codegen.JETBuilder";
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] buildSpec = description.getBuildSpec();
        ArrayList<ICommand> buildSpecList = new ArrayList<ICommand>(Arrays.asList(buildSpec));
        ICommand jetCommand = description.newCommand();
        jetCommand.setBuilderName(JET_BUILDER_ID);
        boolean jetCommandAdded = false;
        ListIterator<ICommand> i = buildSpecList.listIterator();
        while (i.hasNext()) {
            ICommand command = (ICommand)i.next();
            if (EMF_JET_BUILDER_ID.equals(command.getBuilderName())) {
                i.remove();
                continue;
            }
            if (!JAVA_BUILDER_ID.equals(command.getBuilderName())) continue;
            i.previous();
            i.add(jetCommand);
            i.next();
            jetCommandAdded = true;
        }
        if (!jetCommandAdded) {
            buildSpecList.add(jetCommand);
        }
        description.setBuildSpec(buildSpecList.toArray(new ICommand[buildSpecList.size()]));
        this.project.setDescription(description, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] buildSpec = description.getBuildSpec();
        ICommand[] newBuildSpec = new ICommand[Math.max(0, buildSpec.length)];
        int j = 0;
        int i = 0;
        while (i < buildSpec.length) {
            if (!JET_BUILDER_ID.equals(buildSpec[i])) {
                newBuildSpec[j++] = buildSpec[i];
            }
            ++i;
        }
        description.setBuildSpec(newBuildSpec);
        this.project.setDescription(description, null);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

