/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.Analyzable;
import org.eclipse.xtend.expression.Evaluatable;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
extends SyntaxElement
implements Analyzable,
Evaluatable {
    protected Type findType(Identifier type, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type toCast = ctx.getTypeForName(type.getValue());
        if (toCast == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, type.getValue(), type));
        }
        return toCast;
    }

    /*
     * Loose catch block
     */
    @Override
    public final Object evaluate(ExecutionContext ctx) {
        Object object;
        Object evaluateInternal;
        block13: {
            evaluateInternal = null;
            ProgressMonitor monitor = ctx.getMonitor();
            if (monitor == null || !monitor.isCanceled()) break block13;
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(evaluateInternal);
            }
            return null;
        }
        try {
            if (ctx.getCallback() != null) {
                ctx.getCallback().pre(this, ctx);
            }
            object = evaluateInternal = this.evaluateInternal(ctx);
        }
        catch (EvaluationException ex) {
            ctx.handleRuntimeException(ex, this, null);
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(evaluateInternal);
            }
            return null;
        }
        catch (RuntimeException ex2) {
            EvaluationException evalex = new EvaluationException(ex2.getMessage(), (SyntaxElement)this, ctx);
            ctx.handleRuntimeException(evalex, this, null);
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(evaluateInternal);
            }
            return null;
            {
                catch (Throwable throwable) {
                    if (ctx.getCallback() != null) {
                        ctx.getCallback().post(evaluateInternal);
                    }
                    throw throwable;
                }
            }
        }
        if (ctx.getCallback() != null) {
            ctx.getCallback().post(evaluateInternal);
        }
        return object;
    }

    @Override
    public Type analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type val = null;
        try {
            if (ctx.getCallback() != null) {
                ctx.getCallback().pre(this, ctx);
            }
            Type type = val = this.analyzeInternal(ctx, issues);
            return type;
        }
        catch (RuntimeException ex) {
            issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, ex.getMessage(), this));
            return null;
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(val);
            }
        }
    }

    protected abstract Type analyzeInternal(ExecutionContext var1, Set<AnalysationIssue> var2);

    public final String toString() {
        return this.toStringInternal();
    }

    protected abstract String toStringInternal();

    protected abstract Object evaluateInternal(ExecutionContext var1);
}

