/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.internal.core.compiler.DuplicateGeneratedClassException;

public class UniqueNameGenerator {
    private final Map pathToFQJavaClassMap;
    private final String defaultJavaPackage;
    private final Map fqJavaClassToPathMap;

    public UniqueNameGenerator(Map pathToFQJavaClassMap, Map fqJavaClassToPathMap, String defaultJavaPackage) {
        this.pathToFQJavaClassMap = new HashMap(pathToFQJavaClassMap);
        this.fqJavaClassToPathMap = new HashMap(fqJavaClassToPathMap);
        this.defaultJavaPackage = defaultJavaPackage;
    }

    public void ensureJavaOutputSet(String templatePath, JETCompilationUnit cu) throws DuplicateGeneratedClassException {
        String fqn;
        String existingQualifiedClass = (String)this.pathToFQJavaClassMap.get(templatePath);
        if (existingQualifiedClass == null) {
            if (cu.getOutputJavaPackage() == null) {
                cu.setOutputJavaPackage(this.defaultJavaPackage);
            }
            if (cu.getOutputJavaClassName() == null) {
                String baseClassName;
                String className = baseClassName = this.makeJavaClassName(this.templateBaseName(templatePath));
                String potentialQualifiedName = this.makeFullyQualifiedJavaName(cu.getOutputJavaPackage(), className);
                int i = 0;
                while (this.fqJavaClassToPathMap.get(potentialQualifiedName) != null) {
                    className = String.valueOf(baseClassName) + "_" + i;
                    potentialQualifiedName = this.makeFullyQualifiedJavaName(cu.getOutputJavaPackage(), className);
                    ++i;
                }
                cu.setOutputJavaClassName(className);
                fqn = this.makeFullyQualifiedJavaName(cu.getOutputJavaPackage(), cu.getOutputJavaClassName());
            } else {
                fqn = this.makeFullyQualifiedJavaName(cu.getOutputJavaPackage(), cu.getOutputJavaClassName());
                String otherTemplatePath = (String)this.fqJavaClassToPathMap.get(fqn);
                if (otherTemplatePath != null) {
                    throw new DuplicateGeneratedClassException(templatePath, otherTemplatePath, fqn);
                }
            }
        } else {
            String existingClass;
            fqn = existingQualifiedClass;
            int index = existingQualifiedClass.lastIndexOf(46);
            String existingPackage = index == -1 ? "" : existingQualifiedClass.substring(0, index);
            String string = existingClass = index == -1 ? existingQualifiedClass : existingQualifiedClass.substring(index + 1);
            if (cu.getOutputJavaPackage() == null) {
                cu.setOutputJavaPackage(existingPackage);
            }
            if (cu.getOutputJavaClassName() == null) {
                cu.setOutputJavaClassName(existingClass);
            }
        }
        this.fqJavaClassToPathMap.put(fqn, templatePath);
        this.pathToFQJavaClassMap.put(templatePath, fqn);
    }

    private String templateBaseName(String templatePath) {
        int lastSlash = templatePath.lastIndexOf(47);
        String baseFile = lastSlash == -1 ? templatePath : templatePath.substring(lastSlash + 1);
        int lastDot = baseFile.lastIndexOf(46);
        return lastDot == -1 ? baseFile : baseFile.substring(0, lastDot);
    }

    private String makeJavaClassName(String name) {
        StringBuffer result = new StringBuffer("_jet_");
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private String makeFullyQualifiedJavaName(String javaPackage, String javaClassName) {
        return javaPackage == null || javaPackage.trim().length() == 0 ? javaClassName : String.valueOf(javaPackage) + '.' + javaClassName;
    }

    public Map getPathToFQNMap() {
        return new HashMap(this.pathToFQJavaClassMap);
    }

    public Map getFQNToPathMap() {
        return new HashMap(this.fqJavaClassToPathMap);
    }

    public String getGeneratedOutputPath(String templatePath) {
        String fqn = (String)this.pathToFQJavaClassMap.get(templatePath);
        return fqn == null ? null : String.valueOf(fqn.replace('.', '/')) + ".java";
    }

    public List clean() {
        ArrayList removedFQJavaClasses = new ArrayList(this.fqJavaClassToPathMap.keySet());
        this.fqJavaClassToPathMap.clear();
        this.pathToFQJavaClassMap.clear();
        return removedFQJavaClasses;
    }

    public String remove(String templatePath) {
        String outputPath = this.getGeneratedOutputPath(templatePath);
        if (outputPath != null) {
            String fqName = (String)this.pathToFQJavaClassMap.remove(templatePath);
            this.fqJavaClassToPathMap.remove(fqName);
        }
        return outputPath;
    }
}

