/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction2;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction2;
import org.eclipse.jet.taglib.workspace.IWorkspaceActionExtension;

public class WsFileFromWriterAction
extends AbstractWorkspaceAction2
implements IWorkspaceAction2,
IWorkspaceActionExtension {
    private final IFile file;
    private final BufferedJET2Writer writer;
    private String encoding;
    private final boolean replace;
    private final boolean derived;

    public WsFileFromWriterAction(String templatePath, TagInfo tagInfo, IFile file, BufferedJET2Writer writer, boolean replace, boolean derived) {
        super(tagInfo, templatePath);
        this.file = file;
        this.writer = writer;
        this.replace = replace;
        this.derived = derived;
    }

    public IResource getResource() {
        return this.file;
    }

    public boolean requiresValidateEdit() {
        return this.replace && this.file.exists() && this.file.isReadOnly();
    }

    public boolean performActionIfRequired(IProgressMonitor monitor) throws JET2TagException {
        return ActionsUtil.writeTextFile(this.file, this.replace, this.encoding, this.derived, this.writer.getContent(), monitor);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public BufferedJET2Writer getContentWriter() {
        return this.writer;
    }
}

