/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.typesystem.emf.ui.BuildJob;
import org.eclipse.xtend.typesystem.emf.ui.ProjectAnalyzer;
import org.eclipse.xtend.typesystem.emf.ui.internal.EmfToolsLog;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfToolsPlugin
extends AbstractUIPlugin {
    private static EmfToolsPlugin plugin;
    private final Map<IJavaProject, ProjectAnalyzer> projectAnalyzerCache = new HashMap<IJavaProject, ProjectAnalyzer>();
    public static boolean trace;
    private final IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                if (event.getDelta() == null) {
                    return;
                }
                final HashSet changedProjects = new HashSet();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((EmfToolsPlugin.this.isEcoreFile(delta.getResource()) || EmfToolsPlugin.this.isJarFile(delta.getResource())) && JavaCore.create((IProject)delta.getResource().getProject()).isOnClasspath(delta.getResource())) {
                            changedProjects.add(delta.getResource().getProject());
                        }
                        return true;
                    }
                });
                EmfToolsPlugin.this.analyzeAndRebuildProjects(changedProjects);
            }
            catch (CoreException e) {
                EmfToolsLog.logError(e);
            }
        }
    };
    private final IElementChangedListener classpathListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            HashSet<IProject> projects = new HashSet<IProject>();
            this.collectChangedProjects(event.getDelta(), projects);
            EmfToolsPlugin.this.analyzeAndRebuildProjects(projects);
        }

        private void collectChangedProjects(IJavaElementDelta delta, Set<IProject> projects) {
            IJavaProject javaProject;
            if (((delta.getFlags() & 0x40) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x20000) != 0) && (javaProject = delta.getElement().getJavaProject()) != null) {
                projects.add(javaProject.getProject());
            }
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta d = iJavaElementDeltaArray[n2];
                this.collectChangedProjects(d, projects);
                ++n2;
            }
        }
    };

    static {
        trace = false;
        String value = Platform.getDebugOption((String)"org.eclipse.internal.xtend.emftools/trace");
        if (value != null && value.equals("true")) {
            trace = true;
        }
    }

    public ProjectAnalyzer getProjectAnalyzer(IProject p) {
        IJavaProject jp = JavaCore.create((IProject)p);
        if (jp == null || !jp.exists()) {
            return null;
        }
        ProjectAnalyzer analyzer = this.projectAnalyzerCache.get(jp);
        if (analyzer == null) {
            analyzer = new ProjectAnalyzer(jp);
            this.projectAnalyzerCache.put(jp, analyzer);
        }
        return analyzer;
    }

    public EmfToolsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectAnalyzer pa;
            IProject p = iProjectArray[n2];
            if (Activator.getExtXptModelManager().findProject((IResource)p) != null && (pa = this.getProjectAnalyzer(p)) != null && pa.getState() != 2) {
                pa.schedule();
            }
            ++n2;
        }
        workspace.addResourceChangeListener(this.resourceListener);
        JavaCore.addElementChangedListener((IElementChangedListener)this.classpathListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.classpathListener);
        this.projectAnalyzerCache.clear();
    }

    /*
     * Unable to fully structure code
     */
    public EPackage[] getMetamodelsForProject(IJavaProject project) {
        projectAnalyzer = this.getProjectAnalyzer(project.getProject());
        if (projectAnalyzer != null) ** GOTO lbl11
        return new EPackage[0];
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(500L);
                if (!EmfToolsPlugin.trace) continue;
                System.out.println("Waiting 500ms for ProjectAnalyzer of project " + project.getProject().getName() + " to finish.");
                continue;
            }
            catch (InterruptedException e) {
                EmfToolsLog.logError(e);
            }
lbl11:
            // 4 sources

            ** while (projectAnalyzer.getState() == 4 || projectAnalyzer.getState() == 2)
        }
lbl12:
        // 1 sources

        packages = new HashMap<String, EPackage>(projectAnalyzer.getNamedEPackageMap());
        try {
            var7_5 = project.getProject().getReferencedProjects();
            var6_6 = var7_5.length;
            var5_7 = 0;
            while (var5_7 < var6_6) {
                p = var7_5[var5_7];
                jp = JavaCore.create((IProject)p);
                var13_15 = ps = this.getMetamodelsForProject(jp);
                var12_14 = ps.length;
                var11_13 = 0;
                while (var11_13 < var12_14) {
                    package1 = var13_15[var11_13];
                    if (!packages.containsKey(package1.getNsURI())) {
                        packages.put(package1.getNsURI(), package1);
                    }
                    ++var11_13;
                }
                ++var5_7;
            }
        }
        catch (CoreException e) {
            EmfToolsLog.logError(e);
        }
        return packages.values().toArray(new EPackage[packages.values().size()]);
    }

    public static EmfToolsPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)EmfToolsPlugin.getId(), (String)path);
    }

    public static String getId() {
        return EmfToolsPlugin.getDefault().getBundle().getSymbolicName();
    }

    protected boolean isEcoreFile(IResource f) {
        return f instanceof IFile && !f.isDerived() && "ecore".equalsIgnoreCase(f.getFileExtension());
    }

    protected boolean isJarFile(IResource f) {
        return f instanceof IFile && !f.isDerived() && "jar".equalsIgnoreCase(f.getFileExtension());
    }

    private void collectReferencingExtXptProjects(IProject project, Map<String, IProject> referencingProjects) {
        IProject[] iProjectArray = project.getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (Activator.getExtXptModelManager().findProject((IResource)p) != null) {
                referencingProjects.put(p.getName(), p);
            }
            this.collectReferencingExtXptProjects(p, referencingProjects);
            ++n2;
        }
    }

    private void analyzeAndRebuildProjects(Set<IProject> projects) {
        HashMap<String, IProject> referencingProjects = new HashMap<String, IProject>();
        for (IProject p : projects) {
            ProjectAnalyzer pa = this.getProjectAnalyzer(p);
            if (pa != null && pa.getState() != 2) {
                pa.schedule();
            }
            this.collectReferencingExtXptProjects(p, referencingProjects);
        }
        ArrayList relevantProjects = new ArrayList(referencingProjects.values());
        relevantProjects.removeAll(projects);
        for (IProject refProject : relevantProjects) {
            new BuildJob(refProject).schedule();
        }
    }
}

