/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.xsd.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.AbstractFunction;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.BooleanType;
import org.eclipse.xtend.backend.types.builtin.CollectionType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.builtin.LongType;
import org.eclipse.xtend.backend.types.builtin.SetType;
import org.eclipse.xtend.backend.types.xsd.XsdTypesystem;
import org.eclipse.xtend.backend.types.xsd.internal.EMapEntryType;

public class EMapType
extends AbstractType {
    private EMapEntryType _elementType;

    public EMapType(String name, XsdTypesystem ts, EClassifier innerType) {
        super(name, "{xsd}" + name, new BackendType[]{ListType.INSTANCE});
        this._elementType = ts.getEMapEntryType(innerType);
        BackendType valueType = this._elementType.getValueType();
        BackendType keyType = this._elementType.getKeyType();
        this.register(new QualifiedName("put"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, valueType, keyType}), valueType, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.put(params[1], params[2]);
            }
        });
        this.register(new QualifiedName("put"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, valueType}), (BackendType)this._elementType, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                Map.Entry e = (Map.Entry)params[1];
                return map.put(e.getKey(), e.getValue());
            }
        });
        this.register(new QualifiedName("putAll"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, keyType}), valueType, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                for (Object o : (Collection)params[1]) {
                    Map.Entry e = (Map.Entry)o;
                    map.put(e.getKey(), e.getValue());
                }
                return null;
            }
        });
        this.register(new QualifiedName("get"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, valueType}), (BackendType)this._elementType, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.get(params[1]);
            }
        });
        this.register(new QualifiedName("indexOfKey"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, keyType}), (BackendType)LongType.INSTANCE, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.indexOfKey(params[1]);
            }
        });
        this.register(new QualifiedName("containsKey"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, keyType}), (BackendType)BooleanType.INSTANCE, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.containsKey(params[1]);
            }
        });
        this.register(new QualifiedName("containsValue"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, valueType}), (BackendType)BooleanType.INSTANCE, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.containsValue(params[1]);
            }
        });
        this.register(new QualifiedName("removeKey"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, keyType}), valueType, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.removeKey(params[1]);
            }
        });
        this.register(new QualifiedName("keySet"), (Function)new AbstractFunction(null, Arrays.asList(this), (BackendType)SetType.INSTANCE, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.keySet();
            }
        });
        this.register(new QualifiedName("values"), (Function)new AbstractFunction(null, Arrays.asList(this), (BackendType)CollectionType.INSTANCE, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                EMap map = (EMap)params[0];
                return map.values();
            }
        });
    }

    public EMapEntryType getElementType() {
        return this._elementType;
    }

    public static boolean isEMapObject(Object o) {
        return o instanceof EMap && o instanceof EStructuralFeature.Setting && EMapType.isEMap(((EStructuralFeature.Setting)o).getEStructuralFeature());
    }

    private static boolean isEMap(EStructuralFeature feature) {
        EClassifier t = feature.getEType();
        return feature != null && feature.eContainer() instanceof EClass && t != null && t.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(t.getInstanceClass()) && feature.isMany();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        if (other instanceof EMapType) {
            EMapType cfr_ignored_0 = (EMapType)((Object)other);
        }
        return true;
    }
}

