/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xpand.internal.xpandlib.pr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtend.backend.util.Base64Codec;
import org.eclipse.xtend.backend.util.FileHelper;
import org.eclipse.xtend.backend.util.GenericFileFilter;
import org.eclipse.xtend.middleend.xpand.internal.xpandlib.pr.DuplicateXpandProtectedRegionException;
import org.eclipse.xtend.middleend.xpand.internal.xpandlib.pr.XpandProtectedRegionSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandProtectedRegionResolver {
    public static final String XPAND_PROTECTED_REGION_RESOLVER = "XpandProtectedRegionResolver";
    private static final String PROTECT_AFTER_ID = ")";
    private static final String PROTECT_B64_AFTER_ID = "]";
    private static final String PROTECT_B64_BEFORE_ID = "[";
    private static final String PROTECT_BEFORE_ID = "(";
    private static final String PROTECT_BEGIN = "PROTECTED REGION ID";
    private static final String PROTECT_END = "PROTECTED REGION END";
    private static final String PROTECT_START_END = "START";
    private static final String ENABLED = "ENABLED";
    private Map<String, XpandProtectedRegion> _regions;
    private String _ignoreList;
    private boolean _defaultExcludes;
    private File[] _srcPaths;
    private HashSet<String> _usedSet;
    private Log log = LogFactory.getLog(XpandProtectedRegionResolver.class);
    private String _fileEncoding;
    private boolean _useBase64;

    public XpandProtectedRegionResolver() {
    }

    public XpandProtectedRegionResolver(String ignoreList, boolean defaultExcludes, List<Outlet> outlets, String fileEncoding, boolean useBase64) {
        this._ignoreList = ignoreList;
        this._defaultExcludes = defaultExcludes;
        this._srcPaths = new File[outlets.size()];
        int i = 0;
        while (i < this._srcPaths.length) {
            this._srcPaths[i] = new File(outlets.get(i).getPath());
            ++i;
        }
        this._fileEncoding = fileEncoding;
        this._useBase64 = useBase64;
    }

    public void init() throws DuplicateXpandProtectedRegionException {
        if (this._regions != null) {
            return;
        }
        this._regions = new HashMap<String, XpandProtectedRegion>();
        this._usedSet = new HashSet();
        if (this._srcPaths == null) {
            this.log.warn((Object)"No source paths configured for scanning.");
            return;
        }
        long time = 0L;
        long fileCount = 0L;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Source scan started ...");
            time = System.currentTimeMillis();
        }
        GenericFileFilter filter = new GenericFileFilter(this._ignoreList, this._defaultExcludes);
        int i = 0;
        while (i < this._srcPaths.length) {
            try {
                File[] files = FileHelper.getAllFiles((File)this._srcPaths[i], (FilenameFilter)filter);
                fileCount += (long)files.length;
                int j = 0;
                while (j < files.length) {
                    for (XpandProtectedRegion region : this.retrieveProtectedRegions(files[j], this._fileEncoding, this._useBase64)) {
                        this.register(region);
                    }
                    ++j;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected I/O exception", e);
            }
            catch (XpandProtectedRegionSyntaxException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            ++i;
        }
        if (this.log.isInfoEnabled()) {
            time = System.currentTimeMillis() - time;
            this.log.info((Object)("Source scan finished in " + (double)time / 1000.0 + "s"));
            this.log.info((Object)("Files scanned: " + fileCount));
            this.log.info((Object)("Regions found: " + this._regions.size()));
        }
    }

    public XpandProtectedRegion getProtectedRegion(String id) {
        try {
            this.init();
        }
        catch (DuplicateXpandProtectedRegionException e) {
            this.log.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (!this._usedSet.add(id)) {
            this.log.warn((Object)("Protected region with ID '" + id + "' referenced more than once"));
        }
        return this._regions.get(id);
    }

    public XpandProtectedRegion createProtectedRegion(String id, boolean disabled) {
        return new XpandProtectedRegion(id, 0, 0, null, null, disabled, this._useBase64, null);
    }

    public void register(XpandProtectedRegion region) throws DuplicateXpandProtectedRegionException {
        if (this.isRegistered(region)) {
            String id = region.getId();
            throw new DuplicateXpandProtectedRegionException("The protected region Id '" + id + "' occuring in files " + region.getFile() + " and " + this._regions.get(id).getFile() + " is not unique");
        }
        this._regions.put(region.getId(), region);
    }

    public boolean isRegistered(XpandProtectedRegion region) {
        return this._regions.containsKey(region.getId());
    }

    private Collection<XpandProtectedRegion> retrieveProtectedRegions(File file, String encoding, boolean useBASE64) throws XpandProtectedRegionSyntaxException, IOException {
        ArrayList<XpandProtectedRegion> regions = new ArrayList<XpandProtectedRegion>();
        String source = FileHelper.read((File)file, (String)encoding);
        int beginLength = PROTECT_BEGIN.length();
        int startEndLength = PROTECT_START_END.length();
        int idBeginLength = PROTECT_BEFORE_ID.length();
        int idEndLength = PROTECT_AFTER_ID.length();
        int start = source.indexOf(PROTECT_BEGIN);
        while (start >= 0) {
            int startEnd;
            int blockStart = start + beginLength;
            boolean isB64 = false;
            int idStart = source.indexOf(PROTECT_BEFORE_ID, blockStart);
            if (idStart != blockStart) {
                idStart = source.indexOf(PROTECT_B64_BEFORE_ID, blockStart);
                isB64 = true;
            }
            int end = source.indexOf(PROTECT_END, idStart += idBeginLength);
            int next = source.indexOf(PROTECT_BEGIN, idStart);
            if (end < 0 || next >= 0 && next < end) {
                throw new XpandProtectedRegionSyntaxException("Protected region at index " + start + " in file '" + file + "' is incomplete");
            }
            int idEnd = source.indexOf(isB64 ? PROTECT_B64_AFTER_ID : PROTECT_AFTER_ID, idStart);
            if (idEnd <= idStart || end < idEnd) {
                throw new XpandProtectedRegionSyntaxException("Protected region Id at index " + start + " in file '" + file + "' is incomplete");
            }
            String id = new String(source.substring(idStart, idEnd));
            if (isB64) {
                try {
                    id = new String(Base64Codec.toByteArray((String)id));
                }
                catch (IOException ie) {
                    throw new XpandProtectedRegionSyntaxException("Protected region Id at index " + start + " in file '" + file + "' is incomplete", ie);
                }
            }
            if (end < (startEnd = source.indexOf(PROTECT_START_END, idEnd + idEndLength))) {
                throw new XpandProtectedRegionSyntaxException("Protected region start at index " + start + " in file '" + file + "' is incomplete");
            }
            String type = new String(source.substring(idEnd + idEndLength, startEnd).trim().toUpperCase());
            if (!type.equals("") && !type.equals(ENABLED)) {
                throw new XpandProtectedRegionSyntaxException("Protected region start at index " + start + " in file " + file + " has illegal type '" + type + "'");
            }
            if (type.equals(ENABLED)) {
                String body = new String(source.substring(startEnd + startEndLength, end));
                regions.add(new XpandProtectedRegion(id, startEnd + startEndLength, end, file, encoding, false, useBASE64, body));
            }
            start = next;
        }
        return regions;
    }

    public void reportRegions(File dumpPath) {
        int unused = this._regions.size() - this._usedSet.size();
        if (unused > 0) {
            this.log.warn((Object)("There are " + unused + " unused Regions:"));
            if (dumpPath != null) {
                dumpPath.mkdirs();
            }
            for (XpandProtectedRegion region : this._regions.values()) {
                String id = region.getId();
                if (this._usedSet.contains(id)) continue;
                this.log.warn((Object)("File: " + region.getFile()));
                this.log.warn((Object)("ID: " + id));
                try {
                    if (dumpPath == null) continue;
                    File file = new File(dumpPath, Base64Codec.toString((String)id));
                    OutputStreamWriter writer = this._fileEncoding == null ? new FileWriter(file) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this._fileEncoding);
                    writer.write(region.getStartString("", ""));
                    writer.write(region.getBody("", ""));
                    writer.write(region.getEndString("", ""));
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected I/O exception", e);
                }
                catch (XpandProtectedRegionSyntaxException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setDefaultExcludes(boolean defaultExcludes) {
        this._defaultExcludes = defaultExcludes;
    }

    public void setFileEncoding(String encoding) {
        this._fileEncoding = encoding;
    }

    public void setIgnoreList(String ignoreList) {
        this._ignoreList = ignoreList;
    }

    public void setSrcPathes(String srcPathsAsString) throws IllegalArgumentException {
        if ("".equals(srcPathsAsString)) {
            this._srcPaths = new File[0];
        } else {
            String[] s = srcPathsAsString.split(",");
            this._srcPaths = new File[s.length];
            int i = 0;
            while (i < this._srcPaths.length) {
                this._srcPaths[i] = new File(s[i].trim());
                if (!this._srcPaths[i].isDirectory()) {
                    throw new IllegalArgumentException("Source path component " + this._srcPaths[i] + " not found or no directory");
                }
                ++i;
            }
        }
    }

    public void setUseBASE64(boolean useBASE64) {
        this._useBase64 = useBASE64;
    }

    public class XpandProtectedRegion {
        private final String _id;
        private final int _startPos;
        private final int _endPos;
        private final File _file;
        private final String _encoding;
        private final boolean _disabled;
        private final boolean _isBase64;
        private final SoftReference<String> _body;

        public XpandProtectedRegion(String id, int startPos, int endPos, File file, String encoding, boolean disabled, boolean useBase64, String body) {
            this._id = id;
            this._startPos = startPos;
            this._endPos = endPos;
            this._file = file;
            this._encoding = encoding;
            this._disabled = disabled;
            this._isBase64 = useBase64;
            this._body = new SoftReference<String>(body);
        }

        public String getBody() {
            return this._body.get();
        }

        public String getBody(String startComment, String endComment) throws XpandProtectedRegionSyntaxException {
            int endCommentPos;
            String body = this._body.get();
            if (body == null) {
                try {
                    body = FileHelper.read((File)this._file, (String)this._encoding).substring(this._startPos, this._endPos);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected I/O exception (source files removed?)", e);
                }
            }
            if ((endCommentPos = body.indexOf(endComment)) < 0 || body.substring(0, endCommentPos).trim().length() > 0) {
                throw new XpandProtectedRegionSyntaxException("Start of protected region " + this._id + " does not end with comment " + endComment);
            }
            int startCommentPos = body.lastIndexOf(startComment);
            if (startCommentPos < 0 || body.substring(startCommentPos + startComment.length()).trim().length() > 0) {
                throw new XpandProtectedRegionSyntaxException("End of protected region " + this._id + " does not start with comment " + startComment + " \"" + body.substring(startCommentPos + startComment.length()).trim() + "\"");
            }
            return body.substring(endCommentPos + endComment.length(), startCommentPos);
        }

        public String getId() {
            return this._id;
        }

        public File getFile() {
            return this._file;
        }

        public String getStartString(String startComment, String endComment) {
            if (this._isBase64) {
                try {
                    return String.valueOf(startComment) + XpandProtectedRegionResolver.PROTECT_BEGIN + XpandProtectedRegionResolver.PROTECT_B64_BEFORE_ID + Base64Codec.toString((String)this._id) + XpandProtectedRegionResolver.PROTECT_B64_AFTER_ID + " " + (!this._disabled ? "ENABLED " : "") + XpandProtectedRegionResolver.PROTECT_START_END + endComment;
                }
                catch (IOException iOException) {}
            }
            return String.valueOf(startComment) + XpandProtectedRegionResolver.PROTECT_BEGIN + XpandProtectedRegionResolver.PROTECT_BEFORE_ID + this._id + XpandProtectedRegionResolver.PROTECT_AFTER_ID + " " + (!this._disabled ? "ENABLED " : "") + XpandProtectedRegionResolver.PROTECT_START_END + endComment;
        }

        public String getEndString(String startComment, String endComment) {
            return String.valueOf(startComment) + XpandProtectedRegionResolver.PROTECT_END + endComment;
        }
    }
}

