/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ui.core.internal.builder;

import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.JavaExtensionStatement;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.ui.internal.XtendLog;

public class PluginJavaExtensionStatement
extends JavaExtensionStatement {
    private IJavaProject jp;

    public PluginJavaExtensionStatement(IJavaProject jp, Identifier name, List formalParameters, Identifier returnType, Identifier javaType, Identifier javaMethod, List javaParamTypes, boolean cached, boolean isPriv) {
        super(name, formalParameters, returnType, javaType, javaMethod, javaParamTypes, cached, isPriv);
        this.jp = jp;
    }

    public void analyzeInternal(ExecutionContext ctx, Set issues) {
        this.checkForAmbiguousDefinitions(ctx, issues);
        boolean everythingFine = true;
        IType it = null;
        try {
            it = this.jp.findType(this.getJavaType().getValue());
        }
        catch (JavaModelException e) {
            XtendLog.logError(e);
        }
        if (it == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, String.valueOf(this.getJavaType().getValue()) + " not found", (SyntaxElement)this.getJavaType()));
            everythingFine = false;
        }
        List l = this.javaParamTypes;
        IType[] pts = new IType[l.size()];
        String[] signs = new String[l.size()];
        int i = 0;
        while (i < pts.length) {
            Identifier typeName = (Identifier)l.get(i);
            try {
                pts[i] = this.jp.findType(typeName.getValue());
            }
            catch (JavaModelException javaModelException) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, String.valueOf(typeName.getValue()) + " not found", (SyntaxElement)typeName));
                everythingFine = false;
            }
            if (pts[i] == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, String.valueOf(typeName.getValue()) + " not found", (SyntaxElement)typeName));
                everythingFine = false;
            } else {
                signs[i] = Signature.createTypeSignature((String)pts[i].getFullyQualifiedName(), (boolean)true);
            }
            ++i;
        }
        if (everythingFine) {
            IMethod m = it.getMethod(this.javaMethod.getValue(), signs);
            IMethod[] ms = it.findMethods(m);
            if (ms == null || ms.length == 0) {
                issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, String.valueOf(this.javaMethod.getValue()) + " not found", (SyntaxElement)this.javaMethod));
                return;
            }
            int f = 0;
            try {
                f = ms[0].getFlags();
            }
            catch (JavaModelException e) {
                XtendLog.logError(e);
                return;
            }
            if (!Flags.isPublic((int)f)) {
                issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, "The method " + this.javaMethod.getValue() + " is not public.", (SyntaxElement)this.javaMethod));
            }
        }
    }
}

