/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.type.baseimpl.types.BooleanTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.CollectionTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.IntegerTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.ListTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.ObjectTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.OperationTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.PropertyTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.RealTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.SetTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.StaticPropertyTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.StringTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.TypeTypeImpl;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.CompositeTypesystem;
import org.eclipse.xtend.backend.types.builtin.BooleanType;
import org.eclipse.xtend.backend.types.builtin.CollectionType;
import org.eclipse.xtend.backend.types.builtin.DoubleType;
import org.eclipse.xtend.backend.types.builtin.FunctionType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.builtin.LongType;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.PropertyType;
import org.eclipse.xtend.backend.types.builtin.SetType;
import org.eclipse.xtend.backend.types.builtin.StaticPropertyType;
import org.eclipse.xtend.backend.types.builtin.StringType;
import org.eclipse.xtend.backend.types.builtin.TypeType;
import org.eclipse.xtend.backend.types.builtin.VoidType;
import org.eclipse.xtend.backend.types.emf.EObjectType;
import org.eclipse.xtend.backend.types.emf.EmfTypesystem;
import org.eclipse.xtend.backend.types.uml2.UmlTypesystem;
import org.eclipse.xtend.backend.types.xsd.XsdTypesystem;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.type.impl.java.JavaTypeImpl;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EClassType;
import org.eclipse.xtend.typesystem.emf.EDataTypeType;
import org.eclipse.xtend.typesystem.emf.EEnumType;
import org.eclipse.xtend.typesystem.uml2.profile.EnumType;
import org.eclipse.xtend.typesystem.uml2.profile.MultipleStereotypeType;
import org.eclipse.xtend.typesystem.uml2.profile.StereotypeType;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureMapEntryTypeImpl;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureMapTypeImpl;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureType;
import org.eclipse.xtend.typesystem.xsd.type.EMapEntryType;
import org.eclipse.xtend.typesystem.xsd.type.EMapType;
import org.eclipse.xtend.typesystem.xsd.type.QNameType;
import org.eclipse.xtend.typesystem.xsd.type.XMLEClassType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeToBackendType {
    private final BackendTypesystem _backendTypes;
    private final EmfTypesystem _emfTypes;
    private UmlTypesystem _umlTypes = null;
    private XsdTypesystem _xsdTypes = null;
    private final ExecutionContext _ctx;
    private Class _emfOldXtendTypesClass;
    private Class _umlOldXtendTypesClass;
    private Class _xsdOldXtendTypesClass;
    private Class _emfTypesClass = null;
    private Class _umlTypesClass = null;
    private Class _xsdTypesClass = null;
    private boolean _hasEmfOldXtendTypes;
    private boolean _hasUmlOldXtendTypes;
    private boolean _hasXsdOldXtendTypes;

    public TypeToBackendType(BackendTypesystem backendTypes, ExecutionContext ctx) {
        this._backendTypes = backendTypes;
        this._ctx = ctx;
        try {
            this._umlTypesClass = Class.forName("org.eclipse.xtend.backend.types.uml2.UmlTypesystem");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            this._xsdTypesClass = Class.forName("org.eclipse.xtend.backend.types.xsd.XsdTypesystem");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        EmfTypesystem ets = null;
        UmlTypesystem uts = null;
        XsdTypesystem xts = null;
        for (BackendTypesystem bts : ((CompositeTypesystem)this._backendTypes).getInner()) {
            if (bts instanceof EmfTypesystem) {
                ets = (EmfTypesystem)bts;
            }
            if (this._umlTypesClass != null && bts instanceof UmlTypesystem) {
                uts = (UmlTypesystem)bts;
            }
            if (this._xsdTypesClass == null || !(bts instanceof XsdTypesystem)) continue;
            xts = (XsdTypesystem)bts;
        }
        this._emfTypes = ets;
        if (this._umlTypesClass != null) {
            this._umlTypes = uts;
        }
        if (this._xsdTypesClass != null) {
            this._xsdTypes = xts;
        }
        try {
            this._emfOldXtendTypesClass = Class.forName("org.eclipse.xtend.typesystem.emf.EmfMetaModel");
            this._hasEmfOldXtendTypes = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._hasEmfOldXtendTypes = false;
        }
        try {
            this._umlOldXtendTypesClass = Class.forName("org.eclipse.xtend.typesystem.uml2.UML2MetaModel");
            this._hasUmlOldXtendTypes = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._hasUmlOldXtendTypes = false;
        }
        try {
            this._xsdOldXtendTypesClass = Class.forName("org.eclipse.xtend.typesystem.xsd.XSDMetaModel");
            this._hasXsdOldXtendTypes = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._hasXsdOldXtendTypes = false;
        }
    }

    public BackendType convertToBackendType(Identifier typeName) {
        return this.convertToBackendType(Arrays.asList(typeName.getValue().split("::")));
    }

    private BackendType convertToBackendType(List<String> segments) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : segments) {
            if (!first) {
                sb.append("::");
            }
            first = false;
            sb.append(s);
        }
        Type t = this._ctx.getTypeForName(sb.toString());
        return this.convertToBackendType(t);
    }

    public BackendType convertToBackendType(Class<?> cls) {
        return this._backendTypes.findType(cls);
    }

    public BackendType convertToBackendType(Type t) {
        if (this._hasUmlOldXtendTypes) {
            if (t instanceof StereotypeType) {
                return this.convertStereotypeType(t);
            }
            if (t instanceof MultipleStereotypeType) {
                return this.convertMultipleStereotypeType(t);
            }
            if (t instanceof EnumType) {
                return this.convertEnumType(t);
            }
        }
        if (this._hasXsdOldXtendTypes) {
            if (t instanceof QNameType) {
                return this._xsdTypes.getQNameType();
            }
            if (t instanceof XMLEClassType) {
                return this.convertXMLEClassType(t);
            }
            if (t instanceof EFeatureMapTypeImpl) {
                return this.convertEFeatureMapType(t);
            }
            if (t instanceof EFeatureMapEntryTypeImpl) {
                return this._xsdTypes.getEFeatureMapEntryType();
            }
            if (t instanceof EFeatureType) {
                return this._xsdTypes.getEFeatureType();
            }
            if (t instanceof EMapType) {
                return this.convertEMapType(t);
            }
            if (t instanceof EMapEntryType) {
                return this.convertEMapEntryType(t);
            }
        }
        if (t instanceof EClassType) {
            return this.convertEClassType(t);
        }
        if (t instanceof EDataTypeType) {
            return this.convertEDataTypeType(t);
        }
        if (t instanceof EEnumType) {
            return this.convertEEnumType(t);
        }
        if (t instanceof org.eclipse.xtend.typesystem.emf.EObjectType) {
            return EObjectType.INSTANCE;
        }
        if (t instanceof JavaTypeImpl) {
            return this.convertJavaType(t);
        }
        if (t instanceof BooleanTypeImpl) {
            return BooleanType.INSTANCE;
        }
        if (t instanceof ListTypeImpl) {
            return ListType.INSTANCE;
        }
        if (t instanceof SetTypeImpl) {
            return SetType.INSTANCE;
        }
        if (t instanceof CollectionTypeImpl) {
            return CollectionType.INSTANCE;
        }
        if (t instanceof IntegerTypeImpl) {
            return LongType.INSTANCE;
        }
        if (t instanceof ObjectTypeImpl) {
            return ObjectType.INSTANCE;
        }
        if (t instanceof OperationTypeImpl) {
            return FunctionType.INSTANCE;
        }
        if (t instanceof PropertyTypeImpl) {
            return PropertyType.INSTANCE;
        }
        if (t instanceof RealTypeImpl) {
            return DoubleType.INSTANCE;
        }
        if (t instanceof StaticPropertyTypeImpl) {
            return StaticPropertyType.INSTANCE;
        }
        if (t instanceof StringTypeImpl) {
            return StringType.INSTANCE;
        }
        if (t instanceof TypeTypeImpl) {
            return TypeType.INSTANCE;
        }
        if (t instanceof org.eclipse.internal.xtend.type.baseimpl.types.VoidType) {
            return VoidType.INSTANCE;
        }
        if (t != null) {
            throw new IllegalArgumentException("unable to convert type " + t.getClass().getName());
        }
        throw new IllegalArgumentException("unable to convert type 'null'");
    }

    private BackendType convertEnumType(Type t) {
        if (t instanceof EnumType) {
            return this._umlTypes.findType((Object)((EnumType)t).getEnumeration());
        }
        return null;
    }

    private BackendType convertMultipleStereotypeType(Type t) {
        if (t instanceof StereotypeType) {
            List stTypes = ((MultipleStereotypeType)t).getStereotypes();
            ArrayList<Stereotype> st = new ArrayList<Stereotype>();
            for (StereotypeType stType : stTypes) {
                st.add(stType.getStereoType());
            }
            return this._umlTypes.findType(st);
        }
        return null;
    }

    private BackendType convertStereotypeType(Type t) {
        if (t instanceof StereotypeType) {
            Stereotype st = ((StereotypeType)t).getStereoType();
            return this._umlTypes.findType(UmlTypesystem.getUniqueIdentifier((NamedElement)st));
        }
        return null;
    }

    private BackendType convertJavaType(Type t) {
        Class cls = (Class)this.getField(t, "clazz");
        return this._backendTypes.findType(cls);
    }

    private BackendType convertEClassType(Type t) {
        EClass eClass = (EClass)this.getField(t, "eClass");
        return this._emfTypes.getTypeForEClassifier((EClassifier)eClass);
    }

    private BackendType convertEDataTypeType(Type t) {
        EDataType eClass = (EDataType)this.getField(t, "dataType");
        return this._emfTypes.getTypeForEClassifier((EClassifier)eClass);
    }

    private BackendType convertEEnumType(Type t) {
        EEnum eClass = (EEnum)this.getField(t, "eEnum");
        return this._emfTypes.getTypeForEClassifier((EClassifier)eClass);
    }

    private BackendType convertXMLEClassType(Type t) {
        EClass eClass = (EClass)this.getField(t, "clazz");
        return this._xsdTypes.getTypeForEClassifier((EClassifier)eClass);
    }

    private BackendType convertEFeatureMapType(Type t) {
        if (t instanceof EFeatureMapTypeImpl) {
            EClass eClass = ((EFeatureMapTypeImpl)t).getOwner();
            return this._xsdTypes.getEFeatureMapType(eClass);
        }
        return null;
    }

    private BackendType convertEMapType(Type t) {
        if (t instanceof EMapType) {
            EClassifier innerType = ((EMapType)t).getInnerType();
            return this._xsdTypes.getEMapType(innerType);
        }
        return null;
    }

    private BackendType convertEMapEntryType(Type t) {
        if (t instanceof EMapEntryType) {
            EClassifier emfType = ((EMapEntryType)t).getEmfType();
            return this._xsdTypes.getEMapEntryType(emfType);
        }
        return null;
    }

    private Object getField(Object o, String fieldName) {
        try {
            Class<?> cls = o.getClass();
            Field f = cls.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

