/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.type.baseimpl.PolymorphicResolver;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xpand.ui.core.IXpandResource;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.core.search.XtendXpandSearchEngine;
import org.eclipse.xtend.shared.ui.editor.navigation.AbstractHyperlinkDetector;
import org.eclipse.xtend.shared.ui.editor.navigation.GenericHyperlink;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandHyperlinkDetector
extends AbstractHyperlinkDetector {
    public XpandHyperlinkDetector(IEditorPart editor) {
        super(editor);
    }

    protected List<GenericHyperlink> computeMatchesAndHyperlinks(IRegion hyperlinkRegion, String hyperlinkedWord, IXtendXpandProject project) {
        IXpandResource xpandResource = (IXpandResource)Activator.getExtXptModelManager().findExtXptResource((IStorage)this.getFile());
        List links = this.createHyperlinkToImportedExtensions(xpandResource, hyperlinkRegion, hyperlinkedWord);
        if (!links.isEmpty()) {
            return links;
        }
        ExpandStatement statement = XtendXpandSearchEngine.findDefinition((String)hyperlinkedWord, (IRegion)hyperlinkRegion, (Template)((Template)xpandResource.getExtXptResource()));
        if (statement != null) {
            List defmatches = XtendXpandSearchEngine.findDefinitionsByNameInResourceAndImports((IXtendXpandProject)project, (String)statement.getDefinition().getValue(), (XpandResource)xpandResource);
            ExecutionContext ctx = Activator.getExecutionContext((IJavaProject)this.getXtendXpandProject().getProject()).cloneWithResource((Resource)statement.getContainingDefinition().getOwner());
            Type expandTargetType = null;
            expandTargetType = statement.getTarget() == null ? ctx.getTypeForName(statement.getContainingDefinition().getType().getValue()) : (statement.getTarget().equals("this") ? ctx.getTypeForName(statement.getContainingDefinition().getType().getValue()) : statement.getTarget().analyze(ctx, new HashSet()));
            if (expandTargetType == null) {
                expandTargetType = ctx.getTypeForName(statement.getContainingDefinition().getType().getValue());
            }
            Type[] statementTypes = new Type[statement.getParameters().length];
            int i = 0;
            while (i < statementTypes.length) {
                statementTypes[i] = statement.getParameters()[i].analyze(ctx, new HashSet());
                if (statementTypes[i] == null) {
                    statementTypes[i] = ctx.getObjectType();
                }
                ++i;
            }
            for (AbstractDefinition definition : defmatches) {
                if (!this.isDefinitionAssignableFromExpandStatement(definition, statementTypes, expandTargetType, ctx)) continue;
                SearchMatch match = new SearchMatch(definition.getDefName().getStart(), definition.getDefName().getEnd() - definition.getDefName().getStart(), this.getXXResourceByName(definition.getFileName(), "xpt").getUnderlyingStorage());
                GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), match, (IRegion)new Region(statement.getDefinition().getStart(), statement.getDefinition().getEnd() - statement.getDefinition().getStart()), this.computeHyperlinkLabel(hyperlinkedWord, definition.getTargetType(), definition.getParamsAsList(), this.getXXResourceByName(definition.getFileName(), "xpt")));
                links.add(genericHyperlink);
            }
        }
        OperationCall expression = null;
        if (statement == null) {
            expression = XtendXpandSearchEngine.findExpressionInTemplate((IRegion)hyperlinkRegion, (Template)((Template)xpandResource.getExtXptResource()));
        }
        if (expression != null) {
            links = this.findExtensionMatches(hyperlinkRegion, hyperlinkedWord, project, xpandResource, links, expression.getParams().length);
        }
        return links;
    }

    private boolean isDefinitionAssignableFromExpandStatement(AbstractDefinition definition, Type[] statementTypes, Type statementType, ExecutionContext ctx) {
        Type defineType = ctx.getTypeForName(definition.getType().getValue());
        if (defineType == null) {
            defineType = ctx.getObjectType();
        }
        if (!statementType.isAssignableFrom(defineType)) {
            return false;
        }
        ArrayList<Type> definitionTypes = new ArrayList<Type>();
        DeclaredParameter[] declaredParameterArray = definition.getParams();
        int n = declaredParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeclaredParameter param = declaredParameterArray[n2];
            Type paramType = ctx.getTypeForName(param.getType().getValue());
            if (paramType != null) {
                definitionTypes.add(paramType);
            } else {
                definitionTypes.add(ctx.getObjectType());
            }
            ++n2;
        }
        return PolymorphicResolver.typesComparator.compare(definitionTypes, Arrays.asList(statementTypes)) >= 0;
    }
}

