/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class XMLMixedContentFormatter {
    protected static final EStructuralFeature XML_COMMENT = XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__COMMENT;
    protected static final EStructuralFeature XML_TEXT = XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT;
    private static final String LINESEP = System.getProperty("line.separator");
    protected boolean formatComments = true;
    protected String indetationString = "  ";
    protected int indetationWidth = 0;
    protected int maxLineWidth = 80;

    protected boolean beautifyFeatuerMapTextEntries(int prefix, FeatureMap map) {
        boolean needsFinal = false;
        for (FeatureMap.Entry e : new ArrayList(map)) {
            if (e.getEStructuralFeature() != XML_TEXT || !(e.getValue() instanceof String)) continue;
            String b = this.beautifyString((String)e.getValue());
            if (b == null || b.equals("")) {
                map.remove((Object)e);
                continue;
            }
            if (this.needsWrap(prefix, b)) {
                needsFinal = true;
                b = this.wordWrap(prefix, b);
            }
            map.setValue(map.indexOf((Object)e), (Object)b);
        }
        return needsFinal;
    }

    protected void beautifyFeatureMap(int prefix, FeatureMap map) {
        boolean needsFinal = this.beautifyFeatuerMapTextEntries(prefix, map);
        if (this.formatComments) {
            this.beautifyFeatureMapComments(prefix, map);
        }
        if (this.beautifyFeatureMapIndent(prefix, map)) {
            needsFinal = true;
        }
        if (needsFinal) {
            int last = map.size() - 1;
            String pref = String.valueOf(LINESEP) + this.getPrefix(prefix - 1);
            if (((FeatureMap.Entry)map.get(last)).getEStructuralFeature() == XML_TEXT) {
                map.setValue(last, (Object)(String.valueOf(this.trimRight(map.getValue(last))) + pref));
            } else {
                map.add(XML_TEXT, (Object)pref);
            }
        }
    }

    protected void beautifyFeatureMapComments(int prefix, FeatureMap map) {
        for (FeatureMap.Entry e : new ArrayList(map)) {
            if (!this.processFeature(e.getEStructuralFeature()) || e.getEStructuralFeature() != XML_COMMENT || !(e.getValue() instanceof String)) continue;
            String cmt = this.beautifyString(e.getValue().toString()).trim();
            cmt = this.needsWrap(prefix, cmt) ? String.valueOf(this.wordWrap(prefix + 1, cmt)) + LINESEP + this.getPrefix(prefix) : " " + cmt + " ";
            map.setValue(map.indexOf((Object)e), (Object)cmt);
        }
    }

    protected boolean beautifyFeatureMapIndent(int prefix, FeatureMap map) {
        boolean needsFinal = false;
        for (FeatureMap.Entry e : new ArrayList(map)) {
            if (!this.processFeature(e.getEStructuralFeature()) || e.getEStructuralFeature() == XML_TEXT) continue;
            if (prefix > 0) {
                this.insertBefore(map, e, String.valueOf(LINESEP) + this.getPrefix(prefix));
            }
            needsFinal = true;
        }
        return needsFinal;
    }

    public void beautifyMixedContent(int prefix, EObject obj) {
        for (EObject o : obj.eContents()) {
            this.beautifyMixedContent(prefix + 1, o);
        }
        for (EStructuralFeature f : obj.eClass().getEAllStructuralFeatures()) {
            if (f.isTransient() || !f.isMany() || f.getEType().getInstanceClass() != FeatureMap.Entry.class) continue;
            this.beautifyFeatureMap(prefix, (FeatureMap)obj.eGet(f));
        }
    }

    protected String beautifyString(String str) {
        return str.replaceAll("[\n\r\t]", " ").replaceAll(" {2,}", " ");
    }

    public String getIndetationString() {
        return this.indetationString;
    }

    public int getIndetationWidth() {
        return this.indetationWidth;
    }

    protected int getInWidth() {
        return this.indetationWidth == 0 ? this.indetationString.length() : this.indetationWidth;
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    protected String getPrefix(int level) {
        StringBuffer r = new StringBuffer();
        int i = 0;
        while (i < level) {
            r.append(this.indetationString);
            ++i;
        }
        return r.toString();
    }

    protected void insertBefore(FeatureMap map, FeatureMap.Entry ent, String str) {
        int index = map.indexOf((Object)ent);
        if (index > 0 && ((FeatureMap.Entry)map.get(index - 1)).getEStructuralFeature() == XML_TEXT) {
            map.setValue(index - 1, (Object)(String.valueOf(this.trimRight(map.getValue(index - 1))) + str));
        } else {
            map.add(index, XML_TEXT, (Object)str);
        }
    }

    public boolean isFormatComments() {
        return this.formatComments;
    }

    protected boolean needsWrap(int prefix, String str) {
        return str.length() + prefix * this.getInWidth() > this.maxLineWidth;
    }

    protected boolean processFeature(EStructuralFeature feat) {
        int k = ExtendedMetaData.INSTANCE.getFeatureKind(feat);
        return k == 4 || k == 4 || k == 5;
    }

    public void setFormatComments(boolean formatComments) {
        this.formatComments = formatComments;
    }

    public void setIndetationString(String indetationString) {
        this.indetationString = indetationString;
    }

    public void setIndetationWidth(int indetationWidth) {
        this.indetationWidth = indetationWidth;
    }

    public void setMaxLineWidth(int maxLineWidth) {
        this.maxLineWidth = maxLineWidth;
    }

    protected String trimRight(Object val) {
        if (val instanceof String) {
            String s = val.toString();
            int i = s.length() - 1;
            while (i >= 0 && s.charAt(i) == ' ') {
                --i;
            }
            String r = s.substring(0, i + 1);
            return r;
        }
        return "";
    }

    protected String trimLeft(Object val) {
        if (val instanceof String) {
            String s = val.toString();
            int i = 0;
            while (i < s.length() && s.charAt(i) == ' ') {
                ++i;
            }
            return s.substring(i);
        }
        return "";
    }

    protected String wordWrap(int prefix, String str) {
        str = this.trimLeft(str);
        int width = Math.max(this.maxLineWidth - this.getInWidth() * prefix, 10);
        int old = 0;
        int pos = width;
        StringBuffer buf = new StringBuffer();
        while ((pos = str.indexOf(32, pos)) > -1) {
            buf.append(String.valueOf(LINESEP) + this.getPrefix(prefix) + str.substring(old, pos));
            old = pos + 1;
            pos += width;
        }
        if (old < str.length()) {
            buf.append(String.valueOf(LINESEP) + this.getPrefix(prefix) + str.substring(old));
        }
        return buf.toString();
    }
}

