/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.model.XpandAdvice;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Advice
extends AbstractDefinition
implements XpandAdvice {
    public static final String DEF_VAR_NAME = "targetDef";
    private Pattern p = null;

    public Advice(Identifier pointCut, Identifier type, DeclaredParameter[] params, boolean wildParams, Statement[] body) {
        super(pointCut, type, params, body);
        this.wildParams = wildParams;
    }

    public Identifier getPointCut() {
        return this.getDefName();
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(DEF_VAR_NAME, (Object)ctx.getTypeForName("xpand2::Definition")));
        super.analyze(ctx, issues);
    }

    public boolean isWildcardParams() {
        return this.wildParams;
    }

    @Override
    public boolean matches(XpandDefinition def, XpandExecutionContext ctx) {
        Matcher m;
        if (this.p == null) {
            this.p = Pattern.compile(this.getName().replaceAll("\\*", ".*"));
        }
        if ((m = this.p.matcher(def.getQualifiedName())).matches()) {
            Type at;
            ctx = (XpandExecutionContext)ctx.cloneWithResource(def.getOwner());
            Type t = ctx.getTypeForName(def.getTargetType());
            Type[] paramTypes = new Type[def.getParams().length];
            int i = 0;
            while (i < paramTypes.length) {
                paramTypes[i] = ctx.getTypeForName(def.getParams()[i].getType().getValue());
                ++i;
            }
            if ((this.getParams().length == paramTypes.length || this.wildParams && this.getParams().length <= paramTypes.length) && (at = (ctx = (XpandExecutionContext)ctx.cloneWithResource(def.getOwner())).getTypeForName(this.getTargetType())).isAssignableFrom(t)) {
                int i2 = 0;
                while (i2 < this.getParams().length) {
                    Type pt = ctx.getTypeForName(this.getParams()[i2].getType().getValue());
                    if (!pt.isAssignableFrom(paramTypes[i2])) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
        }
        return false;
    }

    public String getNameString(ExecutionContext context) {
        return "AROUND";
    }

    @Override
    public String toString() {
        if (this._stringRepresentation == null) {
            this._stringRepresentation = String.valueOf(this.getName()) + this.getParamString(false) + " : " + this.getType().getValue();
        }
        return this._stringRepresentation;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.getOwner().getFullyQualifiedName().equals(((Advice)obj).getOwner().getFullyQualifiedName());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getOwner().getFullyQualifiedName().hashCode();
    }
}

