/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.navigation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.internal.xpand2.ast.ExtensionImportDeclaration;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.internal.xtend.xtend.ast.ExtensionImportStatement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.core.search.XtendXpandSearchEngine;
import org.eclipse.xtend.shared.ui.editor.navigation.GenericHyperlink;
import org.eclipse.xtend.shared.ui.editor.navigation.WordDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHyperlinkDetector
implements IHyperlinkDetector {
    protected final IEditorPart editor;
    protected IXtendXpandResource _xxresource = null;

    public AbstractHyperlinkDetector(IEditorPart editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        List<GenericHyperlink> links;
        if (region == null || textViewer == null) {
            return null;
        }
        IRegion hyperlinkRegion = this.getHyperlinkRegion(textViewer, region.getOffset());
        if (hyperlinkRegion == null) {
            return null;
        }
        String hyperlinkedWord = textViewer.getDocument().get().substring(hyperlinkRegion.getOffset(), hyperlinkRegion.getOffset() + hyperlinkRegion.getLength());
        IXtendXpandProject project = this.getXtendXpandProject();
        if (project != null && !(links = this.computeMatchesAndHyperlinks(hyperlinkRegion, hyperlinkedWord, project)).isEmpty()) {
            if (canShowMultipleHyperlinks) {
                return links.toArray(new IHyperlink[links.size()]);
            }
            return new IHyperlink[]{links.get(0)};
        }
        return null;
    }

    protected abstract List<GenericHyperlink> computeMatchesAndHyperlinks(IRegion var1, String var2, IXtendXpandProject var3);

    protected IWorkbenchPage getWorkbenchPage() {
        return this.editor.getSite().getWorkbenchWindow().getActivePage();
    }

    protected IXtendXpandProject getXtendXpandProject() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return Activator.getExtXptModelManager().findProject((IResource)file);
    }

    protected IFile getFile() {
        return (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
    }

    protected IRegion getHyperlinkRegion(ITextViewer textViewer, int offset) {
        String currDoc = textViewer.getDocument().get();
        if (offset == currDoc.length()) {
            return null;
        }
        int start = offset;
        while (start > -1 && WordDetector.isWordPart(currDoc.charAt(start))) {
            --start;
        }
        ++start;
        int end = offset;
        while (end < currDoc.length() && WordDetector.isWordPart(currDoc.charAt(end))) {
            ++end;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        return new Region(start, end - start);
    }

    protected String computeHyperlinkLabel(String name, String typeName, List<DeclaredParameter> params, IXtendXpandResource xxresource) {
        StringBuffer label = new StringBuffer(name);
        if (!params.isEmpty()) {
            label.append("(");
            Iterator<DeclaredParameter> iter = params.iterator();
            while (iter.hasNext()) {
                DeclaredParameter param = iter.next();
                label.append(param.getType().getValue());
                label.append(" " + param.getName().getValue());
                if (!iter.hasNext()) continue;
                label.append(", ");
            }
            label.append(")");
        }
        if (typeName != null) {
            label.append(" : " + typeName);
        }
        if (!xxresource.getUnderlyingStorage().equals(this.getFile())) {
            label.append(" - " + xxresource.getUnderlyingStorage().getName().toString().replace("." + xxresource.getFileExtension(), ""));
        }
        return label.toString();
    }

    protected IXtendXpandResource getXXResourceByName(String fqName, String extension) {
        if (this._xxresource != null && this._xxresource.getFileExtension().equals(extension) && this._xxresource.getFullyQualifiedName().equals(fqName)) {
            return this._xxresource;
        }
        this._xxresource = Activator.getExtXptModelManager().findXtendXpandResource(fqName.replaceAll("::", "/"), extension);
        return this._xxresource;
    }

    protected List<GenericHyperlink> findExtensionMatches(IRegion hyperlinkRegion, String hyperlinkedWord, IXtendXpandProject project, IXtendXpandResource xtendResource, List<GenericHyperlink> links, int paramListLength) {
        List<Extension> extmatches = XtendXpandSearchEngine.findExtensionsByNameInResourceAndImports(project, hyperlinkedWord, xtendResource);
        for (Extension ext : extmatches) {
            if (ext.getFormalParameters().size() != paramListLength && paramListLength + 1 != ext.getFormalParameters().size()) continue;
            SearchMatch match = new SearchMatch(ext.getStart(), ext.getEnd() - ext.getStart() + 1, this.getXXResourceByName(ext.getFileName(), "ext").getUnderlyingStorage());
            GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), match, hyperlinkRegion, this.computeHyperlinkLabel(hyperlinkedWord, ext.getReturnTypeIdentifier() == null ? null : ext.getReturnTypeIdentifier().getValue(), ext.getFormalParameters(), this.getXXResourceByName(ext.getFileName(), "ext")));
            links.add(genericHyperlink);
        }
        return links;
    }

    protected List<GenericHyperlink> createHyperlinkToImportedExtensions(IXtendXpandResource resource, IRegion region, String hyperlinkedName) {
        ArrayList<GenericHyperlink> links = new ArrayList<GenericHyperlink>();
        IXtendXpandResource xxresource = null;
        if (resource.getExtXptResource() instanceof ExtensionFile) {
            ExtensionFile extensionFile = (ExtensionFile)resource.getExtXptResource();
            for (ExtensionImportStatement importStatement : extensionFile.getExtImports()) {
                if (!importStatement.getImportedId().getValue().contains(hyperlinkedName) || importStatement.getStart() > region.getOffset() || importStatement.getEnd() < region.getOffset() + region.getLength() || (xxresource = Activator.getExtXptModelManager().findXtendXpandResource(importStatement.getImportedId().getValue(), "ext")) == null) continue;
                GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), new SearchMatch(0, 0, xxresource.getUnderlyingStorage()), (IRegion)new Region(importStatement.getImportedId().getStart(), importStatement.getImportedId().getEnd() - importStatement.getImportedId().getStart() + 1), importStatement.getImportedId().getValue());
                links.add(genericHyperlink);
            }
        }
        if (resource.getExtXptResource() instanceof Template) {
            Template template = (Template)resource.getExtXptResource();
            ExtensionImportDeclaration[] extensionImportDeclarationArray = template.getExtensions();
            int n = extensionImportDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExtensionImportStatement importStatement;
                importStatement = extensionImportDeclarationArray[n2];
                if (importStatement.getImportString().getValue().contains(hyperlinkedName) && importStatement.getStart() <= region.getOffset() && importStatement.getEnd() >= region.getOffset() + region.getLength() && (xxresource = Activator.getExtXptModelManager().findXtendXpandResource(importStatement.getImportString().getValue(), "ext")) != null) {
                    GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), new SearchMatch(0, 0, xxresource.getUnderlyingStorage()), (IRegion)new Region(importStatement.getImportString().getStart(), importStatement.getImportString().getEnd() - importStatement.getImportString().getStart() + 1), importStatement.getImportString().getValue());
                    links.add(genericHyperlink);
                }
                ++n2;
            }
        }
        return links;
    }
}

