/*
 * Copyright (c) Robert Bosch GmbH. All rights reserved.
 */
package org.eclipse.xtend.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;

/**
 * @author karsten.thoms@itemis.de
 *
 */
public class LoggingNullEvaluationHandler implements NullEvaluationHandler {
	private Log log = LogFactory.getLog(LoggingNullEvaluationHandler.class);

	public enum Level {
		OFF, TRACE, DEBUG, INFO, WARN, ERROR, FATAL
	}

	private Level level = Level.ERROR;

	/**
	 * {@inheritDoc}
	 */
	public Object handleNullEvaluation(final SyntaxElement element,
			final ExecutionContext ctx) {
		CharSequence msg = null;
		if (isLevelEnabled()) {
			msg = buildMessage(element, ctx);
		}
		switch (this.level) {
		case FATAL:
			this.log.fatal(msg);
			break;
		case ERROR:
			this.log.error(msg);
			break;
		case WARN:
			this.log.warn(msg);
			break;
		case INFO:
			this.log.info(msg);
			break;
		case DEBUG:
			this.log.debug(msg);
			break;
		case TRACE:
			this.log.trace(msg);
			break;
		}
		return null;
	}

	private boolean isLevelEnabled() {
		switch (this.level) {
		case FATAL:
			return this.log.isFatalEnabled();
		case ERROR:
			return this.log.isErrorEnabled();
		case WARN:
			return this.log.isWarnEnabled();
		case INFO:
			return this.log.isInfoEnabled();
		case DEBUG:
			return this.log.isDebugEnabled();
		case TRACE:
			return this.log.isTraceEnabled();
		default:
			return false;
		}
	}

	public void setLogCategory(final String category) {
		this.log = LogFactory.getLog(category);
	}

	public void setLevel(final Level level) {
		this.level = level;
	}

	protected CharSequence buildMessage(final SyntaxElement element,
			final ExecutionContext ctx) {
		StringBuilder msg = new StringBuilder();
		msg.append("null evaluation in ").append(element.getFileName())
				.append(" on line ").append(element.getLine()).append(" '")
				.append(element).append("'");

		return msg;
	}
}
