/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xpand.plugin;

import java.util.List;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.middleend.xpand.internal.XpandConverterUtil;
import org.eclipse.xtend.middleend.xtend.internal.OldTypeAnalyzer;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XpandDefinitionName {
    private final String _canonicalDefinitionName;
    private final String _canonicalTemplateFileName;

    public XpandDefinitionName(XpandDefinition def) {
        this._canonicalTemplateFileName = def.getFileName();
        this._canonicalDefinitionName = String.valueOf(this._canonicalTemplateFileName.substring(0, this._canonicalTemplateFileName.length() - 4).replaceAll("/", "::")) + "::" + def.getName();
    }

    public XpandDefinitionName(String rawDefName, Type targetType, Type[] argTypes, XpandExecutionContext ctx) {
        this(XpandConverterUtil.findDefinition(ctx, rawDefName, targetType, argTypes));
    }

    public XpandDefinitionName(String rawDefName, Expression target, List<Expression> args, XpandExecutionContext ctx) {
        this(rawDefName, XpandDefinitionName.typeForTargetExpression(target, ctx), XpandDefinitionName.typesForArgExpressions(args, ctx), ctx);
    }

    private static Type typeForTargetExpression(Expression target, XpandExecutionContext ctx) {
        if (target == null) {
            target = new FeatureCall(new Identifier("this"), null);
        }
        return new OldTypeAnalyzer().analyze((ExecutionContext)ctx, target);
    }

    private static Type[] typesForArgExpressions(List<Expression> args, XpandExecutionContext ctx) {
        Type[] result = new Type[args.size()];
        int i = 0;
        while (i < args.size()) {
            result[i] = new OldTypeAnalyzer().analyze((ExecutionContext)ctx, args.get(i));
            ++i;
        }
        return result;
    }

    public String getCanonicalDefinitionName() {
        return this._canonicalDefinitionName;
    }

    public String getCanonicalTemplateFileName() {
        return this._canonicalTemplateFileName;
    }

    public String toString() {
        return this._canonicalDefinitionName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._canonicalDefinitionName == null ? 0 : this._canonicalDefinitionName.hashCode());
        result = 31 * result + (this._canonicalTemplateFileName == null ? 0 : this._canonicalTemplateFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XpandDefinitionName other = (XpandDefinitionName)obj;
        if (this._canonicalDefinitionName == null ? other._canonicalDefinitionName != null : !this._canonicalDefinitionName.equals(other._canonicalDefinitionName)) {
            return false;
        }
        return !(this._canonicalTemplateFileName == null ? other._canonicalTemplateFileName != null : !this._canonicalTemplateFileName.equals(other._canonicalTemplateFileName));
    }
}

