/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.MetamodelContributor;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.StorageFinder;
import org.eclipse.xtend.shared.ui.StorageFinder2;
import org.eclipse.xtend.shared.ui.core.IModelManager;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.core.internal.XtendXpandModelManager;
import org.eclipse.xtend.shared.ui.core.metamodel.Contributor;
import org.eclipse.xtend.shared.ui.core.metamodel.MetamodelContributorRegistry;
import org.eclipse.xtend.shared.ui.expression.XpandPluginExecutionContext;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.typesystem.MetaModel;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    private static final String RESOURCE_CONTRIBUTOR_ID = "org.eclipse.xtend.shared.ui.resourceContributor";
    private static final String STORAGE_FINDER_ID = "org.eclipse.xtend.shared.ui.storageFinder";
    public static final String PLUGIN_ID = "org.eclipse.xtend.shared.ui";
    private static Activator plugin;
    private static HashMap<String, ResourceContributor> contributors;
    private static List<StorageFinder> storageFinder;
    private IModelManager modelManager;
    private final Set<Pattern> whitelistedJars = new HashSet<Pattern>();
    private final Set<Pattern> blacklistedJars = new HashSet<Pattern>();
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Job job = new Job(Messages.Activator_AnalyzingProgress){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                Activator.getExtXptModelManager().analyze(monitor);
                            }
                        }.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        XtendLog.logError(e);
                    }
                    catch (InterruptedException e) {
                        XtendLog.logError(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    };

    public static final String getNatureId() {
        return XtendXpandNature.NATURE_ID;
    }

    public Activator() {
        plugin = this;
        this.modelManager = new XtendXpandModelManager();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().addPropertyChangeListener(this.listener);
        Map<String, Contributor> registeredMetamodelContributors = MetamodelContributorRegistry.getRegisteredMetamodelContributors();
        for (Contributor c : registeredMetamodelContributors.values()) {
            c.getMetaModelContributor();
        }
        this.addToJarBlacklist("resources\\.jar");
        this.addToJarBlacklist("rt\\.jar");
        this.addToJarBlacklist("jsse\\.jar");
        this.addToJarBlacklist("jce\\.jar");
        this.addToJarBlacklist("charsets\\.jar");
        this.addToJarBlacklist("jfr\\.jar");
        this.addToJarBlacklist("dnsns\\.jar");
        this.addToJarBlacklist("localedata\\.jar");
        this.addToJarBlacklist("sunec\\.jar");
        this.addToJarBlacklist("sunjce_provider\\.jar");
        this.addToJarBlacklist("sunmscapi\\.jar");
        this.addToJarBlacklist("zipfs\\.jar");
        this.addToJarBlacklist("org\\.eclipse\\.core\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.emf\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.osgi\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.equinox\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.xtend\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.xpand\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.jdt\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.jface\\..*");
        this.addToJarBlacklist("org\\.eclipse\\.text\\..*");
        this.addToJarBlacklist("org\\.apache\\.commons\\..*");
        this.addToJarBlacklist("org\\.apache\\.log4j\\..*");
        this.addToJarBlacklist("com\\.ibm\\.icu\\..*");
        this.addToJarBlacklist("antlr-.*");
        this.addToJarBlacklist("runtime_registry_compatibility.jar");
        this.addToJarWhitelist("org\\.eclipse\\.xtend\\.util\\.stdlib.*");
        this.addToJarWhitelist("org\\.eclipse\\.xpand\\.examples\\..*");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener(this.listener);
        plugin = null;
        this.modelManager = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)Activator.getId(), (String)path);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static ResourceContributor[] getRegisteredResourceContributors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(RESOURCE_CONTRIBUTOR_ID);
        HashSet<ResourceContributor> contrs = new HashSet<ResourceContributor>();
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configs;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        contrs.add((ResourceContributor)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        XtendLog.logError(e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return contrs.toArray(new ResourceContributor[contrs.size()]);
    }

    public static List<StorageFinder> getRegisteredStorageFinder() {
        if (storageFinder == null) {
            storageFinder = new ArrayList<StorageFinder>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(STORAGE_FINDER_ID);
            if (point != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = point.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] configs;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
                    int n3 = configs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        try {
                            storageFinder.add((StorageFinder)element.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            XtendLog.logError(e);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            Collections.sort(storageFinder, new Comparator<StorageFinder>(){

                @Override
                public int compare(StorageFinder stoFinder1, StorageFinder stoFinder2) {
                    if (stoFinder1 == null) {
                        return 1;
                    }
                    if (stoFinder2 == null) {
                        return -1;
                    }
                    return stoFinder1.getPriority() - stoFinder2.getPriority();
                }
            });
        }
        return storageFinder;
    }

    public static IStorage findStorage(IJavaProject project, ResourceID id, boolean searchJars) {
        List<StorageFinder> stoFinders = Activator.getRegisteredStorageFinder();
        IStorage storage = null;
        if (stoFinders != null) {
            for (StorageFinder stoFinder : stoFinders) {
                storage = stoFinder.findStorage(project, id, searchJars);
                if (storage == null) continue;
                return storage;
            }
        }
        return storage;
    }

    public static ResourceID findXtendXpandResourceID(IJavaProject project, IStorage file) {
        List<StorageFinder> stoFinders = Activator.getRegisteredStorageFinder();
        ResourceID resourceID = null;
        if (stoFinders != null) {
            for (StorageFinder stoFinder : stoFinders) {
                if (!(stoFinder instanceof StorageFinder2 ? (resourceID = ((StorageFinder2)stoFinder).findXtendXpandResourceID(project, file)) != null : (resourceID = JDTUtil.findXtendXpandResourceID(project, file)) != null)) continue;
                return resourceID;
            }
        }
        return resourceID;
    }

    public static IModelManager getExtXptModelManager() {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            return activator.modelManager;
        }
        return null;
    }

    public static ExecutionContext getExecutionContext(IJavaProject project) {
        IXtendXpandProject xp = Activator.getExtXptModelManager().findProject(project.getPath());
        XpandPluginExecutionContext ctx = new XpandPluginExecutionContext(xp);
        List<? extends MetamodelContributor> contr = MetamodelContributorRegistry.getActiveMetamodelContributors(project);
        for (MetamodelContributor metamodelContributor : contr) {
            MetaModel[] metamodels;
            MetaModel[] metaModelArray = metamodels = metamodelContributor.getMetamodels(project, (TypeSystem)ctx);
            int n = metamodels.length;
            int n2 = 0;
            while (n2 < n) {
                MetaModel metamodel = metaModelArray[n2];
                ctx.registerMetaModel(metamodel);
                ++n2;
            }
        }
        return ctx;
    }

    public static final boolean isXtendFile(Object object) {
        if (object instanceof IFile) {
            return "ext".equals(((IFile)object).getFileExtension());
        }
        return false;
    }

    public static ResourceContributor getRegisteredResourceContributorFor(String fileExtension) {
        if (contributors == null) {
            contributors = new HashMap();
            ResourceContributor[] resourceContributorArray = Activator.getRegisteredResourceContributors();
            int n = resourceContributorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor contr = resourceContributorArray[n2];
                contributors.put(contr.getFileExtension(), contr);
                ++n2;
            }
        }
        return contributors.get(fileExtension);
    }

    public static void logError(String string, Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, string, (Throwable)e));
    }

    public void addToJarWhitelist(String pattern) {
        this.whitelistedJars.add(Pattern.compile(pattern));
    }

    public void addToJarBlacklist(String pattern) {
        this.blacklistedJars.add(Pattern.compile(pattern));
    }

    public boolean isBlacklistedJar(String jarName) {
        for (Pattern p : this.whitelistedJars) {
            if (!p.matcher(jarName).matches()) continue;
            return false;
        }
        for (Pattern p : this.blacklistedJars) {
            if (!p.matcher(jarName).matches()) continue;
            return true;
        }
        return false;
    }
}

